/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc.ticketgrant;

import java.util.ArrayList;
import java.util.Collections;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.kdc.KdcConfiguration;
import org.apache.directory.server.kerberos.kdc.ticketgrant.TicketGrantingContext;
import org.apache.directory.server.kerberos.shared.crypto.encryption.CipherTextHandler;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KeyUsage;
import org.apache.directory.server.kerberos.shared.crypto.encryption.RandomKeyFactory;
import org.apache.directory.server.kerberos.shared.exceptions.ErrorType;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.messages.Encodable;
import org.apache.directory.server.kerberos.shared.messages.KdcRequest;
import org.apache.directory.server.kerberos.shared.messages.components.Authenticator;
import org.apache.directory.server.kerberos.shared.messages.components.EncTicketPart;
import org.apache.directory.server.kerberos.shared.messages.components.EncTicketPartModifier;
import org.apache.directory.server.kerberos.shared.messages.components.Ticket;
import org.apache.directory.server.kerberos.shared.messages.value.AuthorizationData;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptedData;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosTime;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;

public class GenerateTicket
implements IoHandlerCommand {
    private String contextKey = "context";

    public void execute(IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        TicketGrantingContext tgsContext = (TicketGrantingContext)session.getAttribute(this.getContextKey());
        KdcRequest request = tgsContext.getRequest();
        Ticket tgt = tgsContext.getTgt();
        Authenticator authenticator = tgsContext.getAuthenticator();
        CipherTextHandler cipherTextHandler = tgsContext.getCipherTextHandler();
        KerberosPrincipal ticketPrincipal = request.getServerPrincipal();
        EncryptionType encryptionType = tgsContext.getEncryptionType();
        EncryptionKey serverKey = (EncryptionKey)tgsContext.getRequestPrincipalEntry().getKeyMap().get(encryptionType);
        KdcConfiguration config = tgsContext.getConfig();
        EncTicketPartModifier newTicketBody = new EncTicketPartModifier();
        newTicketBody.setClientAddresses(tgt.getClientAddresses());
        this.processFlags(config, request, tgt, newTicketBody);
        EncryptionKey sessionKey = RandomKeyFactory.getRandomKey((EncryptionType)tgsContext.getEncryptionType());
        newTicketBody.setSessionKey(sessionKey);
        newTicketBody.setClientPrincipal(tgt.getClientPrincipal());
        if (request.getEncAuthorizationData() != null) {
            AuthorizationData authData = (AuthorizationData)cipherTextHandler.unseal(AuthorizationData.class, authenticator.getSubSessionKey(), request.getEncAuthorizationData(), KeyUsage.NUMBER4);
            authData.add(tgt.getAuthorizationData());
            newTicketBody.setAuthorizationData(authData);
        }
        this.processTransited(newTicketBody, tgt);
        this.processTimes(config, request, newTicketBody, tgt);
        EncTicketPart ticketPart = newTicketBody.getEncTicketPart();
        if (request.getOption(28)) {
            throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
        }
        EncryptedData encryptedData = cipherTextHandler.seal(serverKey, (Encodable)ticketPart, KeyUsage.NUMBER2);
        Ticket newTicket = new Ticket(ticketPrincipal, encryptedData);
        newTicket.setEncTicketPart(ticketPart);
        tgsContext.setNewTicket(newTicket);
        next.execute(session, message);
    }

    private void processFlags(KdcConfiguration config, KdcRequest request, Ticket tgt, EncTicketPartModifier newTicketBody) throws KerberosException {
        if (tgt.getFlag(10)) {
            newTicketBody.setFlag(10);
        }
        if (request.getOption(1)) {
            if (!config.isForwardableAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            if (!tgt.getFlag(1)) {
                throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
            }
            newTicketBody.setFlag(1);
        }
        if (request.getOption(2)) {
            if (!config.isForwardableAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            if (!tgt.getFlag(1)) {
                throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
            }
            if (request.getAddresses() != null && request.getAddresses().getAddresses() != null && request.getAddresses().getAddresses().length > 0) {
                newTicketBody.setClientAddresses(request.getAddresses());
            } else if (!config.isEmptyAddressesAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            newTicketBody.setFlag(2);
        }
        if (tgt.getFlag(2)) {
            newTicketBody.setFlag(2);
        }
        if (request.getOption(3)) {
            if (!config.isProxiableAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            if (!tgt.getFlag(3)) {
                throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
            }
            newTicketBody.setFlag(3);
        }
        if (request.getOption(4)) {
            if (!config.isProxiableAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            if (!tgt.getFlag(3)) {
                throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
            }
            if (request.getAddresses() != null && request.getAddresses().getAddresses() != null && request.getAddresses().getAddresses().length > 0) {
                newTicketBody.setClientAddresses(request.getAddresses());
            } else if (!config.isEmptyAddressesAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            newTicketBody.setFlag(4);
        }
        if (request.getOption(5)) {
            if (!config.isPostdatedAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            if (!tgt.getFlag(5)) {
                throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
            }
            newTicketBody.setFlag(5);
        }
        if (request.getOption(6)) {
            if (!config.isPostdatedAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            if (!tgt.getFlag(5)) {
                throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
            }
            newTicketBody.setFlag(6);
            newTicketBody.setFlag(7);
            newTicketBody.setStartTime(request.getFrom());
        }
        if (request.getOption(31)) {
            KerberosTime startTime;
            if (!config.isPostdatedAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            if (!tgt.getFlag(7)) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            KerberosTime kerberosTime = startTime = tgt.getStartTime() != null ? tgt.getStartTime() : tgt.getAuthTime();
            if (startTime.greaterThan(new KerberosTime())) {
                throw new KerberosException(ErrorType.KRB_AP_ERR_TKT_NYV);
            }
            this.echoTicket(newTicketBody, tgt);
            newTicketBody.clearFlag(7);
        }
        if (request.getOption(0)) {
            throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
        }
    }

    private void processTimes(KdcConfiguration config, KdcRequest request, EncTicketPartModifier newTicketBody, Ticket tgt) throws KerberosException {
        KerberosTime now = new KerberosTime();
        newTicketBody.setAuthTime(tgt.getAuthTime());
        KerberosTime startTime = request.getFrom();
        if (startTime == null || startTime.lessThan(now) || startTime.isInClockSkew(config.getAllowableClockSkew()) && !request.getOption(6)) {
            startTime = now;
        }
        if (!(startTime == null || !startTime.greaterThan(now) || startTime.isInClockSkew(config.getAllowableClockSkew()) || request.getOption(6) && tgt.getFlag(5))) {
            throw new KerberosException(ErrorType.KDC_ERR_CANNOT_POSTDATE);
        }
        KerberosTime renewalTime = null;
        KerberosTime kerberosEndTime = null;
        if (request.getOption(30)) {
            if (!config.isRenewableAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            if (!tgt.getFlag(8)) {
                throw new KerberosException(ErrorType.KDC_ERR_BADOPTION);
            }
            if (tgt.getRenewTill().lessThan(now)) {
                throw new KerberosException(ErrorType.KRB_AP_ERR_TKT_EXPIRED);
            }
            this.echoTicket(newTicketBody, tgt);
            newTicketBody.setStartTime(now);
            KerberosTime tgtStartTime = tgt.getStartTime() != null ? tgt.getStartTime() : tgt.getAuthTime();
            long oldLife = tgt.getEndTime().getTime() - tgtStartTime.getTime();
            kerberosEndTime = new KerberosTime(Math.min(tgt.getRenewTill().getTime(), now.getTime() + oldLife));
            newTicketBody.setEndTime(kerberosEndTime);
        } else {
            if (newTicketBody.getEncTicketPart().getStartTime() == null) {
                newTicketBody.setStartTime(now);
            }
            KerberosTime till = request.getTill().isZero() ? KerberosTime.INFINITY : request.getTill();
            ArrayList<KerberosTime> minimizer = new ArrayList<KerberosTime>();
            minimizer.add(till);
            minimizer.add(new KerberosTime(startTime.getTime() + config.getMaximumTicketLifetime()));
            minimizer.add(tgt.getEndTime());
            kerberosEndTime = (KerberosTime)Collections.min(minimizer);
            newTicketBody.setEndTime(kerberosEndTime);
            if (request.getOption(27) && kerberosEndTime.lessThan(request.getTill()) && tgt.getFlag(8)) {
                if (!config.isRenewableAllowed()) {
                    throw new KerberosException(ErrorType.KDC_ERR_POLICY);
                }
                request.setOption(8);
                long rtime = Math.min(request.getTill().getTime(), tgt.getRenewTill().getTime());
                renewalTime = new KerberosTime(rtime);
            }
        }
        if (renewalTime == null) {
            renewalTime = request.getRtime();
        }
        KerberosTime rtime = renewalTime != null && renewalTime.isZero() ? KerberosTime.INFINITY : renewalTime;
        if (request.getOption(8) && tgt.getFlag(8)) {
            if (!config.isRenewableAllowed()) {
                throw new KerberosException(ErrorType.KDC_ERR_POLICY);
            }
            newTicketBody.setFlag(8);
            ArrayList<KerberosTime> minimizer = new ArrayList<KerberosTime>();
            if (rtime != null) {
                minimizer.add(rtime);
            }
            minimizer.add(new KerberosTime(startTime.getTime() + config.getMaximumRenewableLifetime()));
            minimizer.add(tgt.getRenewTill());
            newTicketBody.setRenewTill((KerberosTime)Collections.min(minimizer));
        }
        if (kerberosEndTime.lessThan(startTime)) {
            throw new KerberosException(ErrorType.KDC_ERR_NEVER_VALID);
        }
        long ticketLifeTime = Math.abs(startTime.getTime() - kerberosEndTime.getTime());
        if (ticketLifeTime < config.getAllowableClockSkew()) {
            throw new KerberosException(ErrorType.KDC_ERR_NEVER_VALID);
        }
    }

    private void processTransited(EncTicketPartModifier newTicketBody, Ticket tgt) {
        newTicketBody.setTransitedEncoding(tgt.getTransitedEncoding());
    }

    protected void echoTicket(EncTicketPartModifier newTicketBody, Ticket tgt) {
        newTicketBody.setAuthorizationData(tgt.getAuthorizationData());
        newTicketBody.setAuthTime(tgt.getAuthTime());
        newTicketBody.setClientAddresses(tgt.getClientAddresses());
        newTicketBody.setClientPrincipal(tgt.getClientPrincipal());
        newTicketBody.setEndTime(tgt.getEndTime());
        newTicketBody.setFlags(tgt.getFlags());
        newTicketBody.setRenewTill(tgt.getRenewTill());
        newTicketBody.setSessionKey(tgt.getSessionKey());
        newTicketBody.setTransitedEncoding(tgt.getTransitedEncoding());
    }

    protected String getContextKey() {
        return this.contextKey;
    }
}

