/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc.ticketgrant;

import java.net.InetAddress;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.kdc.ticketgrant.TicketGrantingContext;
import org.apache.directory.server.kerberos.shared.crypto.checksum.ChecksumType;
import org.apache.directory.server.kerberos.shared.crypto.encryption.EncryptionType;
import org.apache.directory.server.kerberos.shared.messages.components.Ticket;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.messages.value.HostAddress;
import org.apache.directory.server.kerberos.shared.messages.value.HostAddresses;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorContext
implements IoHandlerCommand {
    private static final Logger log = LoggerFactory.getLogger(MonitorContext.class);
    private String serviceName;
    private String contextKey = "context";

    public MonitorContext(String serviceName) {
        this.serviceName = serviceName;
    }

    public void execute(IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        if (log.isDebugEnabled()) {
            try {
                TicketGrantingContext tgsContext = (TicketGrantingContext)session.getAttribute(this.getContextKey());
                Ticket tgt = tgsContext.getTgt();
                long clockSkew = tgsContext.getConfig().getAllowableClockSkew();
                ChecksumType checksumType = tgsContext.getAuthenticator().getChecksum().getChecksumType();
                InetAddress clientAddress = tgsContext.getClientAddress();
                HostAddresses clientAddresses = tgt.getClientAddresses();
                boolean caddrContainsSender = false;
                if (tgt.getClientAddresses() != null) {
                    caddrContainsSender = tgt.getClientAddresses().contains(new HostAddress(clientAddress));
                }
                StringBuffer sb = new StringBuffer();
                sb.append("Monitoring " + this.serviceName + " context:");
                sb.append("\n\tclockSkew              " + clockSkew);
                sb.append("\n\tchecksumType           " + checksumType);
                sb.append("\n\tclientAddress          " + clientAddress);
                sb.append("\n\tclientAddresses        " + clientAddresses);
                sb.append("\n\tcaddr contains sender  " + caddrContainsSender);
                KerberosPrincipal requestServerPrincipal = tgsContext.getRequest().getServerPrincipal();
                PrincipalStoreEntry requestPrincipal = tgsContext.getRequestPrincipalEntry();
                sb.append("\n\tprincipal              " + requestServerPrincipal);
                sb.append("\n\tcn                     " + requestPrincipal.getCommonName());
                sb.append("\n\trealm                  " + requestPrincipal.getRealmName());
                sb.append("\n\tprincipal              " + requestPrincipal.getPrincipal());
                sb.append("\n\tSAM type               " + requestPrincipal.getSamType());
                KerberosPrincipal ticketServerPrincipal = tgsContext.getTgt().getServerPrincipal();
                PrincipalStoreEntry ticketPrincipal = tgsContext.getTicketPrincipalEntry();
                sb.append("\n\tprincipal              " + ticketServerPrincipal);
                sb.append("\n\tcn                     " + ticketPrincipal.getCommonName());
                sb.append("\n\trealm                  " + ticketPrincipal.getRealmName());
                sb.append("\n\tprincipal              " + ticketPrincipal.getPrincipal());
                sb.append("\n\tSAM type               " + ticketPrincipal.getSamType());
                EncryptionType encryptionType = tgsContext.getTgt().getEncPart().getEncryptionType();
                int keyVersion = ((EncryptionKey)ticketPrincipal.getKeyMap().get(encryptionType)).getKeyVersion();
                sb.append("\n\tTicket key type        " + encryptionType);
                sb.append("\n\tService key version    " + keyVersion);
                log.debug(sb.toString());
            }
            catch (Exception e) {
                log.error("Error in context monitor", (Throwable)e);
            }
        }
        next.execute(session, message);
    }

    protected String getContextKey() {
        return this.contextKey;
    }
}

