/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc.ticketgrant;

import org.apache.directory.server.kerberos.kdc.KdcConfiguration;
import org.apache.directory.server.kerberos.kdc.ticketgrant.TicketGrantingContext;
import org.apache.directory.server.kerberos.shared.crypto.checksum.ChecksumHandler;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KeyUsage;
import org.apache.directory.server.kerberos.shared.exceptions.ErrorType;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.messages.value.Checksum;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyBodyChecksum
implements IoHandlerCommand {
    private static final Logger log = LoggerFactory.getLogger(VerifyBodyChecksum.class);
    private ChecksumHandler checksumHandler = new ChecksumHandler();
    private String contextKey = "context";

    public void execute(IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        TicketGrantingContext tgsContext = (TicketGrantingContext)session.getAttribute(this.getContextKey());
        KdcConfiguration config = tgsContext.getConfig();
        if (config.isBodyChecksumVerified()) {
            byte[] bodyBytes = tgsContext.getRequest().getBodyBytes();
            Checksum authenticatorChecksum = tgsContext.getAuthenticator().getChecksum();
            if (authenticatorChecksum == null || authenticatorChecksum.getChecksumType() == null || authenticatorChecksum.getChecksumValue() == null || bodyBytes == null) {
                throw new KerberosException(ErrorType.KRB_AP_ERR_INAPP_CKSUM);
            }
            log.debug("Verifying body checksum type '{}'.", (Object)authenticatorChecksum.getChecksumType());
            this.checksumHandler.verifyChecksum(authenticatorChecksum, bodyBytes, null, KeyUsage.NUMBER8);
        }
        next.execute(session, message);
    }

    private String getContextKey() {
        return this.contextKey;
    }
}

