/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.kdc.ticketgrant;

import org.apache.directory.server.kerberos.kdc.KdcConfiguration;
import org.apache.directory.server.kerberos.kdc.ticketgrant.TicketGrantingContext;
import org.apache.directory.server.kerberos.shared.exceptions.ErrorType;
import org.apache.directory.server.kerberos.shared.exceptions.KerberosException;
import org.apache.directory.server.kerberos.shared.messages.components.Ticket;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.chain.IoHandlerCommand;

public class VerifyTgt
implements IoHandlerCommand {
    private String contextKey = "context";

    public void execute(IoHandlerCommand.NextCommand next, IoSession session, Object message) throws Exception {
        TicketGrantingContext tgsContext = (TicketGrantingContext)session.getAttribute(this.getContextKey());
        KdcConfiguration config = tgsContext.getConfig();
        Ticket tgt = tgsContext.getTgt();
        if (!tgt.getRealm().equals(config.getPrimaryRealm())) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_NOT_US);
        }
        String tgtServerName = tgt.getServerPrincipal().getName();
        String requestServerName = tgsContext.getRequest().getServerPrincipal().getName();
        if (!tgtServerName.equals(config.getServicePrincipal().getName()) && !tgtServerName.equals(requestServerName)) {
            throw new KerberosException(ErrorType.KRB_AP_ERR_NOT_US);
        }
        next.execute(session, message);
    }

    protected String getContextKey() {
        return this.contextKey;
    }
}

