/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.sam;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.security.auth.kerberos.KerberosKey;
import org.apache.directory.server.kerberos.sam.KeyIntegrityChecker;
import org.apache.directory.server.kerberos.sam.SamException;
import org.apache.directory.server.kerberos.sam.SamVerifier;
import org.apache.directory.server.kerberos.shared.messages.value.SamType;
import org.apache.directory.server.kerberos.shared.store.PrincipalStoreEntry;

public final class SamSubsystem {
    public static final String PROPKEY_BASE = "kerberos.sam.type.";
    public static SamSubsystem instance;
    private final Map<SamType, SamVerifier> verifiers = new HashMap<SamType, SamVerifier>();
    private KeyIntegrityChecker keyChecker;
    private DirContext userContext;
    private String userBaseRdn;

    public static SamSubsystem getInstance() {
        if (instance == null) {
            instance = new SamSubsystem();
        }
        return instance;
    }

    public void setIntegrityChecker(KeyIntegrityChecker keyChecker) {
        this.keyChecker = keyChecker;
    }

    public KerberosKey verify(PrincipalStoreEntry entry, byte[] sad) throws SamException {
        SamVerifier verifier = null;
        if (this.keyChecker == null) {
            throw new IllegalStateException("SamSubsystem not enabled with key integrity checker");
        }
        if (entry.getSamType() == null) {
            throw new SamException(entry.getSamType(), "Entry has null SAM type");
        }
        if (this.verifiers.containsKey(entry.getSamType())) {
            verifier = this.verifiers.get(entry.getSamType());
            return verifier.verify(entry.getPrincipal(), sad);
        }
        String key = PROPKEY_BASE + entry.getSamType().getOrdinal();
        Hashtable env = new Hashtable();
        try {
            env.putAll(this.userContext.getEnvironment());
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        if (!env.containsKey(key)) {
            String msg = "Could not find property '" + key + "'";
            throw new SamException(entry.getSamType(), msg);
        }
        String fqcn = (String)env.get(key);
        try {
            Class<?> c = Class.forName(fqcn);
            verifier = (SamVerifier)c.newInstance();
            try {
                verifier.setUserContext((DirContext)this.userContext.lookup(this.userBaseRdn));
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
            verifier.setIntegrityChecker(this.keyChecker);
            verifier.startup();
            if (!verifier.getSamType().equals(entry.getSamType())) {
                String msg = "Expecting entries with SAM type of " + verifier.getSamType();
                msg = msg + " but got a type of entry with SAM type of " + entry.getSamType();
                throw new SamException(entry.getSamType(), msg);
            }
            this.verifiers.put(verifier.getSamType(), verifier);
            return verifier.verify(entry.getPrincipal(), sad);
        }
        catch (ClassNotFoundException e) {
            String msg = "Could not find verifier class '" + fqcn;
            msg = msg + "' for SamType( " + entry.getSamType() + " ) ";
            throw new SamException(entry.getSamType(), msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = "No public default constructor on class '" + fqcn;
            msg = msg + "' for SamType( " + entry.getSamType() + " ) ";
            throw new SamException(entry.getSamType(), msg, e);
        }
        catch (InstantiationException e) {
            String msg = "Failed on default constructor invocation for class '" + fqcn;
            msg = msg + "' for SamType( " + entry.getSamType() + " ) ";
            throw new SamException(entry.getSamType(), msg, e);
        }
    }

    public void setUserContext(DirContext userContext, String userBaseRdn) {
        this.userContext = userContext;
        this.userBaseRdn = userBaseRdn;
    }
}

