/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.protocol.shared;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.protocol.shared.DatagramAcceptor;
import org.apache.directory.server.protocol.shared.ProtocolService;
import org.apache.directory.server.protocol.shared.SocketAcceptor;
import org.apache.directory.server.protocol.shared.TransportProtocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProtocolService
implements ProtocolService {
    private boolean started;
    private boolean enabled;
    private String serviceId;
    private String serviceName;
    private String ipAddress;
    private int ipPort = -1;
    private Set<TransportProtocol> transportProtocols;
    private DatagramAcceptor datagramAcceptor;
    private SocketAcceptor socketAcceptor;
    private DirectoryService directoryService;

    @Override
    public DirectoryService getDirectoryService() {
        return this.directoryService;
    }

    @Override
    public void setDirectoryService(DirectoryService directoryService) {
        this.directoryService = directoryService;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    protected void setStarted(boolean started) {
        this.started = started;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String getServiceId() {
        return this.serviceId;
    }

    @Override
    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public void setServiceName(String name) {
        this.serviceName = name;
    }

    @Override
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Override
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @Override
    public int getIpPort() {
        return this.ipPort;
    }

    @Override
    public void setIpPort(int ipPort) {
        if (ipPort < 0 || ipPort > 65535) {
            throw new IllegalArgumentException("Invalid port number: " + ipPort);
        }
        this.ipPort = ipPort;
    }

    @Override
    public Set<TransportProtocol> getTransportProtocols() {
        return this.transportProtocols;
    }

    @Override
    public void setTransportProtocols(Set<TransportProtocol> transportProtocols) {
        HashSet<TransportProtocol> copy = new HashSet<TransportProtocol>(transportProtocols.size());
        copy.addAll(transportProtocols);
        this.transportProtocols = Collections.unmodifiableSet(copy);
    }

    @Override
    public DatagramAcceptor getDatagramAcceptor() {
        return this.datagramAcceptor;
    }

    @Override
    public void setDatagramAcceptor(DatagramAcceptor datagramAcceptor) {
        this.datagramAcceptor = datagramAcceptor;
    }

    @Override
    public SocketAcceptor getSocketAcceptor() {
        return this.socketAcceptor;
    }

    @Override
    public void setSocketAcceptor(SocketAcceptor socketAcceptor) {
        this.socketAcceptor = socketAcceptor;
    }
}

