/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.ldap.client.api.NoVerificationTrustManager;

@Documented
@Inherited
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.TYPE})
public @interface CreateConsumer {
    public String remoteHost() default "localhost";

    public int remotePort() default 389;

    public String replUserDn();

    public String replUserPassword();

    public boolean refreshNPersist() default true;

    public long refreshInterval() default 60000L;

    public String baseDn();

    public String filter() default "(objectClass=*)";

    public String[] attributes() default {""};

    public int searchSizeLimit() default 0;

    public int searchTimeout() default 0;

    public SearchScope searchScope() default SearchScope.SUBTREE;

    public AliasDerefMode aliasDerefMode() default AliasDerefMode.NEVER_DEREF_ALIASES;

    public int replicaId();

    public String configEntryDn() default "";

    public boolean chaseReferrals() default false;

    public boolean useTls() default true;

    public boolean strictCertVerification() default true;

    public Class<?> trustManager() default NoVerificationTrustManager.class;
}

