/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.config.beans;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.server.config.ConfigurationElement;
import org.apache.directory.server.config.beans.AdsBaseBean;

public class TransportBean
extends AdsBaseBean {
    private static final int DEFAULT_BACKLOG_NB = 50;
    private static final int DEFAULT_NB_THREADS = 3;
    @ConfigurationElement(attributeType="ads-transportId", isRdn=true)
    private String transportId;
    @ConfigurationElement(attributeType="ads-transportAddress")
    private String transportAddress;
    @ConfigurationElement(attributeType="ads-systemPort")
    private int systemPort = -1;
    @ConfigurationElement(attributeType="ads-transportEnableSsl", isOptional=true, defaultValue="false")
    private boolean transportEnableSsl = false;
    @ConfigurationElement(attributeType="ads-transportNbThreads", isOptional=true, defaultValue="3")
    private int transportNbThreads = 3;
    @ConfigurationElement(attributeType="ads-transportBackLog", isOptional=true, defaultValue="50")
    private int transportBackLog = 50;
    @ConfigurationElement(attributeType="ads-enabledCiphers", isOptional=true)
    private List<String> enabledCiphers;
    @ConfigurationElement(attributeType="ads-enabledProtocols", isOptional=true)
    private List<String> enabledProtocols;
    @ConfigurationElement(attributeType="ads-needClientAuth", isOptional=true, defaultValue="false")
    private boolean needClientAuth;
    @ConfigurationElement(attributeType="ads-wantClientAuth", isOptional=true, defaultValue="false")
    private boolean wantClientAuth;

    public void setSystemPort(int systemPort) {
        this.systemPort = systemPort;
    }

    public int getSystemPort() {
        return this.systemPort;
    }

    public void setTransportAddress(String transportAddress) {
        this.transportAddress = transportAddress;
    }

    public String getTransportAddress() {
        return this.transportAddress;
    }

    public boolean isTransportEnableSSL() {
        return this.transportEnableSsl;
    }

    public void setTransportEnableSSL(boolean transportEnableSSL) {
        this.transportEnableSsl = transportEnableSSL;
    }

    public int getTransportNbThreads() {
        return this.transportNbThreads;
    }

    public void setTransportNbThreads(int transportNbThreads) {
        this.transportNbThreads = transportNbThreads;
    }

    public int getTransportBackLog() {
        return this.transportBackLog;
    }

    public void setTransportBackLog(int transportBacklog) {
        this.transportBackLog = transportBacklog;
    }

    public String getTransportId() {
        return this.transportId;
    }

    public void setTransportId(String transportId) {
        this.transportId = transportId;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    public boolean getWantClientAuth() {
        return this.wantClientAuth;
    }

    public List<String> getEnabledCiphers() {
        return this.enabledCiphers;
    }

    public void setEnabledCiphers(List<String> enabledCiphers) {
        this.enabledCiphers = enabledCiphers;
    }

    public void addEnabledCiphers(String ... enabledCiphers) {
        if (this.enabledCiphers == null) {
            this.enabledCiphers = new ArrayList<String>();
        }
        for (String enabledCipher : enabledCiphers) {
            this.enabledCiphers.add(enabledCipher);
        }
    }

    public List<String> getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(List<String> enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    public void addEnabledProtocols(String ... enabledProtocols) {
        if (this.enabledProtocols == null) {
            this.enabledProtocols = new ArrayList<String>();
        }
        for (String enabledProtocol : enabledProtocols) {
            this.enabledProtocols.add(enabledProtocol);
        }
    }

    @Override
    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.toString(tabs, "transport id", this.transportId));
        sb.append(tabs).append("transport address : ");
        if (this.transportAddress == null) {
            try {
                sb.append(InetAddress.getLocalHost().getHostName()).append('\n');
            }
            catch (UnknownHostException uhe) {
                sb.append("localhost").append('\n');
            }
        } else {
            sb.append(this.transportAddress).append('\n');
        }
        sb.append(tabs).append("transport port : ").append(this.systemPort).append('\n');
        sb.append(tabs).append("transport backlog : ").append(this.transportBackLog).append('\n');
        sb.append(tabs).append("transport nb threads : ").append(this.transportNbThreads).append('\n');
        sb.append(this.toString(tabs, "SSL enabled", this.transportEnableSsl));
        sb.append(this.toString(tabs, "Need Client Auth", this.needClientAuth));
        sb.append(this.toString(tabs, "Want Client Auth", this.wantClientAuth));
        if (this.enabledCiphers != null && this.enabledCiphers.size() > 0) {
            sb.append(tabs).append("Enabled Ciphers :\n");
            for (String enabledCipher : this.enabledCiphers) {
                sb.append(tabs).append("    ").append(enabledCipher).append("\n");
            }
        }
        if (this.enabledProtocols != null && this.enabledProtocols.size() > 0) {
            sb.append(tabs).append("  Enabled Protocols :\n");
            for (String enabledProtocol : this.enabledProtocols) {
                sb.append(tabs).append("    ").append(enabledProtocol).append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.toString("");
    }
}

