/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.integ;

import java.io.File;
import java.util.HashMap;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.integ.IntegrationUtils;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.handlers.bind.SimpleMechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.cramMD5.CramMd5MechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.digestMD5.DigestMd5MechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.gssapi.GssapiMechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.ntlm.NtlmMechanismHandler;
import org.apache.directory.server.ldap.handlers.extended.StartTlsHandler;
import org.apache.directory.server.ldap.handlers.extended.StoredProcedureExtendedOperationHandler;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.mina.util.AvailablePortFinder;

public interface LdapServerFactory {
    public static final LdapServerFactory DEFAULT = new LdapServerFactory(){

        public LdapServer newInstance() throws Exception {
            DefaultDirectoryService service = new DefaultDirectoryService();
            IntegrationUtils.doDelete((File)service.getWorkingDirectory());
            service.getChangeLog().setEnabled(true);
            service.setShutdownHookEnabled(false);
            LdapServer ldapServer = new LdapServer();
            ldapServer.setDirectoryService((DirectoryService)service);
            int port = AvailablePortFinder.getNextAvailable((int)1024);
            ldapServer.setTransports(new Transport[]{new TcpTransport(port, 3)});
            ldapServer.addExtendedOperationHandler((ExtendedOperationHandler)new StartTlsHandler());
            ldapServer.addExtendedOperationHandler((ExtendedOperationHandler)new StoredProcedureExtendedOperationHandler());
            HashMap<String, Object> mechanismHandlerMap = new HashMap<String, Object>();
            mechanismHandlerMap.put("PLAIN", new SimpleMechanismHandler());
            CramMd5MechanismHandler cramMd5MechanismHandler = new CramMd5MechanismHandler();
            mechanismHandlerMap.put("CRAM-MD5", cramMd5MechanismHandler);
            DigestMd5MechanismHandler digestMd5MechanismHandler = new DigestMd5MechanismHandler();
            mechanismHandlerMap.put("DIGEST-MD5", digestMd5MechanismHandler);
            GssapiMechanismHandler gssapiMechanismHandler = new GssapiMechanismHandler();
            mechanismHandlerMap.put("GSSAPI", gssapiMechanismHandler);
            NtlmMechanismHandler ntlmMechanismHandler = new NtlmMechanismHandler();
            mechanismHandlerMap.put("NTLM", ntlmMechanismHandler);
            mechanismHandlerMap.put("GSS-SPNEGO", ntlmMechanismHandler);
            ldapServer.setSaslMechanismHandlers(mechanismHandlerMap);
            return ldapServer;
        }
    };

    public LdapServer newInstance() throws Exception;
}

