/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.add;

import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.integ.ServerIntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.shared.ldap.model.cursor.EntryCursor;
import org.apache.directory.shared.ldap.model.entry.DefaultEntry;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.message.SearchScope;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateDS(enableChangeLog=false, name="DSAddAlias")
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
public class AddAliasIT
extends AbstractLdapTestUnit {
    private LdapConnection conn;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddAliasOnParent() throws Exception {
        try {
            this.conn = ServerIntegrationUtils.getClientApiConnection((LdapServer)AddAliasIT.getLdapServer());
            this.conn.setTimeOut(-1L);
            this.conn.add((Entry)new DefaultEntry("cn=foo,ou=system", new Object[]{"objectClass: person", "objectClass: top", "cn: foo", "sn: Foo"}));
            Assert.assertNotNull((Object)this.conn.lookup("cn=foo,ou=system"));
            this.conn.add((Entry)new DefaultEntry("ou=alias,cn=foo,ou=system", new Object[]{"objectClass: top", "objectClass: extensibleObject", "objectClass: alias", "ou: alias", "aliasedObjectName: cn=foo,ou=system", "description: alias to father (branch)"}));
            Assert.assertNotNull((Object)this.conn.lookup("ou=alias,cn=foo,ou=system"));
        }
        finally {
            this.conn.delete("ou=alias,cn=foo,ou=system");
            this.conn.delete("cn=foo,ou=system");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddAliasWithSubordinate() throws Exception {
        try {
            this.conn = ServerIntegrationUtils.getClientApiConnection((LdapServer)AddAliasIT.getLdapServer());
            this.conn.setTimeOut(-1L);
            this.conn.add((Entry)new DefaultEntry("cn=foo,ou=system", new Object[]{"objectClass: person", "objectClass: top", "cn: foo", "sn: Foo"}));
            Assert.assertNotNull((Object)this.conn.lookup("cn=foo,ou=system"));
            this.conn.add((Entry)new DefaultEntry("ou=alias,cn=foo,ou=system", new Object[]{"objectClass: top", "objectClass: extensibleObject", "objectClass: alias", "ou: alias", "aliasedObjectName: cn=foo,ou=system", "description: alias to father (branch)"}));
            Assert.assertNotNull((Object)this.conn.lookup("ou=alias,cn=foo,ou=system"));
            try {
                this.conn.add((Entry)new DefaultEntry("ou=aliasChild,ou=alias,cn=foo,ou=system", new Object[]{"objectClass: top", "objectClass: extensibleObject", "objectClass: alias", "ou: aliasChild", "aliasedObjectName: cn=foo,ou=system"}));
                Assert.fail();
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.assertTrue((boolean)true);
            }
            Assert.assertNotNull((Object)this.conn.lookup("ou=alias,cn=foo,ou=system"));
            Assert.assertNull((Object)this.conn.lookup("ou=aliasChild,ou=alias,cn=foo,ou=system"));
        }
        finally {
            this.conn.delete("ou=alias,cn=foo,ou=system");
            this.conn.delete("cn=foo,ou=system");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddAliasWithCycle() throws Exception {
        try {
            this.conn = ServerIntegrationUtils.getClientApiConnection((LdapServer)AddAliasIT.getLdapServer());
            this.conn.setTimeOut(-1L);
            this.conn.add((Entry)new DefaultEntry("cn=test,ou=system", new Object[]{"objectClass: person", "objectClass: top", "cn: test", "sn: Test"}));
            this.conn.add((Entry)new DefaultEntry("cn=foo,cn=test,ou=system", new Object[]{"objectClass: person", "objectClass: top", "cn: foo", "sn: Foo"}));
            this.conn.add((Entry)new DefaultEntry("cn=bar,cn=test,ou=system", new Object[]{"objectClass: person", "objectClass: top", "cn: bar", "sn: Bar"}));
            this.conn.add((Entry)new DefaultEntry("cn=doh,cn=test,ou=system", new Object[]{"objectClass: person", "objectClass: top", "cn: doh", "sn: Doh"}));
            this.conn.add((Entry)new DefaultEntry("cn=barAlias,cn=foo,cn=test,ou=system", new Object[]{"objectClass: top", "objectClass: extensibleObject", "objectClass: alias", "cn: barAlias", "aliasedObjectName: cn=bar,cn=test,ou=system", "description: alias to father (branch)"}));
            this.conn.add((Entry)new DefaultEntry("cn=dohAlias,cn=bar,cn=test,ou=system", new Object[]{"objectClass: top", "objectClass: extensibleObject", "objectClass: alias", "cn: dohAlias", "aliasedObjectName: cn=doh,cn=test,ou=system", "description: alias to father (branch)"}));
            EntryCursor cursor = this.conn.search("cn=foo,cn=test,ou=system", "(objectClass=*)", SearchScope.SUBTREE, new String[]{"*"});
            while (cursor.next()) {
                System.out.println(((Entry)cursor.get()).getDn());
            }
        }
        finally {
            this.conn.delete("cn=barAlias,cn=foo,cn=test,ou=system");
            this.conn.delete("cn=dohAlias,cn=bar,cn=test,ou=system");
            this.conn.delete("cn=foo,cn=test,ou=system");
            this.conn.delete("cn=bar,cn=test,ou=system");
            this.conn.delete("cn=doh,cn=test,ou=system");
            this.conn.delete("cn=test,ou=system");
        }
    }
}

