/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.replication;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreateIndex;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.factory.DSAnnotationProcessor;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.factory.ServerAnnotationProcessor;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.replication.ReplicationConsumerConfig;
import org.apache.directory.server.ldap.replication.ReplicationRequestHandler;
import org.apache.directory.server.ldap.replication.SyncReplConsumer;
import org.apache.directory.server.ldap.replication.SyncReplRequestHandler;
import org.apache.directory.server.ldap.replication.SyncreplConfiguration;
import org.apache.directory.shared.ldap.model.entry.DefaultEntry;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.message.ModifyRequest;
import org.apache.directory.shared.ldap.model.message.ModifyRequestImpl;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class ClientServerReplicationIT {
    private static LdapServer providerServer;
    private static LdapServer consumerServer;
    private static SchemaManager schemaManager;
    private static CoreSession providerSession;
    private static CoreSession consumerSession;
    private static AtomicInteger entryCount;

    @BeforeClass
    public static void setUp() throws Exception {
        Class<?> justLoadToSetControlProperties = Class.forName(FrameworkRunner.class.getName());
        ClientServerReplicationIT.startProvider();
        ClientServerReplicationIT.startConsumer();
    }

    @AfterClass
    public static void tearDown() {
        consumerServer.stop();
        providerServer.stop();
    }

    @Test
    public void testInjectContextEntry() throws Exception {
        String dn = "dc=example,dc=com";
        DefaultEntry entry = new DefaultEntry(schemaManager, dn);
        entry.add("objectClass", new String[]{"domain"});
        entry.add("dc", new String[]{"example"});
        Assert.assertFalse((boolean)consumerSession.exists(dn));
        providerSession.add((Entry)entry);
        this.waitAndCompareEntries(entry.getDn());
    }

    @Test
    public void testModify() throws Exception {
        Entry provUser = this.createEntry();
        Assert.assertFalse((boolean)consumerSession.exists(provUser.getDn()));
        providerSession.add(provUser);
        ModifyRequestImpl modReq = new ModifyRequestImpl();
        modReq.setName(provUser.getDn());
        modReq.add("userPassword", new String[]{"secret"});
        providerSession.modify((ModifyRequest)modReq);
        this.waitAndCompareEntries(provUser.getDn());
    }

    @Test
    public void testModDn() throws Exception {
        Entry provUser = this.createEntry();
        Assert.assertFalse((boolean)consumerSession.exists(provUser.getDn()));
        providerSession.add(provUser);
        Dn usersContainer = new Dn(schemaManager, new String[]{"ou=users,dc=example,dc=com"});
        DefaultEntry entry = new DefaultEntry(schemaManager, usersContainer);
        entry.add("objectClass", new String[]{"organizationalUnit"});
        entry.add("ou", new String[]{"users"});
        providerSession.add((Entry)entry);
        this.waitAndCompareEntries(entry.getDn());
        Dn userDn = provUser.getDn();
        providerSession.move(userDn, usersContainer);
        userDn = usersContainer.add(userDn.getRdn());
        this.waitAndCompareEntries(userDn);
        Rdn newName = new Rdn(schemaManager, userDn.getRdn().getName() + "renamed");
        providerSession.rename(userDn, newName, true);
        userDn = usersContainer.add(newName);
        this.waitAndCompareEntries(userDn);
        Dn newParent = usersContainer.getParent();
        newName = new Rdn(schemaManager, userDn.getRdn().getName() + "MovedAndRenamed");
        providerSession.moveAndRename(userDn, newParent, newName, false);
        userDn = newParent.add(newName);
        this.waitAndCompareEntries(userDn);
    }

    @Test
    public void testDelete() throws Exception {
        Entry provUser = this.createEntry();
        providerSession.add(provUser);
        this.waitAndCompareEntries(provUser.getDn());
        providerSession.delete(provUser.getDn());
        Thread.sleep(2000L);
        Assert.assertFalse((boolean)consumerSession.exists(provUser.getDn()));
    }

    @Test
    @Ignore(value="this test often fails due to a timing issue")
    public void testRebootConsumer() throws Exception {
        Entry provUser = this.createEntry();
        providerSession.add(provUser);
        this.waitAndCompareEntries(provUser.getDn());
        consumerServer.stop();
        Dn deletedUserDn = provUser.getDn();
        providerSession.delete(deletedUserDn);
        provUser = this.createEntry();
        Dn addedUserDn = provUser.getDn();
        providerSession.add(provUser);
        ClientServerReplicationIT.startConsumer();
        Thread.sleep(5000L);
        Assert.assertFalse((boolean)consumerSession.exists(deletedUserDn));
        this.waitAndCompareEntries(addedUserDn);
    }

    private void waitAndCompareEntries(Dn dn) throws Exception {
        Thread.sleep(2000L);
        Entry providerEntry = providerSession.lookup(dn, new String[]{"*", "+"});
        Entry consumerEntry = consumerSession.lookup(dn, new String[]{"*", "+"});
        Assert.assertEquals((Object)providerEntry, (Object)consumerEntry);
    }

    private Entry createEntry() throws Exception {
        String user = "user" + entryCount.incrementAndGet();
        String dn = "cn=" + user + ",dc=example,dc=com";
        DefaultEntry entry = new DefaultEntry(schemaManager, dn);
        entry.add("objectClass", new String[]{"person"});
        entry.add("cn", new String[]{user});
        entry.add("sn", new String[]{user});
        return entry;
    }

    @CreateDS(allowAnonAccess=true, name="provider-replication", partitions={@CreatePartition(name="example", suffix="dc=example,dc=com", indexes={@CreateIndex(attribute="objectClass"), @CreateIndex(attribute="dc"), @CreateIndex(attribute="ou")})})
    @CreateLdapServer(transports={@CreateTransport(port=16000, protocol="LDAP")})
    private static void startProvider() throws Exception {
        Method createProviderMethod = ClientServerReplicationIT.class.getDeclaredMethod("startProvider", new Class[0]);
        CreateDS dsAnnotation = createProviderMethod.getAnnotation(CreateDS.class);
        DirectoryService provDirService = DSAnnotationProcessor.createDS((CreateDS)dsAnnotation);
        CreateLdapServer serverAnnotation = createProviderMethod.getAnnotation(CreateLdapServer.class);
        providerServer = ServerAnnotationProcessor.instantiateLdapServer((CreateLdapServer)serverAnnotation, (DirectoryService)provDirService, (int)0);
        providerServer.setReplicationReqHandler((ReplicationRequestHandler)new SyncReplRequestHandler());
        Runnable r = new Runnable(){

            public void run() {
                try {
                    providerServer.start();
                    schemaManager = providerServer.getDirectoryService().getSchemaManager();
                    providerSession = providerServer.getDirectoryService().getAdminSession();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.start();
        t.join();
    }

    @CreateDS(allowAnonAccess=true, name="consumer-replication", partitions={@CreatePartition(name="example", suffix="dc=example,dc=com", indexes={@CreateIndex(attribute="objectClass"), @CreateIndex(attribute="dc"), @CreateIndex(attribute="ou")})})
    @CreateLdapServer(transports={@CreateTransport(port=17000, protocol="LDAP")})
    private static void startConsumer() throws Exception {
        Method createProviderMethod = ClientServerReplicationIT.class.getDeclaredMethod("startConsumer", new Class[0]);
        CreateDS dsAnnotation = createProviderMethod.getAnnotation(CreateDS.class);
        DirectoryService provDirService = DSAnnotationProcessor.createDS((CreateDS)dsAnnotation);
        CreateLdapServer serverAnnotation = createProviderMethod.getAnnotation(CreateLdapServer.class);
        consumerServer = ServerAnnotationProcessor.instantiateLdapServer((CreateLdapServer)serverAnnotation, (DirectoryService)provDirService, (int)0);
        SyncReplConsumer syncreplClient = new SyncReplConsumer();
        final SyncreplConfiguration config = new SyncreplConfiguration();
        config.setProviderHost("localhost");
        config.setPort(16000);
        config.setReplUserDn("uid=admin,ou=system");
        config.setReplUserPassword("secret".getBytes());
        config.setUseTls(false);
        config.setBaseDn("dc=example,dc=com");
        config.setRefreshInterval(1000L);
        syncreplClient.setConfig((ReplicationConsumerConfig)config);
        ArrayList<SyncReplConsumer> replConsumers = new ArrayList<SyncReplConsumer>();
        replConsumers.add(syncreplClient);
        consumerServer.setReplConsumers(replConsumers);
        Runnable r = new Runnable(){

            public void run() {
                try {
                    consumerServer.start();
                    DirectoryService ds = consumerServer.getDirectoryService();
                    Dn configDn = new Dn(ds.getSchemaManager(), new String[]{"ads-replProviderId=localhost,ou=system"});
                    config.setConfigEntryDn(configDn);
                    DefaultEntry provConfigEntry = new DefaultEntry(ds.getSchemaManager(), configDn);
                    provConfigEntry.add("objectClass", new String[]{"ads-replConsumer"});
                    provConfigEntry.add("ads-replConsumerId", new String[]{"localhost"});
                    provConfigEntry.add("ads-searchBaseDN", new String[]{config.getBaseDn()});
                    provConfigEntry.add("ads-replProvHostName", new String[]{config.getProviderHost()});
                    provConfigEntry.add("ads-replProvPort", new String[]{String.valueOf(config.getPort())});
                    provConfigEntry.add("ads-replAliasDerefMode", new String[]{config.getAliasDerefMode().getJndiValue()});
                    provConfigEntry.add("ads-replAttributes", config.getAttributes());
                    provConfigEntry.add("ads-replRefreshInterval", new String[]{String.valueOf(config.getRefreshInterval())});
                    provConfigEntry.add("ads-replRefreshNPersist", new String[]{String.valueOf(config.isRefreshNPersist())});
                    provConfigEntry.add("ads-replSearchScope", new String[]{config.getSearchScope().getLdapUrlValue()});
                    provConfigEntry.add("ads-replSearchFilter", new String[]{config.getFilter()});
                    provConfigEntry.add("ads-replSearchSizeLimit", new String[]{String.valueOf(config.getSearchSizeLimit())});
                    provConfigEntry.add("ads-replSearchTimeOut", new String[]{String.valueOf(config.getSearchTimeout())});
                    provConfigEntry.add("ads-replUserDn", new String[]{config.getReplUserDn()});
                    provConfigEntry.add("ads-replUserPassword", (byte[][])new byte[][]{config.getReplUserPassword()});
                    consumerSession = consumerServer.getDirectoryService().getAdminSession();
                    consumerSession.add((Entry)provConfigEntry);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.start();
        t.join();
    }

    static {
        entryCount = new AtomicInteger();
    }
}

