/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.bind;

import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.net.SocketClient;
import org.apache.directory.api.ldap.codec.api.LdapDecoder;
import org.apache.directory.api.ldap.codec.api.LdapEncoder;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.model.constants.SaslQoP;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.BindRequest;
import org.apache.directory.api.ldap.model.message.BindRequestImpl;
import org.apache.directory.api.ldap.model.message.BindResponse;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.ldap.model.message.ModifyRequest;
import org.apache.directory.api.ldap.model.message.ModifyRequestImpl;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.junit.tools.MultiThreadedMultiInvoker;
import org.apache.directory.ldap.client.api.CramMd5Request;
import org.apache.directory.ldap.client.api.DigestMd5Request;
import org.apache.directory.ldap.client.api.GssApiRequest;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.directory.server.annotations.CreateKdcServer;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.annotations.SaslMechanism;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.annotations.ContextEntry;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreateIndex;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.core.kerberos.KeyDerivationInterceptor;
import org.apache.directory.server.ldap.handlers.bind.cramMD5.CramMd5MechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.digestMD5.DigestMd5MechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.gssapi.GssapiMechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.ntlm.NtlmMechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.ntlm.NtlmProvider;
import org.apache.directory.server.ldap.handlers.bind.plain.PlainMechanismHandler;
import org.apache.directory.server.ldap.handlers.extended.StoredProcedureExtendedOperationHandler;
import org.apache.directory.server.operations.bind.BogusNtlmProvider;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=FrameworkRunner.class)
@ApplyLdifs(value={"dn: ou=users,dc=example,dc=com", "objectClass: organizationalUnit", "objectClass: top", "ou: users\n", "dn: uid=hnelson,ou=users,dc=example,dc=com", "objectClass: inetOrgPerson", "objectClass: organizationalPerson", "objectClass: person", "objectClass: krb5principal", "objectClass: krb5kdcentry", "objectClass: top", "uid: hnelson", "userPassword: secret", "krb5PrincipalName: hnelson@EXAMPLE.COM", "krb5KeyVersionNumber: 0", "cn: Horatio Nelson", "sn: Nelson", "dn: uid=krbtgt,ou=users,dc=example,dc=com", "objectClass: inetOrgPerson", "objectClass: organizationalPerson", "objectClass: person", "objectClass: krb5principal", "objectClass: krb5kdcentry", "objectClass: top", "uid: krbtgt", "userPassword: secret", "krb5PrincipalName: krbtgt/EXAMPLE.COM@EXAMPLE.COM", "krb5KeyVersionNumber: 0", "cn: KDC Service", "sn: Service", "dn: uid=ldap,ou=users,dc=example,dc=com", "objectClass: inetOrgPerson", "objectClass: organizationalPerson", "objectClass: person", "objectClass: krb5principal", "objectClass: krb5kdcentry", "objectClass: top", "uid: ldap", "userPassword: randall", "krb5PrincipalName: ldap/localhost@EXAMPLE.COM", "krb5KeyVersionNumber: 0", "cn: LDAP Service", "sn: Service"})
@CreateDS(allowAnonAccess=false, name="SaslBindIT-class", partitions={@CreatePartition(name="example", suffix="dc=example,dc=com", contextEntry=@ContextEntry(entryLdif="dn: dc=example,dc=com\ndc: example\nobjectClass: top\nobjectClass: domain\n\n"), indexes={@CreateIndex(attribute="objectClass"), @CreateIndex(attribute="dc"), @CreateIndex(attribute="ou")})}, additionalInterceptors={KeyDerivationInterceptor.class})
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")}, saslHost="localhost", saslPrincipal="ldap/localhost@EXAMPLE.COM", saslMechanisms={@SaslMechanism(name="PLAIN", implClass=PlainMechanismHandler.class), @SaslMechanism(name="CRAM-MD5", implClass=CramMd5MechanismHandler.class), @SaslMechanism(name="DIGEST-MD5", implClass=DigestMd5MechanismHandler.class), @SaslMechanism(name="GSSAPI", implClass=GssapiMechanismHandler.class), @SaslMechanism(name="NTLM", implClass=NtlmMechanismHandler.class), @SaslMechanism(name="GSS-SPNEGO", implClass=NtlmMechanismHandler.class)}, extendedOpHandlers={StoredProcedureExtendedOperationHandler.class}, ntlmProvider=BogusNtlmProvider.class)
@CreateKdcServer(transports={@CreateTransport(protocol="UDP", port=6088), @CreateTransport(protocol="TCP", port=6088)})
public class SaslBindIT
extends AbstractLdapTestUnit {
    @Rule
    public MultiThreadedMultiInvoker i = new MultiThreadedMultiInvoker(false);

    public SaslBindIT() throws Exception {
        String hostName;
        try {
            InetAddress loopback = InetAddress.getByName("127.0.0.1");
            hostName = loopback.getHostName();
        }
        catch (UnknownHostException e) {
            System.err.println("Can't find loopback address '127.0.0.1', using hostname 'localhost'");
            hostName = "localhost";
        }
        String servicePrincipal = "ldap/" + hostName + "@EXAMPLE.COM";
        SaslBindIT.getLdapServer().setSaslPrincipal(servicePrincipal);
        ModifyRequestImpl modifyRequest = new ModifyRequestImpl();
        modifyRequest.setName(new Dn(new String[]{"uid=ldap,ou=users,dc=example,dc=com"}));
        modifyRequest.replace("userPassword", new String[]{"randall"});
        modifyRequest.replace("krb5PrincipalName", new String[]{servicePrincipal});
        SaslBindIT.getService().getAdminSession().modify((ModifyRequest)modifyRequest);
    }

    @Test
    public void testSupportedSASLMechanisms() throws Exception {
        SaslBindIT.getLdapServer().getDirectoryService().setAllowAnonymousAccess(true);
        InitialDirContext context = new InitialDirContext();
        Attributes attrs = context.getAttributes("ldap://localhost:" + SaslBindIT.getLdapServer().getPort(), new String[]{"supportedSASLMechanisms"});
        NamingEnumeration<? extends Attribute> answer = attrs.getAll();
        Attribute result = answer.next();
        Assert.assertEquals((long)6L, (long)result.size());
        Assert.assertTrue((boolean)result.contains("GSSAPI"));
        Assert.assertTrue((boolean)result.contains("DIGEST-MD5"));
        Assert.assertTrue((boolean)result.contains("CRAM-MD5"));
        Assert.assertTrue((boolean)result.contains("NTLM"));
        Assert.assertTrue((boolean)result.contains("PLAIN"));
        Assert.assertTrue((boolean)result.contains("GSS-SPNEGO"));
    }

    @Test
    @Ignore
    public void testSaslBindPLAIN() throws Exception {
        Dn userDn = new Dn(new String[]{"uid=hnelson,ou=users,dc=example,dc=com"});
        LdapNetworkConnection connection = new LdapNetworkConnection("localhost", SaslBindIT.getLdapServer().getPort());
        BindRequestImpl bindReq = new BindRequestImpl();
        bindReq.setCredentials("secret");
        bindReq.setDn(userDn);
        bindReq.setSaslMechanism("PLAIN");
        BindResponse resp = connection.bind((BindRequest)bindReq);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)resp.getLdapResult().getResultCode());
        Entry entry = connection.lookup(userDn);
        Assert.assertEquals((Object)"hnelson", (Object)entry.get("uid").getString());
        connection.close();
    }

    @Test
    @Ignore(value="Activate and fix when DIRAPI-36 (Provide a SaslBindRequest extending BindRequest that can be used in LdapConnection.bind(...) method) is solved")
    public void testSaslBindNoMech() throws Exception {
        Dn userDn = new Dn(new String[]{"uid=hnelson,ou=users,dc=example,dc=com"});
        LdapNetworkConnection connection = new LdapNetworkConnection("localhost", SaslBindIT.getLdapServer().getPort());
        BindRequestImpl bindReq = new BindRequestImpl();
        bindReq.setCredentials("secret");
        bindReq.setDn(userDn);
        bindReq.setSaslMechanism("");
        bindReq.setSimple(false);
        try {
            connection.bind((BindRequest)bindReq);
            Assert.fail();
        }
        catch (LdapException le) {
            // empty catch block
        }
        connection.close();
    }

    @Test
    public void testSaslCramMd5Bind() throws Exception {
        Dn userDn = new Dn(new String[]{"uid=hnelson,ou=users,dc=example,dc=com"});
        LdapNetworkConnection connection = new LdapNetworkConnection("localhost", SaslBindIT.getLdapServer().getPort());
        CramMd5Request request = new CramMd5Request();
        request.setUsername(userDn.getRdn().getValue().getString());
        request.setCredentials("secret");
        BindResponse resp = connection.bind(request);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)resp.getLdapResult().getResultCode());
        Entry entry = connection.lookup(userDn);
        Assert.assertEquals((Object)"hnelson", (Object)entry.get("uid").getString());
        connection.close();
    }

    @Test
    public void testSaslCramMd5BindBadPassword() throws Exception {
        Dn userDn = new Dn(new String[]{"uid=hnelson,ou=users,dc=example,dc=com"});
        LdapNetworkConnection connection = new LdapNetworkConnection("localhost", SaslBindIT.getLdapServer().getPort());
        CramMd5Request request = new CramMd5Request();
        request.setUsername(userDn.getRdn().getValue().getString());
        request.setCredentials("badsecret");
        BindResponse resp = connection.bind(request);
        Assert.assertEquals((Object)ResultCodeEnum.INVALID_CREDENTIALS, (Object)resp.getLdapResult().getResultCode());
        connection.close();
    }

    @Test
    public void testSaslDigestMd5Bind() throws Exception {
        Dn userDn = new Dn(new String[]{"uid=hnelson,ou=users,dc=example,dc=com"});
        LdapNetworkConnection connection = new LdapNetworkConnection("localhost", SaslBindIT.getLdapServer().getPort());
        DigestMd5Request request = new DigestMd5Request();
        request.setUsername(userDn.getRdn().getValue().getString());
        request.setCredentials("secret");
        request.setRealmName((String)ldapServer.getSaslRealms().get(0));
        BindResponse resp = connection.bind(request);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)resp.getLdapResult().getResultCode());
        Entry entry = connection.lookup(userDn);
        Assert.assertEquals((Object)"hnelson", (Object)entry.get("uid").getString());
        connection.close();
    }

    @Test
    public void testSaslDigestMd5BindSaslQoPAuth() throws Exception {
        Dn userDn = new Dn(new String[]{"uid=hnelson,ou=users,dc=example,dc=com"});
        LdapNetworkConnection connection = new LdapNetworkConnection("localhost", SaslBindIT.getLdapServer().getPort());
        DigestMd5Request request = new DigestMd5Request();
        request.setUsername(userDn.getRdn().getValue().getString());
        request.setCredentials("secret");
        request.setRealmName((String)ldapServer.getSaslRealms().get(0));
        request.setQualityOfProtection(SaslQoP.AUTH);
        BindResponse resp = connection.bind(request);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)resp.getLdapResult().getResultCode());
        Entry entry = connection.lookup(userDn);
        Assert.assertEquals((Object)"hnelson", (Object)entry.get("uid").getString());
        connection.close();
    }

    @Test
    @Ignore
    public void testSaslDigestMd5BindSaslQoPAuthInt() throws Exception {
        Dn userDn = new Dn(new String[]{"uid=hnelson,ou=users,dc=example,dc=com"});
        LdapNetworkConnection connection = new LdapNetworkConnection("localhost", SaslBindIT.getLdapServer().getPort());
        DigestMd5Request request = new DigestMd5Request();
        request.setUsername(userDn.getRdn().getValue().getString());
        request.setCredentials("secret");
        request.setRealmName((String)ldapServer.getSaslRealms().get(0));
        request.setQualityOfProtection(SaslQoP.AUTH_INT);
        BindResponse resp = connection.bind(request);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)resp.getLdapResult().getResultCode());
        Entry entry = connection.lookup(userDn);
        Assert.assertEquals((Object)"hnelson", (Object)entry.get("uid").getString());
        connection.close();
    }

    @Test
    @Ignore
    public void testSaslDigestMd5BindSaslQoPAuthConf() throws Exception {
        Dn userDn = new Dn(new String[]{"uid=hnelson,ou=users,dc=example,dc=com"});
        LdapNetworkConnection connection = new LdapNetworkConnection("localhost", SaslBindIT.getLdapServer().getPort());
        DigestMd5Request request = new DigestMd5Request();
        request.setUsername(userDn.getRdn().getValue().getString());
        request.setCredentials("secret");
        request.setRealmName((String)ldapServer.getSaslRealms().get(0));
        request.setQualityOfProtection(SaslQoP.AUTH_CONF);
        BindResponse resp = connection.bind(request);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)resp.getLdapResult().getResultCode());
        Entry entry = connection.lookup(userDn);
        Assert.assertEquals((Object)"hnelson", (Object)entry.get("uid").getString());
        connection.close();
    }

    @Test
    public void testSaslDigestMd5BindBadRealm() throws Exception {
        Dn userDn = new Dn(new String[]{"uid=hnelson,ou=users,dc=example,dc=com"});
        LdapNetworkConnection connection = new LdapNetworkConnection("localhost", SaslBindIT.getLdapServer().getPort());
        DigestMd5Request request = new DigestMd5Request();
        request.setUsername(userDn.getRdn().getValue().getString());
        request.setCredentials("secret");
        request.setRealmName("badrealm.com");
        BindResponse resp = connection.bind(request);
        Assert.assertEquals((Object)ResultCodeEnum.INVALID_CREDENTIALS, (Object)resp.getLdapResult().getResultCode());
        connection.close();
    }

    @Test
    public void testSaslDigestMd5BindBadPassword() throws Exception {
        Dn userDn = new Dn(new String[]{"uid=hnelson,ou=users,dc=example,dc=com"});
        LdapNetworkConnection connection = new LdapNetworkConnection("localhost", SaslBindIT.getLdapServer().getPort());
        DigestMd5Request request = new DigestMd5Request();
        request.setUsername(userDn.getRdn().getValue().getString());
        request.setCredentials("badsecret");
        request.setRealmName((String)ldapServer.getSaslRealms().get(0));
        BindResponse resp = connection.bind(request);
        Assert.assertEquals((Object)ResultCodeEnum.INVALID_CREDENTIALS, (Object)resp.getLdapResult().getResultCode());
        connection.close();
    }

    @Test
    public void testSaslGssApiBind() throws Exception {
        Dn userDn = new Dn(new String[]{"uid=hnelson,ou=users,dc=example,dc=com"});
        LdapNetworkConnection connection = new LdapNetworkConnection("localhost", SaslBindIT.getLdapServer().getPort());
        GssApiRequest request = new GssApiRequest();
        request.setUsername(userDn.getRdn().getValue().getString());
        request.setCredentials("secret");
        request.setRealmName(((String)ldapServer.getSaslRealms().get(0)).toUpperCase());
        request.setKdcHost("localhost");
        request.setKdcPort(6088);
        BindResponse resp = connection.bind(request);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)resp.getLdapResult().getResultCode());
        Entry entry = connection.lookup(userDn);
        Assert.assertEquals((Object)"hnelson", (Object)entry.get("uid").getString());
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSaslGssApiBindBadRealm() throws Exception {
        Dn userDn = new Dn(new String[]{"uid=hnelson,ou=users,dc=example,dc=com"});
        LdapNetworkConnection connection = new LdapNetworkConnection("localhost", ldapServer.getPort());
        GssApiRequest request = new GssApiRequest();
        request.setUsername(userDn.getRdn().getValue().getString());
        request.setCredentials("secret");
        request.setRealmName("badrealm.com");
        request.setKdcHost("localhost");
        request.setKdcPort(6088);
        try {
            connection.bind(request);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof LdapException));
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSaslGssApiBindBadPassword() throws Exception {
        Dn userDn = new Dn(new String[]{"uid=hnelson,ou=users,dc=example,dc=com"});
        LdapNetworkConnection connection = new LdapNetworkConnection("localhost", ldapServer.getPort());
        GssApiRequest request = new GssApiRequest();
        request.setUsername(userDn.getRdn().getValue().getString());
        request.setCredentials("badsecret");
        request.setRealmName(((String)ldapServer.getSaslRealms().get(0)).toUpperCase());
        request.setKdcHost("localhost");
        request.setKdcPort(6088);
        try {
            connection.bind(request);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof LdapException));
        }
        finally {
            connection.close();
        }
    }

    @Test
    public void testNtlmBind() throws Exception {
        BogusNtlmProvider provider = this.getNtlmProviderUsingReflection();
        NtlmSaslBindClient client = new NtlmSaslBindClient("NTLM");
        BindResponse type2response = client.bindType1("type1_test".getBytes());
        Assert.assertEquals((long)1L, (long)type2response.getMessageId());
        Assert.assertEquals((Object)ResultCodeEnum.SASL_BIND_IN_PROGRESS, (Object)type2response.getLdapResult().getResultCode());
        Assert.assertTrue((boolean)ArrayUtils.isEquals((Object)"type1_test".getBytes(), (Object)provider.getType1Response()));
        Assert.assertTrue((boolean)ArrayUtils.isEquals((Object)"challenge".getBytes(), (Object)type2response.getServerSaslCreds()));
        BindResponse finalResponse = client.bindType3("type3_test".getBytes());
        Assert.assertEquals((long)2L, (long)finalResponse.getMessageId());
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)finalResponse.getLdapResult().getResultCode());
        Assert.assertTrue((boolean)ArrayUtils.isEquals((Object)"type3_test".getBytes(), (Object)provider.getType3Response()));
    }

    @Test
    public void testGssSpnegoBind() throws Exception {
        BogusNtlmProvider provider = new BogusNtlmProvider();
        NtlmMechanismHandler ntlmHandler = (NtlmMechanismHandler)SaslBindIT.getLdapServer().getSaslMechanismHandlers().get("GSS-SPNEGO");
        ntlmHandler.setNtlmProvider((NtlmProvider)provider);
        NtlmSaslBindClient client = new NtlmSaslBindClient("GSS-SPNEGO");
        BindResponse type2response = client.bindType1("type1_test".getBytes());
        Assert.assertEquals((long)1L, (long)type2response.getMessageId());
        Assert.assertEquals((Object)ResultCodeEnum.SASL_BIND_IN_PROGRESS, (Object)type2response.getLdapResult().getResultCode());
        Assert.assertTrue((boolean)ArrayUtils.isEquals((Object)"type1_test".getBytes(), (Object)provider.getType1Response()));
        Assert.assertTrue((boolean)ArrayUtils.isEquals((Object)"challenge".getBytes(), (Object)type2response.getServerSaslCreds()));
        BindResponse finalResponse = client.bindType3("type3_test".getBytes());
        Assert.assertEquals((long)2L, (long)finalResponse.getMessageId());
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)finalResponse.getLdapResult().getResultCode());
        Assert.assertTrue((boolean)ArrayUtils.isEquals((Object)"type3_test".getBytes(), (Object)provider.getType3Response()));
    }

    @Ignore(value="Activate when DIRAPI-30 is solved")
    @Test
    public void testSequentialBinds() throws Exception {
        Dn userDn = new Dn(new String[]{"uid=hnelson,ou=users,dc=example,dc=com"});
        for (int i = 0; i < 1000; ++i) {
            System.out.println("try " + i);
            LdapNetworkConnection connection = new LdapNetworkConnection("localhost", ldapServer.getPort());
            DigestMd5Request digetDigestMd5Request = new DigestMd5Request();
            digetDigestMd5Request.setUsername(userDn.getRdn().getValue().getString());
            digetDigestMd5Request.setCredentials("secret");
            digetDigestMd5Request.setRealmName((String)ldapServer.getSaslRealms().get(0));
            BindResponse resp = connection.bind(digetDigestMd5Request);
            Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)resp.getLdapResult().getResultCode());
            Entry entry = connection.lookup(userDn);
            Assert.assertEquals((Object)"hnelson", (Object)entry.get("uid").getString());
            connection.close();
            connection = new LdapNetworkConnection("localhost", ldapServer.getPort());
            CramMd5Request cramMd5Request = new CramMd5Request();
            cramMd5Request.setUsername(userDn.getRdn().getValue().getString());
            cramMd5Request.setCredentials("secret");
            resp = connection.bind(cramMd5Request);
            Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)resp.getLdapResult().getResultCode());
            entry = connection.lookup(userDn);
            Assert.assertEquals((Object)"hnelson", (Object)entry.get("uid").getString());
            connection.close();
            connection = new LdapNetworkConnection("localhost", ldapServer.getPort());
            GssApiRequest gssApiRequest = new GssApiRequest();
            gssApiRequest.setUsername(userDn.getRdn().getValue().getString());
            gssApiRequest.setCredentials("secret");
            gssApiRequest.setRealmName((String)ldapServer.getSaslRealms().get(0));
            gssApiRequest.setKdcHost("localhost");
            gssApiRequest.setKdcPort(6088);
            resp = connection.bind(gssApiRequest);
            Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)resp.getLdapResult().getResultCode());
            entry = connection.lookup(userDn);
            Assert.assertEquals((Object)"hnelson", (Object)entry.get("uid").getString());
            connection.close();
        }
    }

    private BogusNtlmProvider getNtlmProviderUsingReflection() {
        BogusNtlmProvider provider = null;
        try {
            NtlmMechanismHandler ntlmHandler = (NtlmMechanismHandler)SaslBindIT.getLdapServer().getSaslMechanismHandlers().get("NTLM");
            Field field = ntlmHandler.getClass().getDeclaredField("provider");
            field.setAccessible(true);
            provider = (BogusNtlmProvider)field.get(ntlmHandler);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return provider;
    }

    protected Entry getPrincipalAttributes(String dn, String sn, String cn, String uid, String userPassword, String principal) throws LdapException {
        DefaultEntry entry = new DefaultEntry(dn);
        entry.add("objectClass", new String[]{"person", "inetOrgPerson", "krb5principal", "krb5kdcentry"});
        entry.add("cn", new String[]{cn});
        entry.add("sn", new String[]{sn});
        entry.add("uid", new String[]{uid});
        entry.add("userPassword", new String[]{userPassword});
        entry.add("krb5PrincipalName", new String[]{principal});
        entry.add("krb5KeyVersionNumber", new String[]{"0"});
        return entry;
    }

    class NtlmSaslBindClient
    extends SocketClient {
        private final Logger LOG = LoggerFactory.getLogger(NtlmSaslBindClient.class);
        private final String mechanism;

        NtlmSaslBindClient(String mechanism) throws Exception {
            this.mechanism = mechanism;
            this.setDefaultPort(AbstractLdapTestUnit.getLdapServer().getPort());
            this.connect("localhost", AbstractLdapTestUnit.getLdapServer().getPort());
            this.setTcpNoDelay(false);
            this.LOG.debug("isConnected() = {}", (Object)this.isConnected());
            this.LOG.debug("LocalPort     = {}", (Object)this.getLocalPort());
            this.LOG.debug("LocalAddress  = {}", (Object)this.getLocalAddress());
            this.LOG.debug("RemotePort    = {}", (Object)this.getRemotePort());
            this.LOG.debug("RemoteAddress = {}", (Object)this.getRemoteAddress());
        }

        BindResponse bindType1(byte[] type1response) throws Exception {
            if (!this.isConnected()) {
                throw new IllegalStateException("Client is not connected.");
            }
            BindRequestImpl request = new BindRequestImpl();
            request.setMessageId(1);
            request.setDn(new Dn(new String[]{"uid=admin,ou=system"}));
            request.setSimple(false);
            request.setCredentials(type1response);
            request.setSaslMechanism(this.mechanism);
            request.setVersion3(true);
            LdapDecoder decoder = new LdapDecoder();
            LdapEncoder encoder = new LdapEncoder(AbstractLdapTestUnit.getLdapServer().getDirectoryService().getLdapCodecService());
            ByteBuffer bb = encoder.encodeMessage((Message)request);
            bb.flip();
            this._output_.write(bb.array());
            this._output_.flush();
            while (this._input_.available() <= 0) {
                Thread.sleep(100L);
            }
            LdapMessageContainer container = new LdapMessageContainer(AbstractLdapTestUnit.ldapServer.getDirectoryService().getLdapCodecService());
            return (BindResponse)decoder.decode(this._input_, container);
        }

        BindResponse bindType3(byte[] type3response) throws Exception {
            if (!this.isConnected()) {
                throw new IllegalStateException("Client is not connected.");
            }
            BindRequestImpl request = new BindRequestImpl();
            request.setMessageId(2);
            request.setDn(new Dn(new String[]{"uid=admin,ou=system"}));
            request.setSimple(false);
            request.setCredentials(type3response);
            request.setSaslMechanism(this.mechanism);
            request.setVersion3(true);
            LdapDecoder decoder = new LdapDecoder();
            LdapEncoder encoder = new LdapEncoder(AbstractLdapTestUnit.getLdapServer().getDirectoryService().getLdapCodecService());
            ByteBuffer bb = encoder.encodeMessage((Message)request);
            bb.flip();
            this._output_.write(bb.array());
            this._output_.flush();
            while (this._input_.available() <= 0) {
                Thread.sleep(100L);
            }
            LdapMessageContainer container = new LdapMessageContainer(AbstractLdapTestUnit.ldapServer.getDirectoryService().getLdapCodecService());
            return (BindResponse)decoder.decode(this._input_, container);
        }
    }
}

