/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.delete;

import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.junit.tools.MultiThreadedMultiInvoker;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.integ.ServerIntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateDS(enableChangeLog=false, name="DSDeleteAlias")
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
public class DeleteAliasIT
extends AbstractLdapTestUnit {
    @Rule
    public MultiThreadedMultiInvoker i = new MultiThreadedMultiInvoker(false);
    private LdapConnection conn;

    @Before
    public void setup() throws Exception {
        this.conn = ServerIntegrationUtils.getAdminConnection((LdapServer)DeleteAliasIT.getLdapServer());
        if (this.conn.lookup("cn=foo,ou=system") == null) {
            this.conn.add((Entry)new DefaultEntry("cn=foo,ou=system", new Object[]{"objectClass: person", "objectClass: top", "cn: foo", "sn: Foo"}));
        }
        if (this.conn.lookup("ou=alias,ou=users,ou=system") == null) {
            this.conn.add((Entry)new DefaultEntry("ou=alias,ou=users,ou=system", new Object[]{"objectClass: top", "objectClass: extensibleObject", "objectClass: alias", "ou: alias", "aliasedObjectName: cn=foo,ou=system", "description: alias to sibling (branch)"}));
        }
    }

    @Test
    public void testDeleteAliasThenEntry() throws Exception {
        Assert.assertNotNull((Object)this.conn.lookup("ou=alias,ou=users,ou=system"));
        this.conn.delete("ou=alias,ou=users,ou=system");
        Assert.assertNull((Object)this.conn.lookup("ou=alias,ou=users,ou=system"));
        Assert.assertNotNull((Object)this.conn.lookup("cn=foo,ou=system"));
        this.conn.delete("cn=foo,ou=system");
        Assert.assertNull((Object)this.conn.lookup("cn=foo,ou=system"));
        this.conn.unBind();
        this.conn.close();
    }

    @Test
    public void testDeleteEntryThenAlias() throws Exception {
        this.conn = ServerIntegrationUtils.getAdminConnection((LdapServer)DeleteAliasIT.getLdapServer());
        Assert.assertNotNull((Object)this.conn.lookup("cn=foo,ou=system"));
        this.conn.delete("cn=foo,ou=system");
        Assert.assertNull((Object)this.conn.lookup("cn=foo,ou=system"));
        this.conn.delete("ou=alias,ou=users,ou=system");
        Assert.assertNull((Object)this.conn.lookup("ou=alias,ou=users,ou=system"));
        this.conn.unBind();
        this.conn.close();
    }
}

