/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.ldapsdk;

import java.util.HashSet;
import java.util.UUID;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.PartialResultException;
import javax.naming.ReferralException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.SchemaViolationException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPResponse;
import netscape.ldap.LDAPResponseListener;
import netscape.ldap.LDAPSearchConstraints;
import org.apache.directory.api.ldap.model.constants.AuthenticationLevel;
import org.apache.directory.api.ldap.model.csn.Csn;
import org.apache.directory.api.ldap.model.csn.CsnFactory;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapNoSuchAttributeException;
import org.apache.directory.api.ldap.model.exception.LdapOperationException;
import org.apache.directory.api.ldap.model.ldif.LdifUtils;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;
import org.apache.directory.junit.tools.MultiThreadedMultiInvoker;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.annotations.ContextEntry;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreateIndex;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.LdapPrincipal;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.core.jndi.ServerLdapContext;
import org.apache.directory.server.integ.ServerIntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=FrameworkRunner.class)
@CreateDS(allowAnonAccess=true, name="AddIT-class", partitions={@CreatePartition(name="example", suffix="dc=example,dc=com", contextEntry=@ContextEntry(entryLdif="dn: dc=example,dc=com\ndc: example\nobjectClass: top\nobjectClass: domain\n\n"), indexes={@CreateIndex(attribute="objectClass"), @CreateIndex(attribute="dc"), @CreateIndex(attribute="ou")}), @CreatePartition(name="directory", suffix="dc=directory,dc=apache,dc=org", contextEntry=@ContextEntry(entryLdif="dn: dc=directory,dc=apache,dc=org\ndc: directory\nobjectClass: top\nobjectClass: domain\n\n"), indexes={@CreateIndex(attribute="objectClass"), @CreateIndex(attribute="dc"), @CreateIndex(attribute="ou")})})
@CreateLdapServer(name="ADDIT", transports={@CreateTransport(protocol="LDAP", port=-1)})
@ApplyLdifs(value={"dn: cn=The Person,ou=system", "objectClass: person", "objectClass: top", "cn: The Person", "description: this is a person", "sn: Person", "dn: uid=akarasulu,ou=users,ou=system", "objectClass: uidObject", "objectClass: person", "objectClass: top", "uid: akarasulu", "cn: Alex Karasulu", "sn: karasulu", "dn: ou=Computers,uid=akarasulu,ou=users,ou=system", "objectClass: organizationalUnit", "objectClass: top", "ou: computers", "description: Computers for Alex", "seeAlso: ou=Machines,uid=akarasulu,ou=users,ou=system", "dn: uid=akarasuluref,ou=users,ou=system", "objectClass: uidObject", "objectClass: referral", "objectClass: top", "uid: akarasuluref", "ref: ldap://localhost:10389/uid=akarasulu,ou=users,ou=system", "ref: ldap://foo:10389/uid=akarasulu,ou=users,ou=system", "ref: ldap://bar:10389/uid=akarasulu,ou=users,ou=system"})
public class AddIT
extends AbstractLdapTestUnit {
    @Rule
    public MultiThreadedMultiInvoker i = new MultiThreadedMultiInvoker(false);
    private static final Logger LOG = LoggerFactory.getLogger(AddIT.class);
    private static final String RDN = "cn=The Person";
    private static final String BASE = "ou=system";
    private static final String BASE_EXAMPLE_COM = "dc=example,dc=com";
    private static final String BASE_DIRECTORY_APACHE_ORG = "dc=directory,dc=apache,dc=org";

    @Test
    public void testAddObjectClasses() throws Exception {
        String[] expectedOcls;
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)AddIT.getLdapServer()).lookup(BASE);
        Attributes attributes = LdifUtils.createJndiAttributes((Object[])new Object[]{"objectClass: organizationalPerson", "objectClass: inetOrgPerson"});
        DirContext person = (DirContext)ctx.lookup(RDN);
        person.modifyAttributes("", 1, attributes);
        person = (DirContext)ctx.lookup(RDN);
        attributes = person.getAttributes("");
        javax.naming.directory.Attribute newOcls = attributes.get("objectClass");
        for (String name : expectedOcls = new String[]{"top", "person", "organizationalPerson", "inetOrgPerson"}) {
            Assert.assertTrue((String)("object class " + name + " is present"), (boolean)newOcls.contains(name));
        }
    }

    @Test
    public void testModifyDescription() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)AddIT.getLdapServer()).lookup(BASE);
        String newDescription = "More info on the user ...";
        Attributes attributes = new BasicAttributes(true);
        BasicAttribute desc = new BasicAttribute("description", newDescription);
        attributes.put(desc);
        DirContext person = (DirContext)ctx.lookup(RDN);
        person.modifyAttributes("", 2, attributes);
        person = (DirContext)ctx.lookup(RDN);
        attributes = person.getAttributes("");
        javax.naming.directory.Attribute newDesc = attributes.get("description");
        Assert.assertTrue((String)"new Description", (boolean)newDesc.contains(newDescription));
    }

    @Test
    public void testAddWithMissingRequiredAttributes() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)AddIT.getLdapServer()).lookup(BASE);
        BasicAttributes attrs = new BasicAttributes(true);
        BasicAttribute ocls = new BasicAttribute("objectClass");
        ocls.add("top");
        ocls.add("person");
        attrs.put(ocls);
        attrs.put("cn", "Fiona Apple");
        try {
            ctx.createSubcontext("cn=Fiona Apple", (Attributes)attrs);
            Assert.fail((String)"creation of entry should fail");
        }
        catch (SchemaViolationException e) {
            // empty catch block
        }
    }

    @Test
    public void testAddEntryWithTwoDescriptions() throws Exception {
        LdapConnection con = ServerIntegrationUtils.getAdminConnection((LdapServer)AddIT.getLdapServer());
        String dn = "cn=Kate Bush,ou=system";
        DefaultEntry kate = new DefaultEntry(dn);
        kate.add("objectclass", new String[]{"top", "person"});
        kate.add("sn", new String[]{"Bush"});
        kate.add("cn", new String[]{"Kate Bush"});
        String[] descr = new String[]{"a British singer-songwriter with an expressive four-octave voice", "one of the most influential female artists of the twentieth century"};
        kate.add("description", descr);
        con.add((Entry)kate);
        Entry kateReloaded = con.lookup(dn);
        Assert.assertNotNull((Object)kateReloaded);
        Attribute attr = kateReloaded.get("description");
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((long)2L, (long)attr.size());
        con.delete(dn);
        con.unBind();
    }

    @Test
    public void testAddEntryWithTwoDescriptionsVariant() throws Exception {
        LdapConnection con = ServerIntegrationUtils.getAdminConnection((LdapServer)AddIT.getLdapServer());
        String dn = "cn=Kate Bush,ou=system";
        DefaultEntry kate = new DefaultEntry(dn);
        kate.add("objectclass", new String[]{"top", "person"});
        kate.add("sn", new String[]{"Bush"});
        kate.add("cn", new String[]{"Kate Bush"});
        String[] descr = new String[]{"a British singer-songwriter with an expressive four-octave voice", "one of the most influential female artists of the twentieth century"};
        kate.add("description", new String[]{descr[0]});
        kate.add("description", new String[]{descr[1]});
        con.add((Entry)kate);
        Entry kateReloaded = con.lookup(dn);
        Assert.assertNotNull((Object)kateReloaded);
        Attribute attr = kateReloaded.get("description");
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((long)2L, (long)attr.size());
        con.delete(dn);
        con.unBind();
    }

    @Test
    public void testAddEntryWithTwoDescriptionsSecondVariant() throws Exception {
        LdapConnection con = ServerIntegrationUtils.getAdminConnection((LdapServer)AddIT.getLdapServer());
        String dn = "cn=Kate Bush,ou=system";
        DefaultEntry kate = new DefaultEntry(dn);
        kate.add("objectclass", new String[]{"top", "person"});
        kate.add("sn", new String[]{"Bush"});
        String[] descr = new String[]{"a British singer-songwriter with an expressive four-octave voice", "one of the most influential female artists of the twentieth century"};
        kate.add("description", new String[]{descr[0]});
        kate.add("cn", new String[]{"Kate Bush"});
        kate.add("description", new String[]{descr[1]});
        con.add((Entry)kate);
        Entry kateReloaded = con.lookup(dn);
        Assert.assertNotNull((Object)kateReloaded);
        Attribute attr = kateReloaded.get("description");
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((long)2L, (long)attr.size());
        con.delete(dn);
        con.unBind();
    }

    @Test
    public void testAddWithInvalidNumberOfAttributeValues() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)AddIT.getLdapServer()).lookup(BASE);
        BasicAttributes attrs = new BasicAttributes(true);
        BasicAttribute ocls = new BasicAttribute("objectClass");
        ocls.add("top");
        ocls.add("inetOrgPerson");
        attrs.put(ocls);
        attrs.put("cn", "Fiona Apple");
        attrs.put("sn", "Apple");
        BasicAttribute displayName = new BasicAttribute("displayName");
        displayName.add("Fiona");
        displayName.add("Fiona A.");
        attrs.put(displayName);
        try {
            ctx.createSubcontext("cn=Fiona Apple", (Attributes)attrs);
            Assert.fail((String)"creation of entry should fail");
        }
        catch (InvalidAttributeValueException e) {
            // empty catch block
        }
    }

    @Test
    public void testAddAlias() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)AddIT.getLdapServer()).lookup(BASE);
        BasicAttributes entry = new BasicAttributes(true);
        BasicAttribute entryOcls = new BasicAttribute("objectClass");
        entryOcls.add("top");
        entryOcls.add("organizationalUnit");
        entry.put(entryOcls);
        entry.put("ou", "favorite");
        String entryRdn = "ou=favorite";
        ctx.createSubcontext(entryRdn, (Attributes)entry);
        String aliasedObjectName = entryRdn + "," + ctx.getNameInNamespace();
        BasicAttributes alias = new BasicAttributes(true);
        BasicAttribute aliasOcls = new BasicAttribute("objectClass");
        aliasOcls.add("top");
        aliasOcls.add("extensibleObject");
        aliasOcls.add("alias");
        alias.put(aliasOcls);
        alias.put("ou", "bestFruit");
        alias.put("aliasedObjectName", aliasedObjectName);
        String rdnAlias = "ou=bestFruit";
        ctx.createSubcontext(rdnAlias, (Attributes)alias);
        ctx.destroySubcontext(rdnAlias);
        ctx.destroySubcontext(entryRdn);
    }

    @Test
    public void testAddAliasInContainer() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)AddIT.getLdapServer()).lookup(BASE);
        BasicAttributes container = new BasicAttributes(true);
        BasicAttribute containerOcls = new BasicAttribute("objectClass");
        containerOcls.add("top");
        containerOcls.add("organizationalUnit");
        container.put(containerOcls);
        container.put("ou", "Fruits");
        String containerRdn = "ou=Fruits";
        DirContext containerCtx = ctx.createSubcontext(containerRdn, (Attributes)container);
        BasicAttributes entry = new BasicAttributes(true);
        BasicAttribute entryOcls = new BasicAttribute("objectClass");
        entryOcls.add("top");
        entryOcls.add("organizationalUnit");
        entry.put(entryOcls);
        entry.put("ou", "favorite");
        String entryRdn = "ou=favorite";
        containerCtx.createSubcontext(entryRdn, (Attributes)entry);
        String aliasedObjectName = entryRdn + "," + containerCtx.getNameInNamespace();
        BasicAttributes alias = new BasicAttributes(true);
        BasicAttribute aliasOcls = new BasicAttribute("objectClass");
        aliasOcls.add("top");
        aliasOcls.add("extensibleObject");
        aliasOcls.add("alias");
        alias.put(aliasOcls);
        alias.put("ou", "bestFruit");
        alias.put("aliasedObjectName", aliasedObjectName);
        String rdnAlias = "ou=bestFruit";
        containerCtx.createSubcontext(rdnAlias, (Attributes)alias);
        SearchControls controls = new SearchControls();
        controls.setDerefLinkFlag(true);
        controls.setSearchScope(1);
        containerCtx.addToEnvironment("java.naming.ldap.derefAliases", "never");
        HashSet<String> names = new HashSet<String>();
        NamingEnumeration<SearchResult> ne = containerCtx.search("", "(objectClass=*)", controls);
        Assert.assertTrue((boolean)ne.hasMore());
        SearchResult sr = ne.next();
        names.add(sr.getName());
        Assert.assertTrue((boolean)ne.hasMore());
        sr = ne.next();
        names.add(sr.getName());
        Assert.assertFalse((boolean)ne.hasMore());
        Assert.assertEquals((long)2L, (long)names.size());
        Assert.assertTrue((boolean)names.contains("ou=favorite"));
        Assert.assertTrue((boolean)names.contains("ou=bestFruit"));
        controls = new SearchControls();
        controls.setDerefLinkFlag(true);
        controls.setSearchScope(1);
        containerCtx.addToEnvironment("java.naming.ldap.derefAliases", "always");
        ne = containerCtx.search("", "(objectClass=*)", controls);
        Assert.assertTrue((boolean)ne.hasMore());
        sr = ne.next();
        Assert.assertEquals((Object)"ou=favorite", (Object)sr.getName());
        Assert.assertFalse((boolean)ne.hasMore());
        controls = new SearchControls();
        controls.setDerefLinkFlag(false);
        controls.setSearchScope(0);
        containerCtx.addToEnvironment("java.naming.ldap.derefAliases", "always");
        ne = containerCtx.search("ou=bestFruit", "(objectClass=*)", controls);
        Assert.assertTrue((boolean)ne.hasMore());
        sr = ne.next();
        Assert.assertEquals((Object)("ldap://localhost:" + AddIT.getLdapServer().getPort() + "/ou=favorite,ou=Fruits,ou=system"), (Object)sr.getName());
        Assert.assertFalse((boolean)ne.hasMore());
        containerCtx.destroySubcontext(rdnAlias);
        containerCtx.destroySubcontext(entryRdn);
        ctx.destroySubcontext(containerRdn);
    }

    @Test
    public void testAddDeleteAlias() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)AddIT.getLdapServer()).lookup(BASE);
        BasicAttributes entry = new BasicAttributes(true);
        BasicAttribute entryOcls = new BasicAttribute("objectClass");
        entryOcls.add("top");
        entryOcls.add("organizationalUnit");
        entry.put(entryOcls);
        entry.put("ou", "favorite");
        String entryRdn = "ou=favorite";
        ctx.createSubcontext(entryRdn, (Attributes)entry);
        String aliasedObjectName = entryRdn + "," + ctx.getNameInNamespace();
        BasicAttributes alias = new BasicAttributes(true);
        BasicAttribute aliasOcls = new BasicAttribute("objectClass");
        aliasOcls.add("top");
        aliasOcls.add("extensibleObject");
        aliasOcls.add("alias");
        alias.put(aliasOcls);
        alias.put("ou", "bestFruit");
        alias.put("aliasedObjectName", aliasedObjectName);
        String rdnAlias = "ou=bestFruit";
        ctx.createSubcontext(rdnAlias, (Attributes)alias);
        ctx.destroySubcontext(rdnAlias);
        ctx.destroySubcontext(entryRdn);
    }

    @Test
    public void testAddDeleteAlias2() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)AddIT.getLdapServer()).lookup(BASE_EXAMPLE_COM);
        BasicAttributes entry = new BasicAttributes(true);
        BasicAttribute entryOcls = new BasicAttribute("objectClass");
        entryOcls.add("top");
        entryOcls.add("organizationalUnit");
        entry.put(entryOcls);
        entry.put("ou", "favorite");
        String entryRdn = "ou=favorite";
        ctx.createSubcontext(entryRdn, (Attributes)entry);
        String aliasedObjectName = entryRdn + "," + ctx.getNameInNamespace();
        BasicAttributes alias = new BasicAttributes(true);
        BasicAttribute aliasOcls = new BasicAttribute("objectClass");
        aliasOcls.add("top");
        aliasOcls.add("extensibleObject");
        aliasOcls.add("alias");
        alias.put(aliasOcls);
        alias.put("ou", "bestFruit");
        alias.put("aliasedObjectName", aliasedObjectName);
        String rdnAlias = "ou=bestFruit";
        ctx.createSubcontext(rdnAlias, (Attributes)alias);
        ctx.destroySubcontext(rdnAlias);
        ctx.destroySubcontext(entryRdn);
    }

    @Test
    public void testAddDeleteAlias3() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)AddIT.getLdapServer()).lookup(BASE_DIRECTORY_APACHE_ORG);
        BasicAttributes entry = new BasicAttributes(true);
        BasicAttribute entryOcls = new BasicAttribute("objectClass");
        entryOcls.add("top");
        entryOcls.add("organizationalUnit");
        entry.put(entryOcls);
        entry.put("ou", "favorite");
        String entryRdn = "ou=favorite";
        ctx.createSubcontext(entryRdn, (Attributes)entry);
        String aliasedObjectName = entryRdn + "," + ctx.getNameInNamespace();
        BasicAttributes alias = new BasicAttributes(true);
        BasicAttribute aliasOcls = new BasicAttribute("objectClass");
        aliasOcls.add("top");
        aliasOcls.add("extensibleObject");
        aliasOcls.add("alias");
        alias.put(aliasOcls);
        alias.put("ou", "bestFruit");
        alias.put("aliasedObjectName", aliasedObjectName);
        String rdnAlias = "ou=bestFruit";
        ctx.createSubcontext(rdnAlias, (Attributes)alias);
        ctx.destroySubcontext(rdnAlias);
        ctx.destroySubcontext(entryRdn);
    }

    @Test
    public void testOnReferralWithManageDsaITControl() throws Exception {
        LDAPConnection conn = ServerIntegrationUtils.getNsdkWiredConnection((LdapServer)AddIT.getLdapServer());
        LDAPSearchConstraints constraints = new LDAPSearchConstraints();
        constraints.setClientControls(new LDAPControl("2.16.840.1.113730.3.4.2", true, Strings.EMPTY_BYTES));
        constraints.setServerControls(new LDAPControl("2.16.840.1.113730.3.4.2", true, Strings.EMPTY_BYTES));
        conn.setConstraints((LDAPConstraints)constraints);
        LDAPAttributeSet attrSet = new LDAPAttributeSet();
        attrSet.add(new LDAPAttribute("objectClass", "organizationalUnit"));
        attrSet.add(new LDAPAttribute("ou", "UnderReferral"));
        LDAPEntry entry = new LDAPEntry("ou=UnderReferral,uid=akarasuluref,ou=users,ou=system", attrSet);
        try {
            conn.add(entry, (LDAPConstraints)constraints);
            Assert.fail();
        }
        catch (LDAPException le) {
            Assert.assertEquals((long)ResultCodeEnum.REFERRAL.getValue(), (long)le.getLDAPResultCode());
        }
        try {
            conn.read("ou=UnderReferral,uid=akarasuluref,ou=users,ou=system", constraints);
            Assert.fail();
        }
        catch (LDAPException le) {
            // empty catch block
        }
        conn.disconnect();
    }

    public static LdapContext getContext(String principalDn, DirectoryService service, String dn) throws Exception {
        if (principalDn == null) {
            principalDn = "";
        }
        Dn userDn = new Dn(service.getSchemaManager(), new String[]{principalDn});
        LdapPrincipal principal = new LdapPrincipal(service.getSchemaManager(), userDn, AuthenticationLevel.SIMPLE);
        if (dn == null) {
            dn = "";
        }
        CoreSession session = service.getSession(principal);
        ServerLdapContext ctx = new ServerLdapContext(service, session, (Name)new LdapName(dn));
        return ctx;
    }

    @Test
    public void testOnReferralWitJNDIIgnore() throws Exception {
        LdapContext MNNCtx = AddIT.getContext("uid=admin,ou=system", AddIT.getLdapServer().getDirectoryService(), "uid=akarasuluref,ou=users,ou=system");
        MNNCtx.addToEnvironment("java.naming.referral", "ignore");
        try {
            BasicAttributes userEntry = new BasicAttributes("objectClass", "top", true);
            userEntry.get("objectClass").add("person");
            userEntry.put("sn", "elecharny");
            userEntry.put("cn", "Emmanuel Lecharny");
            MNNCtx.createSubcontext("cn=Emmanuel Lecharny, ou=apache, ou=people", (Attributes)userEntry);
            Assert.fail();
        }
        catch (PartialResultException pre) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testAncestorReferral() throws Exception {
        LOG.debug("");
        LDAPConnection conn = ServerIntegrationUtils.getNsdkWiredConnection((LdapServer)AddIT.getLdapServer());
        LDAPConstraints constraints = new LDAPConstraints();
        conn.setConstraints(constraints);
        LDAPAttributeSet attrSet = new LDAPAttributeSet();
        attrSet.add(new LDAPAttribute("objectClass", "organizationalUnit"));
        attrSet.add(new LDAPAttribute("ou", "UnderReferral"));
        LDAPEntry entry = new LDAPEntry("ou=UnderReferral,ou=Computers,uid=akarasuluref,ou=users,ou=system", attrSet);
        LDAPResponseListener listener = conn.add(entry, null, constraints);
        LDAPResponse response = listener.getResponse();
        Assert.assertEquals((long)ResultCodeEnum.REFERRAL.getValue(), (long)response.getResultCode());
        Assert.assertEquals((Object)"ldap://localhost:10389/ou=UnderReferral,ou=Computers,uid=akarasulu,ou=users,ou=system", (Object)response.getReferrals()[0]);
        Assert.assertEquals((Object)"ldap://foo:10389/ou=UnderReferral,ou=Computers,uid=akarasulu,ou=users,ou=system", (Object)response.getReferrals()[1]);
        Assert.assertEquals((Object)"ldap://bar:10389/ou=UnderReferral,ou=Computers,uid=akarasulu,ou=users,ou=system", (Object)response.getReferrals()[2]);
        conn.disconnect();
    }

    @Test
    public void testOnReferral() throws Exception {
        LDAPConnection conn = ServerIntegrationUtils.getNsdkWiredConnection((LdapServer)AddIT.getLdapServer());
        LDAPConstraints constraints = new LDAPConstraints();
        constraints.setReferrals(false);
        conn.setConstraints(constraints);
        LDAPAttributeSet attrSet = new LDAPAttributeSet();
        attrSet.add(new LDAPAttribute("objectClass", "organizationalUnit"));
        attrSet.add(new LDAPAttribute("ou", "UnderReferral"));
        LDAPEntry entry = new LDAPEntry("ou=UnderReferral,uid=akarasuluref,ou=users,ou=system", attrSet);
        LDAPResponseListener listener = null;
        LDAPResponse response = null;
        listener = conn.add(entry, null, constraints);
        response = listener.getResponse();
        Assert.assertEquals((long)ResultCodeEnum.REFERRAL.getValue(), (long)response.getResultCode());
        Assert.assertEquals((Object)"ldap://localhost:10389/ou=UnderReferral,uid=akarasulu,ou=users,ou=system", (Object)response.getReferrals()[0]);
        Assert.assertEquals((Object)"ldap://foo:10389/ou=UnderReferral,uid=akarasulu,ou=users,ou=system", (Object)response.getReferrals()[1]);
        Assert.assertEquals((Object)"ldap://bar:10389/ou=UnderReferral,uid=akarasulu,ou=users,ou=system", (Object)response.getReferrals()[2]);
        conn.disconnect();
    }

    @Test
    public void testThrowOnReferralWithJndi() throws Exception {
        LdapContext ctx = ServerIntegrationUtils.getWiredContextThrowOnRefferal((LdapServer)AddIT.getLdapServer());
        SearchControls controls = new SearchControls();
        controls.setReturningAttributes(new String[0]);
        controls.setSearchScope(0);
        BasicAttributes attrs = new BasicAttributes("objectClass", "organizationalUnit", true);
        attrs.put("ou", "UnderReferral");
        try {
            ctx.createSubcontext("ou=UnderReferral,uid=akarasuluref,ou=users,ou=system", (Attributes)attrs);
            Assert.fail((String)"Should never get here: add should fail with ReferralExcpetion");
        }
        catch (ReferralException e) {
            Assert.assertEquals((Object)"ldap://localhost:10389/ou=UnderReferral,uid=akarasulu,ou=users,ou=system", (Object)e.getReferralInfo());
        }
        ctx.close();
    }

    @Test
    public void testDIRSERVER_1183() throws Exception {
        LdapContext ctx = (LdapContext)ServerIntegrationUtils.getWiredContext((LdapServer)AddIT.getLdapServer()).lookup(BASE);
        BasicAttributes attrs = new BasicAttributes("objectClass", "inetOrgPerson", true);
        attrs.get("objectClass").add("organizationalPerson");
        attrs.get("objectClass").add("person");
        attrs.put("givenName", "Jim");
        attrs.put("sn", "Bean");
        attrs.put("cn", "Jim, Bean");
        DirContext jimBeanCtx = ctx.createSubcontext("cn=\"Jim, Bean\"", (Attributes)attrs);
        Assert.assertNotNull((Object)jimBeanCtx);
    }

    @Test
    public void testAddEntryNoRDNInEntry() throws Exception {
        String[] expectedOcls;
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)AddIT.getLdapServer()).lookup(BASE);
        Attributes person = new BasicAttributes("objectClass", "inetOrgPerson", true);
        person.get("objectClass").add("top");
        person.get("objectClass").add("person");
        person.get("objectClass").add("organizationalPerson");
        person.put("sn", "Michael Jackson");
        person.put("cn", "Jackson");
        DirContext michaelCtx = ctx.createSubcontext("givenname=Michael", person);
        Assert.assertNotNull((Object)michaelCtx);
        DirContext jackson = (DirContext)ctx.lookup("givenname=Michael");
        person = jackson.getAttributes("");
        javax.naming.directory.Attribute newOcls = person.get("objectClass");
        for (String name : expectedOcls = new String[]{"top", "person", "organizationalPerson", "inetOrgPerson"}) {
            Assert.assertTrue((String)("object class " + name + " is present"), (boolean)newOcls.contains(name));
        }
        javax.naming.directory.Attribute givenName = person.get("givenname");
        Assert.assertEquals((Object)"Michael", (Object)givenName.get());
    }

    @Test
    public void testAddEntryDifferentRDNInEntry() throws Exception {
        String[] expectedCns;
        String[] expectedOcls;
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)AddIT.getLdapServer()).lookup(BASE);
        Attributes person = new BasicAttributes("objectClass", "inetOrgPerson", true);
        person.get("objectClass").add("top");
        person.get("objectClass").add("person");
        person.get("objectClass").add("organizationalPerson");
        person.put("givenName", "Michael");
        person.put("sn", "Michael Jackson");
        person.put("cn", "Jackson");
        DirContext michaelCtx = ctx.createSubcontext("cn=Michael", person);
        Assert.assertNotNull((Object)michaelCtx);
        DirContext jackson = (DirContext)ctx.lookup("cn=Michael");
        person = jackson.getAttributes("");
        javax.naming.directory.Attribute newOcls = person.get("objectClass");
        for (String name : expectedOcls = new String[]{"top", "person", "organizationalPerson", "inetOrgPerson"}) {
            Assert.assertTrue((String)("object class " + name + " is present"), (boolean)newOcls.contains(name));
        }
        javax.naming.directory.Attribute cn = person.get("cn");
        Assert.assertEquals((long)2L, (long)cn.size());
        for (String name : expectedCns = new String[]{"Jackson", "Michael"}) {
            Assert.assertTrue((String)("CN " + name + " is present"), (boolean)cn.contains(name));
        }
    }

    @Test
    public void testAddEntryDifferentRDNSingleValuedInEntry() throws Exception {
        String[] expectedOcls;
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)AddIT.getLdapServer()).lookup(BASE);
        Attributes person = new BasicAttributes("objectClass", "inetOrgPerson", true);
        person.get("objectClass").add("top");
        person.get("objectClass").add("person");
        person.get("objectClass").add("organizationalPerson");
        person.put("displayName", "Michael");
        person.put("sn", "Michael Jackson");
        person.put("cn", "Jackson");
        DirContext michaelCtx = ctx.createSubcontext("displayName=test", person);
        Assert.assertNotNull((Object)michaelCtx);
        DirContext jackson = (DirContext)ctx.lookup("displayName=test");
        person = jackson.getAttributes("");
        javax.naming.directory.Attribute newOcls = person.get("objectClass");
        for (String name : expectedOcls = new String[]{"top", "person", "organizationalPerson", "inetOrgPerson"}) {
            Assert.assertTrue((String)("object class " + name + " is present"), (boolean)newOcls.contains(name));
        }
        javax.naming.directory.Attribute displayName = person.get("displayName");
        Assert.assertEquals((long)1L, (long)displayName.size());
        Assert.assertTrue((boolean)displayName.contains("test"));
    }

    @Test
    public void testAddEntryComposedRDN() throws Exception {
        String[] expectedOcls;
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)AddIT.getLdapServer()).lookup(BASE);
        Attributes person = new BasicAttributes("objectClass", "inetOrgPerson", true);
        person.get("objectClass").add("top");
        person.get("objectClass").add("person");
        person.get("objectClass").add("organizationalPerson");
        person.put("sn", "Michael Jackson");
        person.put("cn", "Jackson");
        DirContext michaelCtx = ctx.createSubcontext("displayName=test+cn=Michael", person);
        Assert.assertNotNull((Object)michaelCtx);
        DirContext jackson = (DirContext)ctx.lookup("displayName=test+cn=Michael");
        person = jackson.getAttributes("");
        javax.naming.directory.Attribute newOcls = person.get("objectClass");
        for (String name : expectedOcls = new String[]{"top", "person", "organizationalPerson", "inetOrgPerson"}) {
            Assert.assertTrue((String)("object class " + name + " is present"), (boolean)newOcls.contains(name));
        }
        javax.naming.directory.Attribute displayName = person.get("displayName");
        Assert.assertEquals((long)1L, (long)displayName.size());
        Assert.assertTrue((boolean)displayName.contains("test"));
        javax.naming.directory.Attribute cn = person.get("cn");
        Assert.assertEquals((long)2L, (long)cn.size());
        Assert.assertTrue((boolean)cn.contains("Jackson"));
        Assert.assertTrue((boolean)cn.contains("Michael"));
    }

    @Test
    public void testAddPDUExceedingMaxSizeJNDI() throws Exception {
        AddIT.getLdapServer().getDirectoryService().setMaxPDUSize(1024);
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)AddIT.getLdapServer()).lookup(BASE);
        Attributes attributes = new BasicAttributes(true);
        BasicAttribute ocls = new BasicAttribute("description");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 128; ++i) {
            sb.append("0123456789ABCDEF");
        }
        ocls.add(sb.toString());
        attributes.put(ocls);
        DirContext person = (DirContext)ctx.lookup(RDN);
        try {
            person.modifyAttributes("", 1, attributes);
            Assert.fail();
        }
        catch (Exception e) {
            // empty catch block
        }
        AddIT.getLdapServer().getDirectoryService().setMaxPDUSize(4096);
        ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)AddIT.getLdapServer()).lookup(BASE);
        person = (DirContext)ctx.lookup(RDN);
        try {
            person.modifyAttributes("", 1, attributes);
        }
        catch (Exception e) {
            Assert.fail();
        }
        ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)AddIT.getLdapServer()).lookup(BASE);
        person = (DirContext)ctx.lookup(RDN);
        Assert.assertNotNull((Object)person);
        attributes = person.getAttributes("");
        javax.naming.directory.Attribute newOcls = attributes.get("objectClass");
        Assert.assertNotNull((Object)newOcls);
    }

    @Test
    public void testAddPDUExceedingMaxSizeLdapApi() throws Exception {
        AddIT.getLdapServer().getDirectoryService().setMaxPDUSize(1024);
        LdapNetworkConnection connection = new LdapNetworkConnection("localhost", AddIT.getLdapServer().getPort());
        connection.bind("uid=admin,ou=system", "secret");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 128; ++i) {
            sb.append("0123456789ABCDEF");
        }
        DefaultAttribute description = new DefaultAttribute("description", new String[]{sb.toString()});
        try {
            DefaultModification modification = new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, (Attribute)description);
            connection.modify("cn=the person, ou=system", new Modification[]{modification});
            Assert.fail();
        }
        catch (Exception e) {
            if (connection.isConnected()) {
                Thread.sleep(1000L);
            }
            Assert.assertFalse((boolean)connection.isConnected());
        }
    }

    @Test
    public void testAddUnescapedRdnValue_DIRSERVER_1311() throws Exception {
        LdapContext ctx = (LdapContext)ServerIntegrationUtils.getWiredContext((LdapServer)AddIT.getLdapServer()).lookup(BASE);
        BasicAttributes tori = new BasicAttributes(true);
        BasicAttribute toriOC = new BasicAttribute("objectClass");
        toriOC.add("top");
        toriOC.add("person");
        tori.put(toriOC);
        tori.put("cn", "Tori,Amos");
        tori.put("sn", "Amos");
        ctx.createSubcontext(" cn = Amos\\,Tori ", (Attributes)tori);
        BasicAttributes binary = new BasicAttributes(true);
        BasicAttribute binaryOC = new BasicAttribute("objectClass");
        binaryOC.add("top");
        binaryOC.add("person");
        binary.put(binaryOC);
        binary.put("cn", "Binary");
        binary.put("sn", "Binary");
        binary.put("userPassword", "test");
        ctx.createSubcontext(" userPassword = #414243 ", (Attributes)binary);
        SearchControls controls = new SearchControls();
        NamingEnumeration<SearchResult> res = ctx.search("", "(cn=Amos,Tori)", controls);
        Assert.assertTrue((boolean)res.hasMore());
        javax.naming.directory.Attribute cnAttribute = res.next().getAttributes().get("cn");
        Assert.assertEquals((long)2L, (long)cnAttribute.size());
        Assert.assertTrue((boolean)cnAttribute.contains("Tori,Amos"));
        Assert.assertTrue((boolean)cnAttribute.contains("Amos,Tori"));
        Assert.assertFalse((boolean)res.hasMore());
        res = ctx.search("", "(userPassword=\\41\\42\\43)", controls);
        Assert.assertTrue((boolean)res.hasMore());
        javax.naming.directory.Attribute userPasswordAttribute = res.next().getAttributes().get("userPassword");
        Assert.assertEquals((long)2L, (long)userPasswordAttribute.size());
        Assert.assertTrue((boolean)userPasswordAttribute.contains(Strings.getBytesUtf8((String)"test")));
        Assert.assertTrue((boolean)userPasswordAttribute.contains(Strings.getBytesUtf8((String)"ABC")));
        Assert.assertFalse((boolean)res.hasMore());
    }

    @Test
    public void testAddEntryUUIDAndCSNAttributes() throws Exception {
        LdapConnection con = ServerIntegrationUtils.getAdminConnection((LdapServer)AddIT.getLdapServer());
        String dn = "cn=Kate Bush,ou=system";
        DefaultEntry entry = new DefaultEntry(dn);
        entry.add("objectclass", new String[]{"top", "person"});
        entry.add("sn", new String[]{"Bush"});
        entry.add("cn", new String[]{"Kate Bush"});
        String descr = "a British singer-songwriter with an expressive four-octave voice";
        entry.add("description", new String[]{descr});
        UUID uuid = UUID.randomUUID();
        entry.add("entryUUID", new String[]{uuid.toString()});
        CsnFactory csnFac = new CsnFactory(0);
        Csn csn = csnFac.newInstance();
        entry.add("entryCSN", new String[]{csn.toString()});
        con.add((Entry)entry);
        Entry addedEntry = con.lookup(dn, new String[]{"*", "+"});
        Assert.assertNotNull((Object)addedEntry);
        Attribute attr = addedEntry.get("entryUUID");
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((Object)uuid.toString(), (Object)attr.getString());
        attr = addedEntry.get("entryCSN");
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((Object)csn.toString(), (Object)attr.getString());
        con.delete(dn);
        con.unBind();
    }

    protected Attributes getPersonAttributes(String sn, String cn) {
        BasicAttributes attrs = new BasicAttributes(true);
        BasicAttribute ocls = new BasicAttribute("objectClass");
        ocls.add("top");
        ocls.add("person");
        attrs.put(ocls);
        attrs.put("cn", cn);
        attrs.put("sn", sn);
        return attrs;
    }

    protected Attributes getOrgUnitAttributes(String ou) {
        BasicAttributes attrs = new BasicAttributes(true);
        BasicAttribute ocls = new BasicAttribute("objectClass");
        ocls.add("top");
        ocls.add("organizationalUnit");
        attrs.put(ocls);
        attrs.put("ou", ou);
        return attrs;
    }

    @Test
    @CreateDS(enableChangeLog=false, name="DSAlias")
    @CreateLdapServer(name="DSAlias", transports={@CreateTransport(protocol="LDAP", port=-1)})
    public void test_DIRSERVER_1357() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)AddIT.getLdapServer()).lookup(BASE);
        Attributes salesAttrs = this.getOrgUnitAttributes("sales");
        ctx.createSubcontext("ou=sales", salesAttrs);
        Attributes engAttrs = this.getOrgUnitAttributes("engineering");
        ctx.createSubcontext("ou=engineering", engAttrs);
        Attributes fooAttrs = this.getPersonAttributes("real", "real");
        ctx.createSubcontext("cn=real,ou=sales", fooAttrs);
        BasicAttributes aliasAttrs = new BasicAttributes(true);
        BasicAttribute aliasOC = new BasicAttribute("objectClass");
        aliasOC.add("top");
        aliasOC.add("alias");
        aliasOC.add("extensibleObject");
        aliasAttrs.put(aliasOC);
        aliasAttrs.put("cn", "alias");
        aliasAttrs.put("aliasedObjectName", "cn=real,ou=sales,ou=system");
        ctx.createSubcontext("cn=alias,ou=engineering", (Attributes)aliasAttrs);
        ctx.destroySubcontext("cn=real,ou=sales");
        ctx.destroySubcontext("cn=alias,ou=engineering");
    }

    @Test
    public void testAddEntryNonExistingAT() throws Exception {
        LdapConnection connection = ServerIntegrationUtils.getAdminConnection((LdapServer)AddIT.getLdapServer());
        Dn dn = new Dn(new String[]{"cn=Kate Bush,ou=system"});
        DefaultEntry personEntry = new DefaultEntry();
        personEntry.add("objectClass", new String[]{"person"});
        personEntry.add("cn", new String[]{"Kate Bush"});
        personEntry.add("sn", new String[]{"Bush"});
        personEntry.add("nonExistingAttribute", new String[]{"value"});
        personEntry.setDn(dn);
        try {
            connection.add((Entry)personEntry);
            Assert.fail((String)"should throw LdapNoSuchAttributeException");
        }
        catch (LdapNoSuchAttributeException e) {
            // empty catch block
        }
        Entry entry = connection.lookup(dn);
        Assert.assertNull((Object)entry);
        connection.close();
    }

    @Test(expected=LdapOperationException.class)
    public void testAddEntryNonExistingOC() throws Exception {
        LdapConnection connection = ServerIntegrationUtils.getAdminConnection((LdapServer)AddIT.getLdapServer());
        Dn dn = new Dn(new String[]{"cn=Kate Bush,ou=system"});
        DefaultEntry personEntry = new DefaultEntry();
        personEntry.add("objectClass", new String[]{"nonexistingOC"});
        personEntry.add("cn", new String[]{"Kate Bush"});
        personEntry.add("sn", new String[]{"Bush"});
        personEntry.setDn(dn);
        connection.add((Entry)personEntry);
    }

    @Test(expected=LdapException.class)
    public void testAddEntry100KData() throws Exception {
        LdapConnection connection = ServerIntegrationUtils.getAdminConnection((LdapServer)AddIT.getLdapServer());
        int size = 102400;
        byte[] dataBytes = new byte[size];
        for (int i = 0; i < size; ++i) {
            dataBytes[i] = 65;
        }
        String data = Strings.utf8ToString((byte[])dataBytes);
        Dn dn = new Dn(new String[]{"cn=Kate Bush,ou=system"});
        DefaultEntry personEntry = new DefaultEntry("cn=Kate Bush,ou=system", new Object[]{"objectClass: top", "objectClass: person", "cn: Kate Bush", "sn: Bush", "description", data});
        connection.add((Entry)personEntry);
        Entry entry = connection.lookup(dn, new String[]{"description", "cn", "sn"});
        String description = entry.get("description").getString();
        Assert.assertNotNull((Object)description);
        Assert.assertTrue((boolean)description.startsWith("AAA"));
        Assert.assertEquals((long)size, (long)description.length());
        for (int i = 0; i < size; ++i) {
            Assert.assertEquals((long)65L, (long)description.charAt(i));
        }
    }
}

