/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.search;

import org.apache.directory.api.ldap.model.cursor.EntryCursor;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchRequestImpl;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.junit.tools.MultiThreadedMultiInvoker;
import org.apache.directory.ldap.client.api.EntryCursorImpl;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
public class SearchPerfIT
extends AbstractLdapTestUnit {
    @Rule
    public MultiThreadedMultiInvoker i = new MultiThreadedMultiInvoker(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSearchRequestObjectScopePerf() throws Exception {
        LdapNetworkConnection connection = new LdapNetworkConnection("localhost", SearchPerfIT.getLdapServer().getPort());
        long deltaSearch = 0L;
        long deltaGet = 0L;
        long deltaClose = 0L;
        try {
            connection.bind("uid=admin,ou=system", "secret");
            EntryCursor cursor = connection.search("uid=admin,ou=system", "(ObjectClass=*)", SearchScope.OBJECT, new String[]{"*"});
            int i = 0;
            while (cursor.next()) {
                cursor.get();
                ++i;
            }
            cursor.close();
            Assert.assertEquals((long)1L, (long)i);
            for (int j = 0; j < 10000; ++j) {
                cursor = connection.search("uid=admin,ou=system", "(ObjectClass=*)", SearchScope.OBJECT, new String[]{"*"});
                while (cursor.next()) {
                }
                cursor.close();
            }
            Dn dn = new Dn(SearchPerfIT.getService().getSchemaManager(), new String[]{"uid=admin,ou=system"});
            SearchRequestImpl searchRequest = new SearchRequestImpl();
            searchRequest.setBase(dn);
            searchRequest.setFilter("(ObjectClass=*)");
            searchRequest.setScope(SearchScope.OBJECT);
            searchRequest.addAttributes(new String[]{"*"});
            searchRequest.setDerefAliases(AliasDerefMode.DEREF_ALWAYS);
            long t0 = System.currentTimeMillis();
            long t00 = 0L;
            long tt0 = System.currentTimeMillis();
            int nbIterations = 200000;
            int count = 0;
            for (int j = 0; j < nbIterations; ++j) {
                if (j % 10000 == 0) {
                    long tt1 = System.currentTimeMillis();
                    System.out.println(j + ", " + (tt1 - tt0));
                    tt0 = tt1;
                }
                if (j == 50000) {
                    t00 = System.currentTimeMillis();
                }
                long dt0 = System.nanoTime();
                cursor = new EntryCursorImpl(connection.search((SearchRequest)searchRequest));
                long dt1 = System.nanoTime();
                deltaSearch += Math.abs(dt1 - dt0);
                while (cursor.next()) {
                    long dt2 = System.nanoTime();
                    cursor.get();
                    ++count;
                    long dt3 = System.nanoTime();
                    deltaGet += Math.abs(dt3 - dt2);
                }
                long dt4 = System.nanoTime();
                cursor.close();
                long dt5 = System.nanoTime();
                deltaClose += Math.abs(dt5 - dt4);
            }
            long t1 = System.currentTimeMillis();
            Long deltaWarmed = t1 - t00;
            System.out.println("Delta : " + deltaWarmed + "( " + (long)((nbIterations - 50000) * 1000) / deltaWarmed + " per s ) /" + (t1 - t0) + " , count : " + count);
            System.out.println("DeltaSearch : " + deltaSearch / (long)nbIterations);
            System.out.println("DeltaGet : " + deltaGet / (long)nbIterations);
            System.out.println("DeltaClose : " + deltaClose / (long)nbIterations);
        }
        catch (LdapException e) {
            e.printStackTrace();
            Assert.fail((String)"Should not have caught exception.");
        }
        finally {
            connection.unBind();
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSearchRequestOneLevelScopePerf() throws Exception {
        LdapNetworkConnection connection = new LdapNetworkConnection("localhost", SearchPerfIT.getLdapServer().getPort());
        try {
            connection.bind("uid=admin,ou=system", "secret");
            EntryCursor cursor = connection.search("ou=system", "(ObjectClass=*)", SearchScope.ONELEVEL, new String[]{"*"});
            int i = 0;
            while (cursor.next()) {
                cursor.get();
                ++i;
            }
            cursor.close();
            Assert.assertEquals((long)5L, (long)i);
            for (int j = 0; j < 10000; ++j) {
                cursor = connection.search("ou=system", "(ObjectClass=*)", SearchScope.ONELEVEL, new String[]{"*"});
                while (cursor.next()) {
                    cursor.get();
                }
                cursor.close();
            }
            Dn dn = new Dn(SearchPerfIT.getService().getSchemaManager(), new String[]{"uid=admin,ou=system"});
            SearchRequestImpl searchRequest = new SearchRequestImpl();
            searchRequest.setBase(dn);
            searchRequest.setFilter("(ObjectClass=*)");
            searchRequest.setScope(SearchScope.ONELEVEL);
            searchRequest.addAttributes(new String[]{"*"});
            searchRequest.setDerefAliases(AliasDerefMode.DEREF_ALWAYS);
            long t0 = System.currentTimeMillis();
            long t00 = 0L;
            long tt0 = System.currentTimeMillis();
            int nbIterations = 200000;
            int count = 0;
            for (int j = 0; j < nbIterations; ++j) {
                if (j % 10000 == 0) {
                    long tt1 = System.currentTimeMillis();
                    System.out.println(j + ", " + (tt1 - tt0));
                    tt0 = tt1;
                }
                if (j == 50000) {
                    t00 = System.currentTimeMillis();
                }
                cursor = connection.search("ou=system", "(ObjectClass=*)", SearchScope.ONELEVEL, new String[]{"*"});
                while (cursor.next()) {
                    ++count;
                    cursor.get();
                }
                cursor.close();
            }
            long t1 = System.currentTimeMillis();
            Long deltaWarmed = t1 - t00;
            System.out.println("Delta : " + deltaWarmed + "( " + (long)((nbIterations - 50000) * 1000) / deltaWarmed * 5L + " per s ) /" + (t1 - t0) + ", count : " + count);
        }
        catch (LdapException e) {
            e.printStackTrace();
            Assert.fail((String)"Should not have caught exception.");
        }
        finally {
            connection.unBind();
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSearchRequestSubtreeLevelScopePerf() throws Exception {
        LdapNetworkConnection connection = new LdapNetworkConnection("localhost", SearchPerfIT.getLdapServer().getPort());
        connection.setTimeOut(0L);
        try {
            connection.bind("uid=admin,ou=system", "secret");
            EntryCursor cursor = connection.search("ou=system", "(ObjectClass=*)", SearchScope.SUBTREE, new String[]{"*"});
            int i = 0;
            while (cursor.next()) {
                cursor.get();
                ++i;
            }
            cursor.close();
            Assert.assertEquals((long)10L, (long)i);
            for (int j = 0; j < 10000; ++j) {
                cursor = connection.search("ou=system", "(ObjectClass=*)", SearchScope.SUBTREE, new String[]{"*"});
                while (cursor.next()) {
                    cursor.get();
                }
                cursor.close();
            }
            Dn dn = new Dn(SearchPerfIT.getService().getSchemaManager(), new String[]{"uid=admin,ou=system"});
            SearchRequestImpl searchRequest = new SearchRequestImpl();
            searchRequest.setBase(dn);
            searchRequest.setFilter("(ObjectClass=*)");
            searchRequest.setScope(SearchScope.SUBTREE);
            searchRequest.addAttributes(new String[]{"*"});
            searchRequest.setDerefAliases(AliasDerefMode.DEREF_ALWAYS);
            long t0 = System.currentTimeMillis();
            long t00 = 0L;
            long tt0 = System.currentTimeMillis();
            int nbIterations = 200000;
            int count = 0;
            for (int j = 0; j < nbIterations; ++j) {
                if (j % 10000 == 0) {
                    long tt1 = System.currentTimeMillis();
                    System.out.println(j + ", " + (tt1 - tt0));
                    tt0 = tt1;
                }
                if (j == 50000) {
                    t00 = System.currentTimeMillis();
                }
                cursor = connection.search("ou=system", "(ObjectClass=*)", SearchScope.SUBTREE, new String[]{"*"});
                while (cursor.next()) {
                    ++count;
                    cursor.get();
                }
                cursor.close();
            }
            long t1 = System.currentTimeMillis();
            Long deltaWarmed = t1 - t00;
            System.out.println("Delta : " + deltaWarmed + "( " + (long)((nbIterations - 50000) * 1000) / deltaWarmed * 10L + " per s ) /" + (t1 - t0) + ", count : " + count);
        }
        catch (LdapException e) {
            e.printStackTrace();
            Assert.fail((String)"Should not have caught exception.");
        }
        finally {
            connection.unBind();
            connection.close();
        }
    }
}

