/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ppolicy;

import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.ldap.extras.controls.ppolicy.PasswordPolicy;
import org.apache.directory.api.ldap.extras.controls.ppolicy.PasswordPolicyErrorEnum;
import org.apache.directory.api.ldap.extras.controls.ppolicy.PasswordPolicyImpl;
import org.apache.directory.api.ldap.extras.controls.ppolicy_impl.PasswordPolicyDecorator;
import org.apache.directory.api.ldap.model.constants.LdapSecurityConstants;
import org.apache.directory.api.ldap.model.constants.SchemaConstants;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.AddRequest;
import org.apache.directory.api.ldap.model.message.AddRequestImpl;
import org.apache.directory.api.ldap.model.message.AddResponse;
import org.apache.directory.api.ldap.model.message.BindRequest;
import org.apache.directory.api.ldap.model.message.BindRequestImpl;
import org.apache.directory.api.ldap.model.message.BindResponse;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.ModifyRequest;
import org.apache.directory.api.ldap.model.message.ModifyRequestImpl;
import org.apache.directory.api.ldap.model.message.ModifyResponse;
import org.apache.directory.api.ldap.model.message.Response;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.password.PasswordUtil;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.api.InterceptorEnum;
import org.apache.directory.server.core.api.authn.ppolicy.PasswordPolicyConfiguration;
import org.apache.directory.server.core.authn.AuthenticationInterceptor;
import org.apache.directory.server.core.authn.ppolicy.PpolicyConfigContainer;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.core.integ.IntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP"), @CreateTransport(protocol="LDAPS")})
@CreateDS(enableChangeLog=false, name="PasswordPolicyTest")
public class PasswordPolicyIT
extends AbstractLdapTestUnit {
    private PasswordPolicyConfiguration policyConfig;
    private static final LdapApiService codec = LdapApiServiceFactory.getSingleton();
    private static final PasswordPolicyDecorator PP_REQ_CTRL = new PasswordPolicyDecorator(codec, (PasswordPolicy)new PasswordPolicyImpl());

    @Before
    public void setPwdPolicy() throws LdapException {
        this.policyConfig = new PasswordPolicyConfiguration();
        this.policyConfig.setPwdMaxAge(110);
        this.policyConfig.setPwdFailureCountInterval(30);
        this.policyConfig.setPwdMaxFailure(2);
        this.policyConfig.setPwdLockout(true);
        this.policyConfig.setPwdLockoutDuration(0);
        this.policyConfig.setPwdMinLength(5);
        this.policyConfig.setPwdInHistory(5);
        this.policyConfig.setPwdExpireWarning(600);
        this.policyConfig.setPwdGraceAuthNLimit(5);
        this.policyConfig.setPwdCheckQuality(2);
        PpolicyConfigContainer policyContainer = new PpolicyConfigContainer();
        policyContainer.setDefaultPolicy(this.policyConfig);
        AuthenticationInterceptor authenticationInterceptor = (AuthenticationInterceptor)PasswordPolicyIT.getService().getInterceptor(InterceptorEnum.AUTHENTICATION_INTERCEPTOR.getName());
        authenticationInterceptor.setPwdPolicies(policyContainer);
        AuthenticationInterceptor authInterceptor = (AuthenticationInterceptor)PasswordPolicyIT.getService().getInterceptor(InterceptorEnum.AUTHENTICATION_INTERCEPTOR.getName());
        authInterceptor.loadPwdPolicyStateAtributeTypes();
    }

    @After
    public void closeConnections() {
        IntegrationUtils.closeConnections();
    }

    @Test
    public void testAddUserWithClearTextPwd() throws Exception {
        LdapConnection connection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PasswordPolicyIT.getLdapServer());
        Dn userDn = new Dn(new String[]{"cn=user,ou=system"});
        DefaultEntry userEntry = new DefaultEntry(userDn.toString(), new Object[]{"ObjectClass: top", "ObjectClass: person", "cn: user", "sn: user_sn", "userPassword: 1234"});
        AddRequestImpl addRequest = new AddRequestImpl();
        addRequest.setEntry((Entry)userEntry);
        addRequest.addControl((Control)PP_REQ_CTRL);
        AddResponse addResp = connection.add((AddRequest)addRequest);
        Assert.assertEquals((Object)ResultCodeEnum.CONSTRAINT_VIOLATION, (Object)addResp.getLdapResult().getResultCode());
        PasswordPolicy respCtrl = this.getPwdRespCtrl((Response)addResp);
        Assert.assertNotNull((Object)respCtrl);
        Assert.assertEquals((Object)PasswordPolicyErrorEnum.PASSWORD_TOO_SHORT, (Object)respCtrl.getResponse().getPasswordPolicyError());
        Attribute pwdAt = userEntry.get("userPassword");
        pwdAt.clear();
        pwdAt.add(new String[]{"12345"});
        addResp = connection.add((AddRequest)addRequest);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)addResp.getLdapResult().getResultCode());
        respCtrl = this.getPwdRespCtrl((Response)addResp);
        Assert.assertNull((Object)respCtrl);
        LdapConnection userConnection = IntegrationUtils.getNetworkConnectionAs((LdapServer)PasswordPolicyIT.getLdapServer(), (String)userDn.getName(), (String)"12345");
        Assert.assertNotNull((Object)userConnection);
        Assert.assertTrue((boolean)userConnection.isAuthenticated());
    }

    @Test
    public void testAddUserWithHashedPwd() throws Exception {
        LdapConnection connection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PasswordPolicyIT.getLdapServer());
        byte[] password = PasswordUtil.createStoragePassword((String)"12345", (LdapSecurityConstants)LdapSecurityConstants.HASH_METHOD_CRYPT);
        DefaultEntry userEntry = new DefaultEntry("cn=hashedpwd,ou=system");
        userEntry.add("ObjectCLass", new String[]{"person"});
        userEntry.add("cn", new String[]{"hashedpwd"});
        userEntry.add("sn", new String[]{"hashedpwd_sn"});
        userEntry.add("userPassword", (byte[][])new byte[][]{password});
        AddRequestImpl addRequest = new AddRequestImpl();
        addRequest.setEntry((Entry)userEntry);
        addRequest.addControl((Control)PP_REQ_CTRL);
        AddResponse addResp = connection.add((AddRequest)addRequest);
        Assert.assertEquals((Object)ResultCodeEnum.CONSTRAINT_VIOLATION, (Object)addResp.getLdapResult().getResultCode());
        PasswordPolicy respCtrl = this.getPwdRespCtrl((Response)addResp);
        Assert.assertNotNull((Object)respCtrl);
        Assert.assertEquals((Object)PasswordPolicyErrorEnum.INSUFFICIENT_PASSWORD_QUALITY, (Object)respCtrl.getResponse().getPasswordPolicyError());
        this.policyConfig.setPwdCheckQuality(1);
        Attribute pwdAt = userEntry.get("userPassword");
        pwdAt.clear();
        pwdAt.add((byte[][])new byte[][]{password});
        addResp = connection.add((AddRequest)addRequest);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)addResp.getLdapResult().getResultCode());
        respCtrl = this.getPwdRespCtrl((Response)addResp);
        Assert.assertNull((Object)respCtrl);
        LdapConnection userConnection = IntegrationUtils.getNetworkConnectionAs((LdapServer)PasswordPolicyIT.getLdapServer(), (String)"cn=hashedpwd,ou=system", (String)"12345");
        Assert.assertNotNull((Object)userConnection);
        Assert.assertTrue((boolean)userConnection.isAuthenticated());
    }

    @Test
    public void testPwdLockoutForever() throws Exception {
        this.policyConfig.setPwdMaxFailure(2);
        this.policyConfig.setPwdLockout(true);
        this.policyConfig.setPwdLockoutDuration(0);
        this.policyConfig.setPwdGraceAuthNLimit(2);
        this.policyConfig.setPwdFailureCountInterval(30);
        LdapConnection adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PasswordPolicyIT.getLdapServer());
        Dn userDn = new Dn(new String[]{"cn=user2,ou=system"});
        DefaultEntry userEntry = new DefaultEntry(userDn.toString(), new Object[]{"ObjectClass: top", "ObjectClass: person", "cn: user2", "sn: user_sn", "userPassword: 12345"});
        AddRequestImpl addRequest = new AddRequestImpl();
        addRequest.setEntry((Entry)userEntry);
        addRequest.addControl((Control)PP_REQ_CTRL);
        AddResponse addResp = adminConnection.add((AddRequest)addRequest);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)addResp.getLdapResult().getResultCode());
        PasswordPolicy respCtrl = this.getPwdRespCtrl((Response)addResp);
        Assert.assertNull((Object)respCtrl);
        BindRequestImpl bindReq = new BindRequestImpl();
        bindReq.setDn(userDn);
        bindReq.setCredentials("1234");
        bindReq.addControl((Control)PP_REQ_CTRL);
        LdapNetworkConnection userConnection = new LdapNetworkConnection("localhost", ldapServer.getPort());
        for (int i = 0; i < 3; ++i) {
            userConnection.bind((BindRequest)bindReq);
            Assert.assertFalse((boolean)userConnection.isAuthenticated());
        }
        Thread.sleep(2000L);
        userEntry = adminConnection.lookup(userDn, SchemaConstants.ALL_ATTRIBUTES_ARRAY);
        Attribute pwdAccountLockedTime = userEntry.get("pwdAccountLockedTime");
        Assert.assertNotNull((Object)pwdAccountLockedTime);
        Assert.assertEquals((Object)"000001010000Z", (Object)pwdAccountLockedTime.getString());
        bindReq = new BindRequestImpl();
        bindReq.setDn(userDn);
        bindReq.setCredentials("12345");
        bindReq.addControl((Control)PP_REQ_CTRL);
        userConnection.bind((BindRequest)bindReq);
        Assert.assertFalse((boolean)userConnection.isAuthenticated());
        userConnection.close();
        ModifyRequestImpl modReq = new ModifyRequestImpl();
        modReq.setName(userDn);
        modReq.addControl((Control)PP_REQ_CTRL);
        modReq.remove(userEntry.get("userPassword"));
        ModifyResponse modResp = adminConnection.modify((ModifyRequest)modReq);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)modResp.getLdapResult().getResultCode());
        userEntry = adminConnection.lookup(userDn, new String[]{"+"});
        Assert.assertNull((Object)userEntry.get("pwdFailureTime"));
        Assert.assertNull((Object)userEntry.get("pwdGraceUseTime"));
        Assert.assertNull((Object)userEntry.get("pwdHistory"));
        Assert.assertNull((Object)userEntry.get("pwdChangedTime"));
        Assert.assertNull((Object)userEntry.get("pwdAccountLockedTime"));
    }

    @Test
    public void testPwdMinAge() throws Exception {
        this.policyConfig.setPwdMinAge(5);
        LdapConnection connection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PasswordPolicyIT.getLdapServer());
        Dn userDn = new Dn(new String[]{"cn=userMinAge,ou=system"});
        DefaultEntry userEntry = new DefaultEntry(userDn.toString(), new Object[]{"ObjectClass: top", "ObjectClass: person", "cn: userMinAge", "sn: userMinAge_sn", "userPassword: 12345"});
        AddRequestImpl addRequest = new AddRequestImpl();
        addRequest.setEntry((Entry)userEntry);
        addRequest.addControl((Control)PP_REQ_CTRL);
        AddResponse addResp = connection.add((AddRequest)addRequest);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)addResp.getLdapResult().getResultCode());
        PasswordPolicy respCtrl = this.getPwdRespCtrl((Response)addResp);
        Assert.assertNull((Object)respCtrl);
        ModifyRequestImpl modReq = new ModifyRequestImpl();
        modReq.setName(userDn);
        modReq.addControl((Control)PP_REQ_CTRL);
        modReq.replace("userPassword", new String[]{"123456"});
        ModifyResponse modResp = connection.modify((ModifyRequest)modReq);
        Assert.assertEquals((Object)ResultCodeEnum.CONSTRAINT_VIOLATION, (Object)modResp.getLdapResult().getResultCode());
        respCtrl = this.getPwdRespCtrl((Response)modResp);
        Assert.assertEquals((Object)PasswordPolicyErrorEnum.PASSWORD_TOO_YOUNG, (Object)respCtrl.getResponse().getPasswordPolicyError());
        Thread.sleep(5000L);
        modResp = connection.modify((ModifyRequest)modReq);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)modResp.getLdapResult().getResultCode());
        LdapConnection userConnection = IntegrationUtils.getNetworkConnectionAs((LdapServer)PasswordPolicyIT.getLdapServer(), (String)userDn.getName(), (String)"123456");
        Assert.assertNotNull((Object)userConnection);
        Assert.assertTrue((boolean)userConnection.isAuthenticated());
    }

    @Test
    public void testPwdHistory() throws Exception {
        this.policyConfig.setPwdInHistory(2);
        LdapConnection connection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PasswordPolicyIT.getLdapServer());
        Dn userDn = new Dn(new String[]{"cn=userPwdHist,ou=system"});
        DefaultEntry userEntry = new DefaultEntry(userDn.toString(), new Object[]{"ObjectClass: top", "ObjectClass: person", "cn: userPwdHist", "sn: userPwdHist_sn", "userPassword: 12345"});
        AddRequestImpl addRequest = new AddRequestImpl();
        addRequest.setEntry((Entry)userEntry);
        addRequest.addControl((Control)PP_REQ_CTRL);
        connection.add((AddRequest)addRequest);
        Entry entry = connection.lookup(userDn, new String[]{"*", "+"});
        Attribute pwdHistAt = entry.get("pwdHistory");
        Assert.assertNotNull((Object)pwdHistAt);
        Assert.assertEquals((long)1L, (long)pwdHistAt.size());
        Thread.sleep(1000L);
        ModifyRequestImpl modReq = new ModifyRequestImpl();
        modReq.setName(userDn);
        modReq.addControl((Control)PP_REQ_CTRL);
        modReq.replace("userPassword", new String[]{"67891"});
        connection.modify((ModifyRequest)modReq);
        entry = connection.lookup(userDn, new String[]{"*", "+"});
        pwdHistAt = entry.get("pwdHistory");
        Assert.assertNotNull((Object)pwdHistAt);
        Assert.assertEquals((long)2L, (long)pwdHistAt.size());
        Thread.sleep(1000L);
        modReq = new ModifyRequestImpl();
        modReq.setName(userDn);
        modReq.addControl((Control)PP_REQ_CTRL);
        modReq.replace("userPassword", new String[]{"abcde"});
        ModifyResponse modResp = connection.modify((ModifyRequest)modReq);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)modResp.getLdapResult().getResultCode());
        entry = connection.lookup(userDn, new String[]{"*", "+"});
        pwdHistAt = entry.get("pwdHistory");
        Assert.assertNotNull((Object)pwdHistAt);
        Assert.assertEquals((long)2L, (long)pwdHistAt.size());
        modResp = connection.modify((ModifyRequest)modReq);
        Assert.assertEquals((Object)ResultCodeEnum.CONSTRAINT_VIOLATION, (Object)modResp.getLdapResult().getResultCode());
        PasswordPolicy respCtrl = this.getPwdRespCtrl((Response)modResp);
        Assert.assertEquals((Object)PasswordPolicyErrorEnum.PASSWORD_IN_HISTORY, (Object)respCtrl.getResponse().getPasswordPolicyError());
    }

    @Test
    public void testPwdLength() throws Exception {
        this.policyConfig.setPwdMinLength(5);
        this.policyConfig.setPwdMaxLength(7);
        this.policyConfig.setPwdCheckQuality(2);
        LdapConnection connection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PasswordPolicyIT.getLdapServer());
        Dn userDn = new Dn(new String[]{"cn=userLen,ou=system"});
        DefaultEntry userEntry = new DefaultEntry(userDn.toString(), new Object[]{"ObjectClass: top", "ObjectClass: person", "cn: userLen", "sn: userLen_sn", "userPassword: 1234"});
        AddRequestImpl addRequest = new AddRequestImpl();
        addRequest.setEntry((Entry)userEntry);
        addRequest.addControl((Control)PP_REQ_CTRL);
        AddResponse addResp = connection.add((AddRequest)addRequest);
        Assert.assertEquals((Object)ResultCodeEnum.CONSTRAINT_VIOLATION, (Object)addResp.getLdapResult().getResultCode());
        PasswordPolicy respCtrl = this.getPwdRespCtrl((Response)addResp);
        Assert.assertNotNull((Object)respCtrl);
        Assert.assertEquals((Object)PasswordPolicyErrorEnum.PASSWORD_TOO_SHORT, (Object)respCtrl.getResponse().getPasswordPolicyError());
        Attribute pwdAt = userEntry.get("userPassword");
        pwdAt.clear();
        pwdAt.add(new String[]{"12345678"});
        addResp = connection.add((AddRequest)addRequest);
        Assert.assertEquals((Object)ResultCodeEnum.CONSTRAINT_VIOLATION, (Object)addResp.getLdapResult().getResultCode());
        respCtrl = this.getPwdRespCtrl((Response)addResp);
        Assert.assertNotNull((Object)respCtrl);
        Assert.assertEquals((Object)PasswordPolicyErrorEnum.INSUFFICIENT_PASSWORD_QUALITY, (Object)respCtrl.getResponse().getPasswordPolicyError());
        pwdAt = userEntry.get("userPassword");
        pwdAt.clear();
        pwdAt.add(new String[]{"123456"});
        addResp = connection.add((AddRequest)addRequest);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)addResp.getLdapResult().getResultCode());
    }

    @Test
    public void testPwdMaxAgeAndGraceAuth() throws Exception {
        this.policyConfig.setPwdMaxAge(5);
        this.policyConfig.setPwdExpireWarning(4);
        this.policyConfig.setPwdGraceAuthNLimit(2);
        LdapConnection connection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PasswordPolicyIT.getLdapServer());
        Dn userDn = new Dn(new String[]{"cn=userMaxAge,ou=system"});
        String password = "12345";
        DefaultEntry userEntry = new DefaultEntry(userDn.toString(), new Object[]{"ObjectClass: top", "ObjectClass: person", "cn: userMaxAge", "sn: userMaxAge_sn", "userPassword: " + password});
        AddRequestImpl addRequest = new AddRequestImpl();
        addRequest.setEntry((Entry)userEntry);
        addRequest.addControl((Control)PP_REQ_CTRL);
        connection.add((AddRequest)addRequest);
        BindRequestImpl bindReq = new BindRequestImpl();
        bindReq.setDn(userDn);
        bindReq.setCredentials(password.getBytes());
        bindReq.addControl((Control)PP_REQ_CTRL);
        LdapNetworkConnection userCon = new LdapNetworkConnection("localhost", ldapServer.getPort());
        userCon.setTimeOut(0L);
        Thread.sleep(1000L);
        BindResponse bindResp = userCon.bind((BindRequest)bindReq);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)bindResp.getLdapResult().getResultCode());
        PasswordPolicy respCtrl = this.getPwdRespCtrl((Response)bindResp);
        Assert.assertNotNull((Object)respCtrl);
        Assert.assertTrue((respCtrl.getResponse().getTimeBeforeExpiration() > 0 ? 1 : 0) != 0);
        Thread.sleep(4000L);
        bindResp = userCon.bind((BindRequest)bindReq);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)bindResp.getLdapResult().getResultCode());
        respCtrl = this.getPwdRespCtrl((Response)bindResp);
        Assert.assertNotNull((Object)respCtrl);
        Assert.assertEquals((long)1L, (long)respCtrl.getResponse().getGraceAuthNsRemaining());
        Thread.sleep(1000L);
        bindResp = userCon.bind((BindRequest)bindReq);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)bindResp.getLdapResult().getResultCode());
        respCtrl = this.getPwdRespCtrl((Response)bindResp);
        Assert.assertEquals((long)0L, (long)respCtrl.getResponse().getGraceAuthNsRemaining());
        bindResp = userCon.bind((BindRequest)bindReq);
        Assert.assertEquals((Object)ResultCodeEnum.INVALID_CREDENTIALS, (Object)bindResp.getLdapResult().getResultCode());
        respCtrl = this.getPwdRespCtrl((Response)bindResp);
        Assert.assertEquals((Object)PasswordPolicyErrorEnum.PASSWORD_EXPIRED, (Object)respCtrl.getResponse().getPasswordPolicyError());
    }

    @Test
    public void testModifyPwdSubentry() throws Exception {
        LdapConnection connection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PasswordPolicyIT.getLdapServer());
        Dn userDn = new Dn(new String[]{"cn=ppolicySubentry,ou=system"});
        String password = "12345";
        DefaultEntry userEntry = new DefaultEntry(userDn.toString(), new Object[]{"ObjectClass: top", "ObjectClass: person", "cn: ppolicySubentry", "sn: ppolicySubentry_sn", "userPassword: " + password, "pwdPolicySubEntry:" + userDn.getName()});
        AddRequestImpl addRequest = new AddRequestImpl();
        addRequest.setEntry((Entry)userEntry);
        addRequest.addControl((Control)PP_REQ_CTRL);
        AddResponse addResp = connection.add((AddRequest)addRequest);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)addResp.getLdapResult().getResultCode());
        userEntry = connection.lookup(userDn, new String[]{"*", "+"});
        Assert.assertEquals((Object)userDn.getName(), (Object)userEntry.get("pwdPolicySubEntry").getString());
        ModifyRequestImpl modReq = new ModifyRequestImpl();
        modReq.setName(userDn);
        String modSubEntryDn = "cn=policy,ou=system";
        modReq.replace("pwdPolicySubEntry", new String[]{modSubEntryDn});
        ModifyResponse modResp = connection.modify((ModifyRequest)modReq);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)modResp.getLdapResult().getResultCode());
        userEntry = connection.lookup(userDn, new String[]{"*", "+"});
        Assert.assertEquals((Object)modSubEntryDn, (Object)userEntry.get("pwdPolicySubEntry").getString());
        connection = new LdapNetworkConnection("localhost", PasswordPolicyIT.getLdapServer().getPort());
        connection.bind(userDn.getName(), password);
        modResp = connection.modify((ModifyRequest)modReq);
        modReq.replace("pwdPolicySubEntry", new String[]{userDn.getName()});
        Assert.assertEquals((Object)ResultCodeEnum.INSUFFICIENT_ACCESS_RIGHTS, (Object)modResp.getLdapResult().getResultCode());
    }

    @Test
    public void testGraceAuth() throws Exception {
        this.policyConfig.setPwdMaxFailure(2);
        this.policyConfig.setPwdLockout(true);
        this.policyConfig.setPwdLockoutDuration(0);
        this.policyConfig.setPwdGraceAuthNLimit(2);
        this.policyConfig.setPwdFailureCountInterval(60);
        this.policyConfig.setPwdMaxAge(1);
        LdapConnection adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PasswordPolicyIT.getLdapServer());
        Dn userDn = new Dn(new String[]{"cn=userGrace,ou=system"});
        DefaultEntry userEntry = new DefaultEntry(userDn.toString(), new Object[]{"ObjectClass: top", "ObjectClass: person", "cn: userGrace", "sn: userGrace_sn", "userPassword: 12345"});
        AddRequestImpl addRequest = new AddRequestImpl();
        addRequest.setEntry((Entry)userEntry);
        addRequest.addControl((Control)PP_REQ_CTRL);
        AddResponse addResp = adminConnection.add((AddRequest)addRequest);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)addResp.getLdapResult().getResultCode());
        PasswordPolicy respCtrl = this.getPwdRespCtrl((Response)addResp);
        Assert.assertNull((Object)respCtrl);
        BindRequestImpl bindReq = new BindRequestImpl();
        bindReq.setDn(userDn);
        bindReq.setCredentials("12345");
        bindReq.addControl((Control)PP_REQ_CTRL);
        LdapNetworkConnection userConnection = new LdapNetworkConnection("localhost", ldapServer.getPort());
        Thread.sleep(2000L);
        BindResponse bindResp = userConnection.bind((BindRequest)bindReq);
        Assert.assertTrue((boolean)userConnection.isAuthenticated());
        PasswordPolicy ppolicy = this.getPwdRespCtrl((Response)bindResp);
        Assert.assertEquals((long)1L, (long)ppolicy.getResponse().getGraceAuthNsRemaining());
        userEntry = adminConnection.lookup(userDn, new String[]{"+"});
        Attribute pwdGraceAuthUseTime = userEntry.get("pwdGraceUseTime");
        Assert.assertNotNull((Object)pwdGraceAuthUseTime);
        Attribute pwdChangedTime = userEntry.get("pwdChangedTime");
        ModifyRequestImpl modReq = new ModifyRequestImpl();
        modReq.setName(userDn);
        modReq.replace("userPassword", new String[]{"secret1"});
        ModifyResponse modResp = userConnection.modify((ModifyRequest)modReq);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)modResp.getLdapResult().getResultCode());
        userEntry = adminConnection.lookup(userDn, new String[]{"+"});
        pwdGraceAuthUseTime = userEntry.get("pwdGraceUseTime");
        Assert.assertNull((Object)pwdGraceAuthUseTime);
        Attribute latestPwdChangedTime = userEntry.get("pwdChangedTime");
        Assert.assertNotSame((Object)pwdChangedTime.getString(), (Object)latestPwdChangedTime.getString());
        userConnection.close();
    }

    @Test
    public void testPwdLockoutWithDuration() throws Exception {
        this.policyConfig.setPwdMaxFailure(2);
        this.policyConfig.setPwdLockout(true);
        this.policyConfig.setPwdLockoutDuration(5);
        this.policyConfig.setPwdGraceAuthNLimit(2);
        this.policyConfig.setPwdFailureCountInterval(0);
        LdapConnection adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PasswordPolicyIT.getLdapServer());
        Dn userDn = new Dn(new String[]{"cn=userLockout,ou=system"});
        DefaultEntry userEntry = new DefaultEntry(userDn.toString(), new Object[]{"ObjectClass: top", "ObjectClass: person", "cn: userLockout", "sn: userLockout_sn", "userPassword: 12345"});
        AddRequestImpl addRequest = new AddRequestImpl();
        addRequest.setEntry((Entry)userEntry);
        addRequest.addControl((Control)PP_REQ_CTRL);
        AddResponse addResp = adminConnection.add((AddRequest)addRequest);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)addResp.getLdapResult().getResultCode());
        PasswordPolicy respCtrl = this.getPwdRespCtrl((Response)addResp);
        Assert.assertNull((Object)respCtrl);
        BindRequestImpl bindReq = new BindRequestImpl();
        bindReq.setDn(userDn);
        bindReq.setCredentials("1234");
        bindReq.addControl((Control)PP_REQ_CTRL);
        LdapNetworkConnection userConnection = new LdapNetworkConnection("localhost", ldapServer.getPort());
        for (int i = 0; i < 4; ++i) {
            userConnection.bind((BindRequest)bindReq);
            Assert.assertFalse((boolean)userConnection.isAuthenticated());
        }
        userEntry = adminConnection.lookup(userDn, new String[]{"+"});
        Attribute pwdAccountLockedTime = userEntry.get("pwdAccountLockedTime");
        Assert.assertNotNull((Object)pwdAccountLockedTime);
        Thread.sleep(10000L);
        bindReq = new BindRequestImpl();
        bindReq.setDn(userDn);
        bindReq.setCredentials("12345");
        bindReq.addControl((Control)PP_REQ_CTRL);
        userConnection.setTimeOut(Long.MAX_VALUE);
        userConnection.bind((BindRequest)bindReq);
        Assert.assertTrue((boolean)userConnection.isAuthenticated());
        userConnection.close();
    }

    private PasswordPolicy getPwdRespCtrl(Response resp) throws Exception {
        Control control = (Control)resp.getControls().get(PP_REQ_CTRL.getOid());
        if (control == null) {
            return null;
        }
        return (PasswordPolicy)((PasswordPolicyDecorator)control).getDecorated();
    }
}

