/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ssl;

import java.security.cert.X509Certificate;
import java.util.Hashtable;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;
import org.apache.directory.junit.tools.MultiThreadedMultiInvoker;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.annotations.SaslMechanism;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.core.security.TlsKeyGenerator;
import org.apache.directory.server.ldap.handlers.bind.cramMD5.CramMd5MechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.digestMD5.DigestMd5MechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.gssapi.GssapiMechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.ntlm.NtlmMechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.plain.PlainMechanismHandler;
import org.apache.directory.server.ldap.handlers.extended.StoredProcedureExtendedOperationHandler;
import org.apache.directory.server.operations.bind.BogusNtlmProvider;
import org.apache.directory.server.ssl.BogusTrustManagerFactory;
import org.apache.directory.server.ssl.SSLSocketFactory;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateDS(allowAnonAccess=true, name="LdapsUpdateCertificateIT-class")
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP"), @CreateTransport(protocol="LDAPS")}, saslHost="localhost", saslMechanisms={@SaslMechanism(name="PLAIN", implClass=PlainMechanismHandler.class), @SaslMechanism(name="CRAM-MD5", implClass=CramMd5MechanismHandler.class), @SaslMechanism(name="DIGEST-MD5", implClass=DigestMd5MechanismHandler.class), @SaslMechanism(name="GSSAPI", implClass=GssapiMechanismHandler.class), @SaslMechanism(name="NTLM", implClass=NtlmMechanismHandler.class), @SaslMechanism(name="GSS-SPNEGO", implClass=NtlmMechanismHandler.class)}, extendedOpHandlers={StoredProcedureExtendedOperationHandler.class}, ntlmProvider=BogusNtlmProvider.class)
public class LdapsUpdateCertificateIT
extends AbstractLdapTestUnit {
    @Rule
    public MultiThreadedMultiInvoker i = new MultiThreadedMultiInvoker(false);

    public DirContext getSecureConnection() throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://localhost:" + LdapsUpdateCertificateIT.getLdapServer().getPortSSL() + "/ou=system");
        env.put("java.naming.ldap.factory.socket", SSLSocketFactory.class.getName());
        env.put("java.naming.security.principal", "uid=admin,ou=system");
        env.put("java.naming.security.credentials", "secret");
        env.put("java.naming.security.authentication", "simple");
        return new InitialDirContext(env);
    }

    @Test
    public void testUpdateCertificate() throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldaps://localhost:" + LdapsUpdateCertificateIT.getLdapServer().getPortSSL());
        env.put("java.naming.ldap.factory.socket", SSLSocketFactory.class.getName());
        env.put("java.naming.security.principal", "uid=admin,ou=system");
        env.put("java.naming.security.credentials", "secret");
        env.put("java.naming.security.authentication", "simple");
        InitialDirContext ctx = new InitialDirContext(env);
        String newIssuerDN = "cn=new_issuer_dn";
        String newSubjectDN = "cn=new_subject_dn";
        Entry entry = LdapsUpdateCertificateIT.getLdapServer().getDirectoryService().getAdminSession().lookup(new Dn(new String[]{"uid=admin,ou=system"}), new String[0]);
        TlsKeyGenerator.addKeyPair((Entry)entry, (String)newIssuerDN, (String)newSubjectDN, (String)"RSA");
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, new BasicAttribute("privateKey", entry.get("privateKey").getBytes())), new ModificationItem(2, new BasicAttribute("publicKey", entry.get("publicKey").getBytes())), new ModificationItem(2, new BasicAttribute("userCertificate", entry.get("userCertificate").getBytes()))};
        ctx.modifyAttributes("uid=admin,ou=system", mods);
        ctx.close();
        LdapsUpdateCertificateIT.getLdapServer().reloadSslContext();
        ctx = new InitialDirContext(env);
        X509Certificate[] lastReceivedServerCertificates = BogusTrustManagerFactory.lastReceivedServerCertificates;
        Assert.assertNotNull((Object)lastReceivedServerCertificates);
        Assert.assertEquals((long)1L, (long)lastReceivedServerCertificates.length);
        String issuerDN = lastReceivedServerCertificates[0].getIssuerDN().getName();
        String subjectDN = lastReceivedServerCertificates[0].getSubjectDN().getName();
        Assert.assertEquals((String)"Expected the new certificate with the new issuer", (Object)Strings.toLowerCase((String)newIssuerDN), (Object)Strings.toLowerCase((String)issuerDN));
        Assert.assertEquals((String)"Expected the new certificate with the new subject", (Object)Strings.toLowerCase((String)newSubjectDN), (Object)Strings.toLowerCase((String)subjectDN));
    }
}

