/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.search;

import java.util.HashSet;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.directory.junit.tools.MultiThreadedMultiInvoker;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.annotations.SaslMechanism;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.integ.ServerIntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.handlers.extended.StartTlsHandler;
import org.apache.directory.server.ldap.handlers.extended.StoredProcedureExtendedOperationHandler;
import org.apache.directory.server.ldap.handlers.sasl.cramMD5.CramMd5MechanismHandler;
import org.apache.directory.server.ldap.handlers.sasl.digestMD5.DigestMd5MechanismHandler;
import org.apache.directory.server.ldap.handlers.sasl.gssapi.GssapiMechanismHandler;
import org.apache.directory.server.ldap.handlers.sasl.ntlm.NtlmMechanismHandler;
import org.apache.directory.server.ldap.handlers.sasl.plain.PlainMechanismHandler;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@ApplyLdifs(value={"dn: ou=test,ou=system", "objectClass: top", "objectClass: organizationalUnit", "ou: test", "dn: uid=test1,ou=test,ou=system", "objectClass: top", "objectClass: account", "uid: test1", "ou: test1", "dn: uid=test2,ou=test,ou=system", "objectClass: top", "objectClass: account", "uid: test2", "ou: test2", "dn: uid=testNoOU,ou=test,ou=system", "objectClass: top", "objectClass: account", "uid: testNoOU", "dn: ou=actors,ou=system", "objectClass: top", "objectClass: organizationalUnit", "ou: actors\n", "dn: uid=jblack,ou=actors,ou=system", "objectClass: top", "objectClass: person", "objectClass: organizationalPerson", "objectClass: uidObject", "uid: jblack", "ou: comedy", "ou: adventure", "cn: Jack Black", "sn: Black", "dn: uid=bpitt,ou=actors,ou=system", "objectClass: top", "objectClass: person", "objectClass: organizationalPerson", "objectClass: uidObject", "uid: bpitt", "ou: drama", "ou: adventure", "cn: Brad Pitt", "sn: Pitt", "dn: uid=gcloony,ou=actors,ou=system", "objectClass: top", "objectClass: person", "objectClass: organizationalPerson", "objectClass: uidObject", "uid: gcloony", "ou: drama", "cn: Goerge Cloony", "sn: Cloony", "dn: uid=jnewbie,ou=actors,ou=system", "objectClass: top", "objectClass: person", "objectClass: organizationalPerson", "objectClass: uidObject", "uid: jnewbie", "cn: Joe Newbie", "sn: Newbie"})
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")}, saslMechanisms={@SaslMechanism(name="PLAIN", implClass=PlainMechanismHandler.class), @SaslMechanism(name="CRAM-MD5", implClass=CramMd5MechanismHandler.class), @SaslMechanism(name="DIGEST-MD5", implClass=DigestMd5MechanismHandler.class), @SaslMechanism(name="GSSAPI", implClass=GssapiMechanismHandler.class), @SaslMechanism(name="NTLM", implClass=NtlmMechanismHandler.class), @SaslMechanism(name="GSS-SPNEGO", implClass=NtlmMechanismHandler.class)}, extendedOpHandlers={StartTlsHandler.class, StoredProcedureExtendedOperationHandler.class})
public class IndexedNegationSearchIT
extends AbstractLdapTestUnit {
    @Rule
    public MultiThreadedMultiInvoker i = new MultiThreadedMultiInvoker(false);

    @Test
    public void testSearchNotOUIndexed() throws Exception {
        Set<SearchResult> results = this.getResults("(!(ou=test1))");
        Assert.assertFalse((boolean)this.contains("uid=test1,ou=test,ou=system", results));
        Assert.assertTrue((boolean)this.contains("uid=test2,ou=test,ou=system", results));
        Assert.assertTrue((boolean)this.contains("uid=testNoOU,ou=test,ou=system", results));
    }

    @Test
    public void testSearchNotDramaIndexed() throws Exception {
        Set<SearchResult> results = this.getActorResults("(!(ou=drama))");
        Assert.assertTrue((boolean)this.contains("uid=jblack,ou=actors,ou=system", results));
        Assert.assertTrue((boolean)this.contains("uid=jnewbie,ou=actors,ou=system", results));
        Assert.assertEquals((long)2L, (long)results.size());
    }

    boolean contains(String dn, Set<SearchResult> results) {
        for (SearchResult result : results) {
            if (!result.getNameInNamespace().equals(dn)) continue;
            return true;
        }
        return false;
    }

    @Test
    public void testSearchNotDramaNotNewbieIndexed() throws Exception {
        Set<SearchResult> results = this.getActorResults("(& (!(uid=jnewbie)) (!(ou=drama)) )");
        Assert.assertTrue((boolean)this.contains("uid=jblack,ou=actors,ou=system", results));
        Assert.assertFalse((boolean)this.contains("uid=jnewbie,ou=actors,ou=system", results));
        Assert.assertEquals((long)1L, (long)results.size());
    }

    Set<SearchResult> getActorResults(String filter) throws Exception {
        LdapContext ctx = ServerIntegrationUtils.getWiredContext((LdapServer)IndexedNegationSearchIT.getLdapServer());
        HashSet<SearchResult> results = new HashSet<SearchResult>();
        SearchControls controls = new SearchControls();
        controls.setSearchScope(1);
        NamingEnumeration<SearchResult> namingEnumeration = ctx.search("ou=actors,ou=system", filter, controls);
        while (namingEnumeration.hasMore()) {
            results.add(namingEnumeration.next());
        }
        namingEnumeration.close();
        ctx.close();
        return results;
    }

    Set<SearchResult> getResults(String filter) throws Exception {
        LdapContext ctx = ServerIntegrationUtils.getWiredContext((LdapServer)IndexedNegationSearchIT.getLdapServer());
        HashSet<SearchResult> results = new HashSet<SearchResult>();
        SearchControls controls = new SearchControls();
        controls.setSearchScope(2);
        NamingEnumeration<SearchResult> namingEnumeration = ctx.search("ou=system", filter, controls);
        while (namingEnumeration.hasMore()) {
            results.add(namingEnumeration.next());
        }
        namingEnumeration.close();
        ctx.close();
        return results;
    }
}

