/*
 * Decompiled with CFR 0.152.
 */
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.directory.api.ldap.model.cursor.EntryCursor;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;

public class MultiThreadedReadWriteTest {
    private volatile boolean stop = false;
    private Runnable reader = new Runnable(){

        @Override
        public void run() {
            try {
                LdapNetworkConnection connection = MultiThreadedReadWriteTest.this.getConnection();
                while (!MultiThreadedReadWriteTest.this.stop) {
                    MultiThreadedReadWriteTest.this.read(connection);
                }
                connection.close();
            }
            catch (Exception e) {
                System.out.println("Reader " + Thread.currentThread().getId() + " failed");
                e.printStackTrace();
                System.exit(0);
            }
        }
    };
    private Runnable writer = new Runnable(){

        @Override
        public void run() {
            try {
                MultiThreadedReadWriteTest.this.sync();
            }
            catch (Exception e) {
                System.out.println("Sync failed");
                e.printStackTrace();
                System.exit(0);
            }
        }
    };

    private void read(LdapNetworkConnection connection) throws Exception {
        EntryCursor cursor = connection.search("ou=users,ou=system", "(objectClass=*)", SearchScope.ONELEVEL, new String[]{"*"});
        int count = 0;
        while (cursor.next()) {
            cursor.get();
            ++count;
        }
        System.out.println("Read " + count + " entries");
    }

    private void sync() throws Exception {
        String userDn;
        String uid;
        int i;
        LdapNetworkConnection connection = this.getConnection();
        String dn = "uid={uid},ou=users,ou=system";
        String personTemplate = "objectClass: top\nobjectClass: person\nobjectClass: organizationalPerson\nobjectClass: inetOrgPerson\ngivenName: {uid}_{uid}\nsn: {uid}_sn\ncn: {uid}_cn\nuid: {uid}\n\n";
        int total = 2500;
        System.out.println("writing ");
        for (i = 0; i < total; ++i) {
            uid = "user" + i;
            userDn = dn.replace("{uid}", uid);
            String user = personTemplate.replace("{uid}", uid);
            DefaultEntry entry = new DefaultEntry(userDn, new Object[]{user});
            connection.add((Entry)entry);
        }
        System.out.println("deleting ");
        for (i = 0; i < total; ++i) {
            uid = "user" + i;
            userDn = dn.replace("{uid}", uid);
            connection.delete(userDn);
        }
        connection.close();
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        t.printStackTrace(pw);
        pw.flush();
        sw.flush();
        return sw.toString();
    }

    private LdapNetworkConnection getConnection() throws Exception {
        LdapNetworkConnection connection = new LdapNetworkConnection("localhost", 10389);
        connection.bind("uid=admin,ou=system", "secret");
        connection.setTimeOut(Long.MAX_VALUE);
        return connection;
    }

    public static void main(String[] args) throws Exception {
        MultiThreadedReadWriteTest mtrwt = new MultiThreadedReadWriteTest();
        Thread writer = new Thread(mtrwt.writer);
        writer.start();
        for (int i = 0; i < 5; ++i) {
            Thread reader = new Thread(mtrwt.reader);
            reader.start();
        }
        System.out.println("waiting for writer to stop");
        writer.join();
        mtrwt.stop = true;
    }
}

