/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.extended;

import org.apache.directory.api.ldap.extras.extended.whoAmI.WhoAmIRequestImpl;
import org.apache.directory.api.ldap.extras.extended.whoAmI.WhoAmIResponse;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.hash.Sha512PasswordHashingInterceptor;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.core.integ.IntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.handlers.extended.WhoAmIHandler;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")}, extendedOpHandlers={WhoAmIHandler.class}, allowAnonymousAccess=true)
@CreateDS(enableChangeLog=false, name="RbacCreateSessionTest", additionalInterceptors={Sha512PasswordHashingInterceptor.class})
public class WhoAmIIT
extends AbstractLdapTestUnit {
    @Test
    public void testRbacCreateSessionExtendedOperation() throws Exception {
        LdapConnection adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)WhoAmIIT.getLdapServer());
        adminConnection.setTimeOut(0L);
        WhoAmIRequestImpl whoAmIRequest = new WhoAmIRequestImpl();
        WhoAmIResponse whoAmIResponse = (WhoAmIResponse)adminConnection.extended((ExtendedRequest)whoAmIRequest);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)whoAmIResponse.getLdapResult().getResultCode());
        Assert.assertTrue((boolean)whoAmIResponse.isDnAuthzId());
        Assert.assertEquals((Object)"uid=admin,ou=system", (Object)whoAmIResponse.getDn().toString());
        adminConnection.close();
    }
}

