/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.modifydn;

import javax.naming.NamingEnumeration;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.directory.api.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.integ.ServerIntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
@ApplyLdifs(value={"dn: uid=akarasulu,ou=users,ou=system", "objectClass: uidObject", "objectClass: person", "objectClass: top", "uid: akarasulu", "cn: Alex Karasulu", "sn: karasulu", "dn: ou=NewSuperior,ou=system", "objectClass: organizationalUnit", "objectClass: top", "ou: NewSuperior", "dn: ou=parent,ou=system", "changetype: add", "objectClass: organizationalUnit", "objectClass: top", "ou: parent", "dn: ou=child,ou=parent,ou=system", "changetype: add", "objectClass: organizationalUnit", "objectClass: top", "ou: child"})
public class MoveIT
extends AbstractLdapTestUnit {
    private static final String DN = "uid=akarasulu,ou=users,ou=system";
    private static final String NEW_DN = "uid=akarasulu,ou=NewSuperior,ou=system";
    private static final String NEW_DN2 = "uid=elecharny,ou=NewSuperior,ou=system";

    @Test
    public void testMoveNoRdnChange() throws Exception {
        LdapContext ctx = ServerIntegrationUtils.getWiredContext((LdapServer)MoveIT.getLdapServer());
        ctx.rename(DN, NEW_DN);
        SearchControls controls = new SearchControls();
        controls.setSearchScope(0);
        NamingEnumeration<SearchResult> results = ctx.search(NEW_DN, "(objectClass=*)", controls);
        Assert.assertNotNull(results);
        Assert.assertTrue((String)"Could not find entry after move.", (boolean)results.hasMore());
        SearchResult result = results.next();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)NEW_DN, (Object)result.getNameInNamespace());
        results.close();
        ctx.close();
    }

    @Test
    public void testMoveAndRdnChange() throws Exception {
        LdapContext ctx = ServerIntegrationUtils.getWiredContext((LdapServer)MoveIT.getLdapServer());
        ctx.rename(DN, NEW_DN2);
        SearchControls controls = new SearchControls();
        controls.setSearchScope(0);
        NamingEnumeration<SearchResult> results = ctx.search(NEW_DN2, "(objectClass=*)", controls);
        Assert.assertNotNull(results);
        Assert.assertTrue((String)"Could not find entry after move.", (boolean)results.hasMore());
        SearchResult result = results.next();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)NEW_DN2, (Object)result.getNameInNamespace());
        results.close();
        ctx.close();
    }

    @Test
    public void testIllegalMove() throws Exception {
        LdapConnection con = ServerIntegrationUtils.getAdminConnection((LdapServer)MoveIT.getLdapServer());
        try {
            con.move("ou=parent,ou=system", "ou=child,ou=parent,ou=system");
            Assert.fail();
        }
        catch (LdapUnwillingToPerformException lutpe) {
            Assert.assertTrue((boolean)true);
        }
        con.close();
    }

    @Test
    public void testIllegalMoveToSameDN() throws Exception {
        LdapConnection con = ServerIntegrationUtils.getAdminConnection((LdapServer)MoveIT.getLdapServer());
        try {
            con.move("ou=parent,ou=system", "ou=parent,ou=system");
            Assert.fail();
        }
        catch (LdapUnwillingToPerformException lutpe) {
            Assert.assertTrue((boolean)true);
        }
        con.close();
    }
}

