/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.search;

import java.util.Random;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.EntryCursor;
import org.apache.directory.api.ldap.model.cursor.SearchCursor;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchRequestImpl;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.ldap.client.api.EntryCursorImpl;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ContextEntry;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreateIndex;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateDS(name="AddPerfDS", partitions={@CreatePartition(name="example", suffix="dc=example,dc=com", contextEntry=@ContextEntry(entryLdif="dn: dc=example,dc=com\ndc: example\nobjectClass: top\nobjectClass: domain\n\n"), indexes={@CreateIndex(attribute="objectClass"), @CreateIndex(attribute="sn"), @CreateIndex(attribute="cn"), @CreateIndex(attribute="displayName")})}, enableChangeLog=false)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
public class SearchPerfIT
extends AbstractLdapTestUnit {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSearchRequestObjectScopePerf() throws Exception {
        LdapNetworkConnection connection = new LdapNetworkConnection("localhost", SearchPerfIT.getLdapServer().getPort());
        long deltaSearch = 0L;
        long deltaGet = 0L;
        long deltaClose = 0L;
        try {
            connection.bind("uid=admin,ou=system", "secret");
            EntryCursor cursor = connection.search("uid=admin,ou=system", "(ObjectClass=*)", SearchScope.OBJECT, new String[]{"*"});
            int i = 0;
            while (cursor.next()) {
                cursor.get();
                ++i;
            }
            cursor.close();
            Assert.assertEquals((long)1L, (long)i);
            for (int j = 0; j < 10000; ++j) {
                cursor = connection.search("uid=admin,ou=system", "(ObjectClass=*)", SearchScope.OBJECT, new String[]{"*"});
                while (cursor.next()) {
                }
                cursor.close();
            }
            Dn dn = new Dn(SearchPerfIT.getService().getSchemaManager(), new String[]{"uid=admin,ou=system"});
            SearchRequestImpl searchRequest = new SearchRequestImpl();
            searchRequest.setBase(dn);
            searchRequest.setFilter("(ObjectClass=*)");
            searchRequest.setScope(SearchScope.OBJECT);
            searchRequest.addAttributes(new String[]{"*"});
            searchRequest.setDerefAliases(AliasDerefMode.DEREF_ALWAYS);
            long t0 = System.currentTimeMillis();
            long t00 = 0L;
            long tt0 = System.currentTimeMillis();
            int nbIterations = 200000;
            int count = 0;
            for (int j = 0; j < nbIterations; ++j) {
                if (j % 10000 == 0) {
                    long tt1 = System.currentTimeMillis();
                    System.out.println(j + ", " + (tt1 - tt0));
                    tt0 = tt1;
                }
                if (j == 50000) {
                    t00 = System.currentTimeMillis();
                }
                long dt0 = System.nanoTime();
                cursor = new EntryCursorImpl(connection.search((SearchRequest)searchRequest));
                long dt1 = System.nanoTime();
                deltaSearch += Math.abs(dt1 - dt0);
                while (cursor.next()) {
                    long dt2 = System.nanoTime();
                    cursor.get();
                    ++count;
                    long dt3 = System.nanoTime();
                    deltaGet += Math.abs(dt3 - dt2);
                }
                long dt4 = System.nanoTime();
                cursor.close();
                long dt5 = System.nanoTime();
                deltaClose += Math.abs(dt5 - dt4);
            }
            long t1 = System.currentTimeMillis();
            Long deltaWarmed = t1 - t00;
            System.out.println("OBJECT level - Delta : " + deltaWarmed + "( " + (long)((nbIterations - 50000) * 1000) / deltaWarmed + " per s ) /" + (t1 - t0) + ", count : " + count);
            System.out.println("DeltaSearch : " + deltaSearch / (long)nbIterations);
            System.out.println("DeltaGet : " + deltaGet / (long)nbIterations);
            System.out.println("DeltaClose : " + deltaClose / (long)nbIterations);
        }
        catch (LdapException e) {
            e.printStackTrace();
            Assert.fail((String)"Should not have caught exception.");
        }
        finally {
            connection.unBind();
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSearchRequestOneLevelScopePerf() throws Exception {
        LdapNetworkConnection connection = new LdapNetworkConnection("localhost", SearchPerfIT.getLdapServer().getPort());
        try {
            connection.bind("uid=admin,ou=system", "secret");
            EntryCursor cursor = connection.search("ou=system", "(ObjectClass=*)", SearchScope.ONELEVEL, new String[]{"*"});
            int i = 0;
            while (cursor.next()) {
                cursor.get();
                ++i;
            }
            cursor.close();
            Assert.assertEquals((long)5L, (long)i);
            for (int j = 0; j < 10000; ++j) {
                cursor = connection.search("ou=system", "(ObjectClass=*)", SearchScope.ONELEVEL, new String[]{"*"});
                while (cursor.next()) {
                    cursor.get();
                }
                cursor.close();
            }
            Dn dn = new Dn(SearchPerfIT.getService().getSchemaManager(), new String[]{"uid=admin,ou=system"});
            SearchRequestImpl searchRequest = new SearchRequestImpl();
            searchRequest.setBase(dn);
            searchRequest.setFilter("(ObjectClass=*)");
            searchRequest.setScope(SearchScope.ONELEVEL);
            searchRequest.addAttributes(new String[]{"*"});
            searchRequest.setDerefAliases(AliasDerefMode.DEREF_ALWAYS);
            long t0 = System.currentTimeMillis();
            long t00 = 0L;
            long tt0 = System.currentTimeMillis();
            int nbIterations = 200000;
            int count = 0;
            for (int j = 0; j < nbIterations; ++j) {
                if (j % 10000 == 0) {
                    long tt1 = System.currentTimeMillis();
                    System.out.println(j + ", " + (tt1 - tt0));
                    tt0 = tt1;
                }
                if (j == 50000) {
                    t00 = System.currentTimeMillis();
                }
                cursor = connection.search("ou=system", "(ObjectClass=*)", SearchScope.ONELEVEL, new String[]{"*"});
                while (cursor.next()) {
                    ++count;
                    cursor.get();
                }
                cursor.close();
            }
            long t1 = System.currentTimeMillis();
            Long deltaWarmed = t1 - t00;
            System.out.println("ONE level - Delta : " + deltaWarmed + "( " + (long)((nbIterations - 50000) * 1000) / deltaWarmed * 5L + " per s ) /" + (t1 - t0) + ", count : " + count);
        }
        catch (LdapException e) {
            e.printStackTrace();
            Assert.fail((String)"Should not have caught exception.");
        }
        finally {
            connection.unBind();
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSearchRequestSubtreeLevelScopePerf() throws Exception {
        LdapNetworkConnection connection = new LdapNetworkConnection("localhost", SearchPerfIT.getLdapServer().getPort());
        connection.setTimeOut(0L);
        try {
            connection.bind("uid=admin,ou=system", "secret");
            EntryCursor cursor = connection.search("ou=system", "(ObjectClass=*)", SearchScope.SUBTREE, new String[]{"*"});
            int i = 0;
            while (cursor.next()) {
                cursor.get();
                ++i;
            }
            cursor.close();
            Assert.assertEquals((long)10L, (long)i);
            for (int j = 0; j < 10000; ++j) {
                cursor = connection.search("ou=system", "(ObjectClass=*)", SearchScope.SUBTREE, new String[]{"*"});
                while (cursor.next()) {
                    cursor.get();
                }
                cursor.close();
            }
            Dn dn = new Dn(SearchPerfIT.getService().getSchemaManager(), new String[]{"uid=admin,ou=system"});
            SearchRequestImpl searchRequest = new SearchRequestImpl();
            searchRequest.setBase(dn);
            searchRequest.setFilter("(ObjectClass=*)");
            searchRequest.setScope(SearchScope.SUBTREE);
            searchRequest.addAttributes(new String[]{"*"});
            searchRequest.setDerefAliases(AliasDerefMode.DEREF_ALWAYS);
            long t0 = System.currentTimeMillis();
            long t00 = 0L;
            long tt0 = System.currentTimeMillis();
            int nbIterations = 200000;
            int count = 0;
            for (int j = 0; j < nbIterations; ++j) {
                if (j % 10000 == 0) {
                    long tt1 = System.currentTimeMillis();
                    System.out.println(j + ", " + (tt1 - tt0));
                    tt0 = tt1;
                }
                if (j == 50000) {
                    t00 = System.currentTimeMillis();
                }
                cursor = connection.search("ou=system", "(ObjectClass=*)", SearchScope.SUBTREE, new String[]{"*"});
                while (cursor.next()) {
                    ++count;
                    cursor.get();
                }
                cursor.close();
            }
            long t1 = System.currentTimeMillis();
            Long deltaWarmed = t1 - t00;
            System.out.println("SUB level - Delta : " + deltaWarmed + "( " + (long)((nbIterations - 50000) * 1000) / deltaWarmed * 10L + " per s ) /" + (t1 - t0) + ", count : " + count);
        }
        catch (LdapException e) {
            e.printStackTrace();
            Assert.fail((String)"Should not have caught exception.");
        }
        finally {
            connection.unBind();
            connection.close();
        }
    }

    @Test
    public void testSearch100kUsers() throws LdapException, CursorException, InterruptedException {
        LdapNetworkConnection connection = new LdapNetworkConnection("localhost", SearchPerfIT.getLdapServer().getPort());
        connection.bind("uid=admin,ou=system", "secret");
        DefaultEntry rootPeople = new DefaultEntry("ou=People,dc=example,dc=com", new Object[]{"objectClass: top", "objectClass: organizationalUnit", "ou: People"});
        connection.add((Entry)rootPeople);
        long tadd0 = System.currentTimeMillis();
        for (int i = 0; i < 100000; ++i) {
            DefaultEntry user = new DefaultEntry("uid=user." + i + ",ou=People,dc=example,dc=com", new Object[]{"objectClass: top", "objectClass: person", "objectClass: organizationalPerson", "objectClass: inetOrgPerson", "givenName: Aaccf", "sn: Amar", "cn", "user" + i, "initials: AA", "uid", "user." + i, "mail: user.1@cs.hacettepe.edu.tr", "userPassword: password", "telephoneNumber: 314-796-3178", "homePhone: 514-847-0518", "pager: 784-600-5445", "mobile: 801-755-4931", "street: 00599 First Street", "l: Augusta", "st: MN", "postalCode: 30667", "postalAddress: Aaccf Amar$00599 First Street$Augusta, MN  30667", "description: This is the description for Aaccf Amar."});
            connection.add((Entry)user);
            if (i % 100 != 0) continue;
            System.out.println("Injected " + i);
        }
        long tadd1 = System.currentTimeMillis();
        System.out.println("Time to inject 100k entries : " + (tadd1 - tadd0) / 1000L + "s");
        SearchRequestImpl searchRequest = new SearchRequestImpl();
        searchRequest.setBase(new Dn(new String[]{"dc=example,dc=com"}));
        searchRequest.setScope(SearchScope.SUBTREE);
        searchRequest.addAttributes(new String[]{"*"});
        searchRequest.setDerefAliases(AliasDerefMode.DEREF_ALWAYS);
        long t0 = System.currentTimeMillis();
        long t00 = 0L;
        long tt0 = System.currentTimeMillis();
        int nbIterations = 200000;
        int count = 0;
        Random random = new Random();
        for (int j = 0; j < nbIterations; ++j) {
            if (j % 10000 == 0) {
                long tt1 = System.currentTimeMillis();
                System.out.println(j + ", " + (tt1 - tt0));
                tt0 = tt1;
            }
            if (j == 50000) {
                t00 = System.currentTimeMillis();
            }
            searchRequest.setFilter("(cn=user" + random.nextInt(100000) + ")");
            SearchCursor cursor = connection.search((SearchRequest)searchRequest);
            while (cursor.next()) {
                ++count;
                cursor.getEntry();
            }
            cursor.close();
        }
        long t1 = System.currentTimeMillis();
        Long deltaWarmed = t1 - t00;
        System.out.println("Delta : " + deltaWarmed + "( " + (long)((nbIterations - 50000) * 1000) / deltaWarmed + " per s ) /" + (t1 - t0) + ", count : " + count);
    }
}

