/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.search;

import java.util.ArrayList;
import org.apache.directory.api.ldap.model.constants.SchemaConstants;
import org.apache.directory.api.ldap.model.cursor.SearchCursor;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.PresenceNode;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchRequestImpl;
import org.apache.directory.api.ldap.model.message.SearchResultDone;
import org.apache.directory.api.ldap.model.message.SearchResultEntry;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.message.controls.SortKey;
import org.apache.directory.api.ldap.model.message.controls.SortRequest;
import org.apache.directory.api.ldap.model.message.controls.SortRequestControlImpl;
import org.apache.directory.api.ldap.model.message.controls.SortResponse;
import org.apache.directory.api.ldap.model.message.controls.SortResultCode;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
@ApplyLdifFiles(value={"sortedsearch-test-data.ldif"})
public class SortedSearchIT
extends AbstractLdapTestUnit {
    private Dn baseDn;
    private ExprNode filter;
    private static LdapConnection con;
    private SearchRequest req;
    private SortKey sk;
    private SortRequest ctrl;

    @Before
    public void createConnection() throws Exception {
        if (con == null) {
            con = new LdapNetworkConnection("localhost", SortedSearchIT.getLdapServer().getPort());
            con.bind("uid=admin,ou=system", "secret");
            con.setTimeOut(Long.MAX_VALUE);
        }
        this.baseDn = new Dn(new String[]{"ou=parent,ou=system"});
        this.filter = new PresenceNode("objectClass");
        this.req = new SearchRequestImpl();
        this.req.setBase(this.baseDn);
        this.req.setFilter(this.filter);
        this.req.setScope(SearchScope.SUBTREE);
        this.req.addAttributes(SchemaConstants.ALL_USER_ATTRIBUTES_ARRAY);
        this.req.addAttributes(new String[]{"entryDN"});
        this.sk = new SortKey("entryDn");
        this.ctrl = new SortRequestControlImpl();
        this.ctrl.addSortKey(this.sk);
        this.req.addControl((Control)this.ctrl);
    }

    @AfterClass
    public static void closeConnection() throws Exception {
        con.close();
    }

    @Test
    public void testWithInvalidAttributeAndCriticality() throws Exception {
        this.sk.setAttributeTypeDesc("Non-existing-At");
        this.ctrl.setCritical(true);
        SearchCursor cursor = con.search(this.req);
        Assert.assertFalse((boolean)cursor.next());
        SearchResultDone sd = cursor.getSearchResultDone();
        cursor.close();
        SortResponse resp = (SortResponse)sd.getControl("1.2.840.113556.1.4.474");
        Assert.assertNotNull((Object)resp);
        Assert.assertEquals((Object)SortResultCode.NOSUCHATTRIBUTE, (Object)resp.getSortResult());
        Assert.assertEquals((Object)this.sk.getAttributeTypeDesc(), (Object)resp.getAttributeName());
        Assert.assertEquals((Object)ResultCodeEnum.UNAVAILABLE_CRITICAL_EXTENSION, (Object)sd.getLdapResult().getResultCode());
    }

    @Test
    public void testWithInvalidAttributeAndNoCriticality() throws Exception {
        this.sk.setAttributeTypeDesc("Non-existing-At");
        this.ctrl.setCritical(false);
        SearchCursor cursor = con.search(this.req);
        int count = 0;
        while (cursor.next()) {
            cursor.get();
            ++count;
        }
        cursor.close();
        Assert.assertEquals((long)14L, (long)count);
        SearchResultDone sd = cursor.getSearchResultDone();
        SortResponse resp = (SortResponse)sd.getControl("1.2.840.113556.1.4.474");
        Assert.assertNotNull((Object)resp);
        Assert.assertEquals((Object)SortResultCode.NOSUCHATTRIBUTE, (Object)resp.getSortResult());
        Assert.assertEquals((Object)this.sk.getAttributeTypeDesc(), (Object)resp.getAttributeName());
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)sd.getLdapResult().getResultCode());
    }

    @Test
    public void testWithInvalidFilter() throws Exception {
        this.req.setFilter((ExprNode)new PresenceNode("mail"));
        SearchCursor cursor = con.search(this.req);
        Assert.assertFalse((boolean)cursor.next());
        cursor.close();
        SearchResultDone sd = cursor.getSearchResultDone();
        SortResponse resp = (SortResponse)sd.getControl("1.2.840.113556.1.4.474");
        Assert.assertNull((Object)resp);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)sd.getLdapResult().getResultCode());
    }

    @Test
    public void testSortBySn() throws Exception {
        Entry entry;
        this.sk.setAttributeTypeDesc("sn");
        SearchCursor cursor = con.search(this.req);
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add("uid=person1,ou=parent,ou=system");
        expectedOrder.add("uid=person2,ou=parent,ou=system");
        expectedOrder.add("uid=person3,ou=parent,ou=system");
        expectedOrder.add("uid=user0,ou=parent,ou=system");
        expectedOrder.add("uid=user1,ou=parent,ou=system");
        expectedOrder.add("uid=user2,ou=children,ou=parent,ou=system");
        expectedOrder.add("uid=user3,ou=children,ou=parent,ou=system");
        expectedOrder.add("uid=user4,ou=grandchildren,ou=children,ou=parent,ou=system");
        expectedOrder.add("uid=user5,ou=grandchildren,ou=children,ou=parent,ou=system");
        expectedOrder.add("uid=user6,ou=parent,ou=system");
        expectedOrder.add("uid=user7,ou=parent,ou=system");
        int expectedCount = expectedOrder.size();
        ArrayList<String> actualOrder = new ArrayList<String>();
        while (cursor.next()) {
            SearchResultEntry se = (SearchResultEntry)cursor.get();
            entry = se.getEntry();
            actualOrder.add(entry.getDn().getName());
        }
        cursor.close();
        actualOrder.remove(actualOrder.size() - 1);
        actualOrder.remove(actualOrder.size() - 1);
        actualOrder.remove(actualOrder.size() - 1);
        Assert.assertEquals((long)expectedCount, (long)actualOrder.size());
        for (int i = 0; i < expectedOrder.size(); ++i) {
            Assert.assertEquals(expectedOrder.get(i), actualOrder.get(i));
        }
        actualOrder.clear();
        this.sk.setReverseOrder(true);
        cursor = con.search(this.req);
        while (cursor.next()) {
            SearchResultEntry se = (SearchResultEntry)cursor.get();
            entry = se.getEntry();
            actualOrder.add(entry.getDn().getName());
        }
        cursor.close();
        actualOrder.remove(0);
        actualOrder.remove(0);
        actualOrder.remove(0);
        Assert.assertEquals((long)expectedCount, (long)actualOrder.size());
        --expectedCount;
        for (int i = expectedOrder.size() - 1; i >= 0; --i) {
            Assert.assertEquals(expectedOrder.get(i), actualOrder.get(expectedCount - i));
        }
    }

    @Test
    public void testSortByMultiValuedAttribute() throws Exception {
        Entry entry;
        this.sk.setAttributeTypeDesc("cn");
        SearchCursor cursor = con.search(this.req);
        ArrayList<String> expectedOrder = new ArrayList<String>();
        expectedOrder.add("uid=user6,ou=parent,ou=system");
        expectedOrder.add("uid=user0,ou=parent,ou=system");
        expectedOrder.add("uid=user1,ou=parent,ou=system");
        expectedOrder.add("uid=person3,ou=parent,ou=system");
        expectedOrder.add("uid=user2,ou=children,ou=parent,ou=system");
        expectedOrder.add("uid=user3,ou=children,ou=parent,ou=system");
        expectedOrder.add("uid=user4,ou=grandchildren,ou=children,ou=parent,ou=system");
        expectedOrder.add("uid=user5,ou=grandchildren,ou=children,ou=parent,ou=system");
        expectedOrder.add("uid=user7,ou=parent,ou=system");
        expectedOrder.add("uid=person1,ou=parent,ou=system");
        expectedOrder.add("uid=person2,ou=parent,ou=system");
        int expectedCount = expectedOrder.size();
        ArrayList<String> actualOrder = new ArrayList<String>();
        while (cursor.next()) {
            SearchResultEntry se = (SearchResultEntry)cursor.get();
            entry = se.getEntry();
            actualOrder.add(entry.getDn().getName());
        }
        cursor.close();
        actualOrder.remove(actualOrder.size() - 1);
        actualOrder.remove(actualOrder.size() - 1);
        actualOrder.remove(actualOrder.size() - 1);
        Assert.assertEquals((long)expectedCount, (long)actualOrder.size());
        for (int i = 0; i < expectedOrder.size(); ++i) {
            Assert.assertEquals(expectedOrder.get(i), actualOrder.get(i));
        }
        actualOrder.clear();
        this.sk.setReverseOrder(true);
        cursor = con.search(this.req);
        while (cursor.next()) {
            SearchResultEntry se = (SearchResultEntry)cursor.get();
            entry = se.getEntry();
            actualOrder.add(entry.getDn().getName());
        }
        cursor.close();
        actualOrder.remove(0);
        actualOrder.remove(0);
        actualOrder.remove(0);
        Assert.assertEquals((long)expectedCount, (long)actualOrder.size());
        --expectedCount;
        for (int i = expectedOrder.size() - 1; i >= 0; --i) {
            Assert.assertEquals(expectedOrder.get(i), actualOrder.get(expectedCount - i));
        }
    }

    @Test
    public void testSortByDn() throws Exception {
        int i;
        int i2;
        Entry entry;
        this.sk.setAttributeTypeDesc("entryDn");
        this.sk.setMatchingRuleId("2.5.13.1");
        SearchCursor cursor = con.search(this.req);
        ArrayList<Entry> actualOrder = new ArrayList<Entry>();
        while (cursor.next()) {
            SearchResultEntry se = (SearchResultEntry)cursor.get();
            entry = se.getEntry();
            actualOrder.add(entry);
        }
        cursor.close();
        for (i2 = 0; i2 < actualOrder.size(); ++i2) {
            con.delete(((Entry)actualOrder.get(i2)).getDn());
        }
        for (i2 = actualOrder.size() - 1; i2 >= 0; --i2) {
            con.add((Entry)actualOrder.get(i2));
        }
        actualOrder.clear();
        this.sk.setReverseOrder(true);
        cursor = con.search(this.req);
        while (cursor.next()) {
            SearchResultEntry se = (SearchResultEntry)cursor.get();
            entry = se.getEntry();
            actualOrder.add(entry);
        }
        for (i = actualOrder.size() - 1; i >= 0; --i) {
            con.delete(((Entry)actualOrder.get(i)).getDn());
        }
        for (i = 0; i < actualOrder.size(); ++i) {
            con.add((Entry)actualOrder.get(i));
        }
    }
}

