/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ppolicy;

import java.nio.charset.Charset;
import java.util.Date;
import org.apache.directory.api.ldap.extras.controls.ppolicy.PasswordPolicy;
import org.apache.directory.api.ldap.extras.controls.ppolicy.PasswordPolicyErrorEnum;
import org.apache.directory.api.ldap.extras.controls.ppolicy.PasswordPolicyImpl;
import org.apache.directory.api.ldap.extras.controls.ppolicy_impl.PasswordPolicyDecorator;
import org.apache.directory.api.ldap.model.constants.LdapSecurityConstants;
import org.apache.directory.api.ldap.model.constants.SchemaConstants;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.DefaultModification;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.ModificationOperation;
import org.apache.directory.api.ldap.model.exception.LdapAuthenticationException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.message.AddRequest;
import org.apache.directory.api.ldap.model.message.AddRequestImpl;
import org.apache.directory.api.ldap.model.message.AddResponse;
import org.apache.directory.api.ldap.model.message.BindRequest;
import org.apache.directory.api.ldap.model.message.BindRequestImpl;
import org.apache.directory.api.ldap.model.message.BindResponse;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.ModifyRequest;
import org.apache.directory.api.ldap.model.message.ModifyRequestImpl;
import org.apache.directory.api.ldap.model.message.ModifyResponse;
import org.apache.directory.api.ldap.model.message.Response;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.password.PasswordUtil;
import org.apache.directory.api.util.DateUtils;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.api.InterceptorEnum;
import org.apache.directory.server.core.api.authn.ppolicy.CheckQualityEnum;
import org.apache.directory.server.core.api.authn.ppolicy.PasswordPolicyConfiguration;
import org.apache.directory.server.core.authn.AuthenticationInterceptor;
import org.apache.directory.server.core.authn.ppolicy.PpolicyConfigContainer;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.core.integ.IntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP"), @CreateTransport(protocol="LDAPS")})
@CreateDS(enableChangeLog=false, name="PasswordPolicyTest")
public class PasswordPolicyIT
extends AbstractLdapTestUnit {
    private static final PasswordPolicy PP_REQ_CTRL = new PasswordPolicyImpl();
    private PasswordPolicyConfiguration policyConfig;

    @Before
    public void setPwdPolicy() throws LdapException {
        this.policyConfig = new PasswordPolicyConfiguration();
        this.policyConfig.setPwdMaxAge(110);
        this.policyConfig.setPwdFailureCountInterval(30);
        this.policyConfig.setPwdMaxFailure(2);
        this.policyConfig.setPwdLockout(true);
        this.policyConfig.setPwdLockoutDuration(0);
        this.policyConfig.setPwdMinLength(5);
        this.policyConfig.setPwdInHistory(5);
        this.policyConfig.setPwdExpireWarning(600);
        this.policyConfig.setPwdGraceAuthNLimit(5);
        this.policyConfig.setPwdCheckQuality(CheckQualityEnum.CHECK_REJECT);
        PpolicyConfigContainer policyContainer = new PpolicyConfigContainer();
        policyContainer.setDefaultPolicy(this.policyConfig);
        AuthenticationInterceptor authenticationInterceptor = (AuthenticationInterceptor)PasswordPolicyIT.getService().getInterceptor(InterceptorEnum.AUTHENTICATION_INTERCEPTOR.getName());
        authenticationInterceptor.setPwdPolicies(policyContainer);
    }

    @After
    public void closeConnections() {
        IntegrationUtils.closeConnections();
    }

    private PasswordPolicy getPwdRespCtrl(Response resp) throws Exception {
        Control control = (Control)resp.getControls().get(PP_REQ_CTRL.getOid());
        if (control == null) {
            return null;
        }
        return (PasswordPolicy)((PasswordPolicyDecorator)control).getDecorated();
    }

    private void addUser(LdapConnection adminConnection, String user, Object password) throws Exception {
        DefaultEntry userEntry = new DefaultEntry("cn=" + user + ",ou=system", new Object[]{"ObjectClass: top", "ObjectClass: person", "cn", user, "sn", user + "_sn", "userPassword", password});
        AddRequestImpl addRequest = new AddRequestImpl();
        addRequest.setEntry((Entry)userEntry);
        addRequest.addControl((Control)PP_REQ_CTRL);
        AddResponse addResp = adminConnection.add((AddRequest)addRequest);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)addResp.getLdapResult().getResultCode());
        PasswordPolicy respCtrl = this.getPwdRespCtrl((Response)addResp);
        Assert.assertNull((Object)respCtrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModifyResponse changePassword(Dn userDn, String oldPassword, byte[] newPassword) throws Exception {
        LdapConnection userConnection = null;
        try {
            userConnection = IntegrationUtils.getNetworkConnectionAs((LdapServer)ldapServer, (String)userDn.toString(), (String)oldPassword);
            ModifyRequestImpl modifyRequest = new ModifyRequestImpl();
            modifyRequest.setName(userDn);
            modifyRequest.replace("userPassword", (byte[][])new byte[][]{newPassword});
            ModifyResponse modifyResponse = userConnection.modify((ModifyRequest)modifyRequest);
            return modifyResponse;
        }
        finally {
            userConnection.close();
        }
    }

    private ModifyResponse changePassword(Dn userDn, String oldPassword, String newPassword) throws Exception {
        return this.changePassword(userDn, oldPassword, newPassword.getBytes(Charset.forName("UTF-8")));
    }

    private void checkBindSuccess(Dn userDn, String password) throws Exception {
        LdapConnection userConnection = IntegrationUtils.getNetworkConnectionAs((LdapServer)PasswordPolicyIT.getLdapServer(), (String)userDn.getName(), (String)password);
        Assert.assertNotNull((Object)userConnection);
        Assert.assertTrue((boolean)userConnection.isAuthenticated());
        userConnection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkBindFailure(Dn userDn, String password) throws Exception {
        LdapConnection userConnection = null;
        try {
            userConnection = IntegrationUtils.getNetworkConnectionAs((LdapServer)PasswordPolicyIT.getLdapServer(), (String)userDn.getName(), (String)password);
            Assert.assertNull((Object)userConnection);
        }
        catch (LdapException le) {
        }
        finally {
            if (userConnection != null) {
                userConnection.close();
            }
        }
    }

    private void checkBind(LdapConnection connection, Dn userDn, String password, int nbIterations, String expectedMessage) throws Exception {
        for (int i = 0; i < nbIterations; ++i) {
            try {
                connection.bind(userDn, password);
                continue;
            }
            catch (LdapAuthenticationException le) {
                Assert.assertEquals((Object)expectedMessage, (Object)le.getMessage());
            }
        }
    }

    @Ignore
    @Test
    public void testAddUserWithHashedPwd() throws Exception {
        LdapConnection adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PasswordPolicyIT.getLdapServer());
        byte[] password = PasswordUtil.createStoragePassword((String)"12345", (LdapSecurityConstants)LdapSecurityConstants.HASH_METHOD_CRYPT);
        DefaultEntry userEntry = new DefaultEntry("cn=hashedpwd,ou=system", new Object[]{"ObjectClass: top", "ObjectClass: person", "cn: hashedpwd", "sn: hashedpwd_sn", "userPassword", password});
        AddRequestImpl addRequest = new AddRequestImpl();
        addRequest.setEntry((Entry)userEntry);
        addRequest.addControl((Control)PP_REQ_CTRL);
        AddResponse addResp = adminConnection.add((AddRequest)addRequest);
        Assert.assertEquals((Object)ResultCodeEnum.CONSTRAINT_VIOLATION, (Object)addResp.getLdapResult().getResultCode());
        PasswordPolicy respCtrl = this.getPwdRespCtrl((Response)addResp);
        Assert.assertNotNull((Object)respCtrl);
        Assert.assertEquals((Object)PasswordPolicyErrorEnum.INSUFFICIENT_PASSWORD_QUALITY, (Object)respCtrl.getResponse().getPasswordPolicyError());
        this.policyConfig.setPwdCheckQuality(CheckQualityEnum.CHECK_ACCEPT);
        Attribute pwdAt = userEntry.get("userPassword");
        pwdAt.clear();
        pwdAt.add((byte[][])new byte[][]{password});
        addResp = adminConnection.add((AddRequest)addRequest);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)addResp.getLdapResult().getResultCode());
        respCtrl = this.getPwdRespCtrl((Response)addResp);
        Assert.assertNull((Object)respCtrl);
        LdapConnection userConnection = IntegrationUtils.getNetworkConnectionAs((LdapServer)PasswordPolicyIT.getLdapServer(), (String)"cn=hashedpwd,ou=system", (String)"12345");
        Assert.assertNotNull((Object)userConnection);
        Assert.assertTrue((boolean)userConnection.isAuthenticated());
        adminConnection.close();
    }

    @Test
    public void testAddUserWithPwdChangedTime() throws Exception {
        LdapConnection adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PasswordPolicyIT.getLdapServer());
        String userDn = "cn=hashedpwd,ou=system";
        String pwdChangedTime = "20130913012307.296Z";
        DefaultEntry userEntry = new DefaultEntry("cn=hashedpwd,ou=system", new Object[]{"ObjectClass: top", "ObjectClass: person", "cn: hashedpwd", "sn: hashedpwd_sn", "userPassword: set4now", "pwdChangedTime", pwdChangedTime});
        AddRequestImpl addRequest = new AddRequestImpl();
        addRequest.setEntry((Entry)userEntry);
        addRequest.addControl((Control)PP_REQ_CTRL);
        AddResponse addResp = adminConnection.add((AddRequest)addRequest);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)addResp.getLdapResult().getResultCode());
        userEntry = adminConnection.lookup(userDn, SchemaConstants.ALL_ATTRIBUTES_ARRAY);
        Attribute pwdChangedTimeAt = userEntry.get("pwdChangedTime");
        Assert.assertNotNull((Object)pwdChangedTimeAt);
        Assert.assertEquals((Object)pwdChangedTime, (Object)pwdChangedTimeAt.getString());
        adminConnection.close();
    }

    @Test
    public void testModifyUserWithHashedPwd() throws Exception {
        Dn userDn = new Dn(new String[]{"cn=hashedpwdm,ou=system"});
        LdapConnection adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PasswordPolicyIT.getLdapServer());
        DefaultEntry userEntry = new DefaultEntry(userDn.toString(), new Object[]{"ObjectClass: top", "ObjectClass: person", "cn: hashedpwdm", "sn: hashedpwdm_sn", "userPassword", "set4now"});
        adminConnection.add((Entry)userEntry);
        byte[] password = PasswordUtil.createStoragePassword((String)"12345", (LdapSecurityConstants)LdapSecurityConstants.HASH_METHOD_CRYPT);
        Assert.assertEquals((Object)ResultCodeEnum.CONSTRAINT_VIOLATION, (Object)this.changePassword(userDn, "set4now", password).getLdapResult().getResultCode());
        this.checkBindFailure(userDn, "12345");
        adminConnection.close();
    }

    @Test
    public void testPwdLockoutForever() throws Exception {
        this.policyConfig.setPwdMaxFailure(2);
        this.policyConfig.setPwdLockout(true);
        this.policyConfig.setPwdLockoutDuration(0);
        this.policyConfig.setPwdGraceAuthNLimit(2);
        this.policyConfig.setPwdFailureCountInterval(30);
        LdapConnection adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PasswordPolicyIT.getLdapServer());
        Dn userDn = new Dn(new String[]{"cn=user2,ou=system"});
        DefaultEntry userEntry = new DefaultEntry(userDn.toString(), new Object[]{"ObjectClass: top", "ObjectClass: person", "cn: user2", "sn: user_sn", "userPassword: 12345"});
        AddRequestImpl addRequest = new AddRequestImpl();
        addRequest.setEntry((Entry)userEntry);
        addRequest.addControl((Control)PP_REQ_CTRL);
        AddResponse addResp = adminConnection.add((AddRequest)addRequest);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)addResp.getLdapResult().getResultCode());
        PasswordPolicy respCtrl = this.getPwdRespCtrl((Response)addResp);
        Assert.assertNull((Object)respCtrl);
        BindRequestImpl bindReq = new BindRequestImpl();
        bindReq.setDn(userDn);
        bindReq.setCredentials("1234");
        bindReq.addControl((Control)PP_REQ_CTRL);
        LdapNetworkConnection userConnection = new LdapNetworkConnection("localhost", ldapServer.getPort());
        for (int i = 0; i < 3; ++i) {
            userConnection.bind((BindRequest)bindReq);
            Assert.assertFalse((boolean)userConnection.isAuthenticated());
        }
        Thread.sleep(2000L);
        userEntry = adminConnection.lookup(userDn, SchemaConstants.ALL_ATTRIBUTES_ARRAY);
        Attribute pwdAccountLockedTime = userEntry.get("pwdAccountLockedTime");
        Assert.assertNotNull((Object)pwdAccountLockedTime);
        Assert.assertEquals((Object)"000001010000Z", (Object)pwdAccountLockedTime.getString());
        bindReq = new BindRequestImpl();
        bindReq.setDn(userDn);
        bindReq.setCredentials("12345");
        bindReq.addControl((Control)PP_REQ_CTRL);
        userConnection.bind((BindRequest)bindReq);
        Assert.assertFalse((boolean)userConnection.isAuthenticated());
        userConnection.close();
        ModifyRequestImpl modReq = new ModifyRequestImpl();
        modReq.setName(userDn);
        modReq.addControl((Control)PP_REQ_CTRL);
        modReq.remove(userEntry.get("userPassword"));
        ModifyResponse modResp = adminConnection.modify((ModifyRequest)modReq);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)modResp.getLdapResult().getResultCode());
        userEntry = adminConnection.lookup(userDn, new String[]{"+"});
        Assert.assertNull((Object)userEntry.get("pwdFailureTime"));
        Assert.assertNull((Object)userEntry.get("pwdGraceUseTime"));
        Assert.assertNull((Object)userEntry.get("pwdHistory"));
        Assert.assertNull((Object)userEntry.get("pwdChangedTime"));
        Assert.assertNull((Object)userEntry.get("pwdAccountLockedTime"));
        adminConnection.close();
    }

    @Test
    public void testPwdMinAge() throws Exception {
        this.policyConfig.setPwdMinAge(5);
        LdapConnection adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PasswordPolicyIT.getLdapServer());
        Dn userDn = new Dn(new String[]{"cn=userMinAge,ou=system"});
        DefaultEntry userEntry = new DefaultEntry(userDn.toString(), new Object[]{"ObjectClass: top", "ObjectClass: person", "cn: userMinAge", "sn: userMinAge_sn", "userPassword: 12345"});
        adminConnection.add((Entry)userEntry);
        Assert.assertEquals((Object)ResultCodeEnum.CONSTRAINT_VIOLATION, (Object)this.changePassword(userDn, "12345", "123456").getLdapResult().getResultCode());
        Thread.sleep(5000L);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)this.changePassword(userDn, "12345", "123456").getLdapResult().getResultCode());
        this.checkBindSuccess(userDn, "123456");
        adminConnection.close();
    }

    @Test
    public void testPwdInHistory() throws Exception {
        this.policyConfig.setPwdInHistory(2);
        LdapConnection adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PasswordPolicyIT.getLdapServer());
        Dn userDn = new Dn(new String[]{"cn=userPwdHist,ou=system"});
        this.addUser(adminConnection, "userPwdHist", "12345");
        this.checkBindSuccess(userDn, "12345");
        Entry entry = adminConnection.lookup(userDn, new String[]{"*", "+"});
        Attribute pwdHistAt = entry.get("pwdHistory");
        Assert.assertNotNull((Object)pwdHistAt);
        Assert.assertEquals((long)1L, (long)pwdHistAt.size());
        Thread.sleep(1000L);
        DefaultModification modification = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "userPassword", new String[]{"67891"});
        adminConnection.modify(userDn, new Modification[]{modification});
        this.checkBindSuccess(userDn, "67891");
        entry = adminConnection.lookup(userDn, new String[]{"*", "+"});
        pwdHistAt = entry.get("pwdHistory");
        Assert.assertNotNull((Object)pwdHistAt);
        Assert.assertEquals((long)2L, (long)pwdHistAt.size());
        Thread.sleep(1000L);
        modification = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "userPassword", new String[]{"abcde"});
        adminConnection.modify(userDn, new Modification[]{modification});
        this.checkBindSuccess(userDn, "abcde");
        entry = adminConnection.lookup(userDn, new String[]{"*", "+"});
        pwdHistAt = entry.get("pwdHistory");
        Assert.assertNotNull((Object)pwdHistAt);
        Assert.assertEquals((long)2L, (long)pwdHistAt.size());
        try {
            adminConnection.modify(userDn, new Modification[]{modification});
            Assert.fail();
        }
        catch (LdapInvalidAttributeValueException liave) {
            // empty catch block
        }
        modification = new DefaultModification(ModificationOperation.REPLACE_ATTRIBUTE, "userPassword", new String[]{"12345"});
        adminConnection.modify(userDn, new Modification[]{modification});
        this.checkBindSuccess(userDn, "12345");
        adminConnection.close();
    }

    @Test
    public void testPwdLength() throws Exception {
        this.policyConfig.setPwdMinLength(5);
        this.policyConfig.setPwdMaxLength(7);
        this.policyConfig.setPwdCheckQuality(CheckQualityEnum.CHECK_REJECT);
        LdapConnection adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PasswordPolicyIT.getLdapServer());
        Dn userDn = new Dn(new String[]{"cn=userLen,ou=system"});
        DefaultEntry userEntry = new DefaultEntry(userDn.toString(), new Object[]{"ObjectClass: top", "ObjectClass: person", "cn: userLen", "sn: userLen_sn", "userPassword: set4now"});
        adminConnection.add((Entry)userEntry);
        Assert.assertEquals((Object)ResultCodeEnum.CONSTRAINT_VIOLATION, (Object)this.changePassword(userDn, "set4now", "1234").getLdapResult().getResultCode());
        this.checkBindFailure(userDn, "1234");
        Assert.assertEquals((Object)ResultCodeEnum.CONSTRAINT_VIOLATION, (Object)this.changePassword(userDn, "set4now", "12345678").getLdapResult().getResultCode());
        this.checkBindFailure(userDn, "12345678");
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)this.changePassword(userDn, "set4now", "123456").getLdapResult().getResultCode());
        this.checkBindSuccess(userDn, "123456");
        adminConnection.close();
    }

    @Test
    public void testPwdMaxAgeNoGraceAuthNLimit() throws Exception {
        this.policyConfig.setPwdMaxAge(5);
        this.policyConfig.setPwdGraceAuthNLimit(0);
        LdapConnection adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PasswordPolicyIT.getLdapServer());
        Dn userDn = new Dn(new String[]{"cn=userMaxAgeNoGraceAuthNLimit,ou=system"});
        String password = "12345";
        this.addUser(adminConnection, "userMaxAgeNoGraceAuthNLimit", password);
        BindRequestImpl bindReq = new BindRequestImpl();
        bindReq.setDn(userDn);
        bindReq.setCredentials(password.getBytes());
        bindReq.addControl((Control)PP_REQ_CTRL);
        LdapNetworkConnection userCon = new LdapNetworkConnection("localhost", ldapServer.getPort());
        userCon.setTimeOut(0L);
        Thread.sleep(1000L);
        BindResponse bindResp = userCon.bind((BindRequest)bindReq);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)bindResp.getLdapResult().getResultCode());
        PasswordPolicy respCtrl = this.getPwdRespCtrl((Response)bindResp);
        Assert.assertNotNull((Object)respCtrl);
        Assert.assertTrue((respCtrl.getResponse().getTimeBeforeExpiration() > 0 ? 1 : 0) != 0);
        Thread.sleep(4500L);
        bindResp = userCon.bind((BindRequest)bindReq);
        Assert.assertEquals((Object)ResultCodeEnum.INVALID_CREDENTIALS, (Object)bindResp.getLdapResult().getResultCode());
        respCtrl = this.getPwdRespCtrl((Response)bindResp);
        Assert.assertEquals((Object)PasswordPolicyErrorEnum.PASSWORD_EXPIRED, (Object)respCtrl.getResponse().getPasswordPolicyError());
        adminConnection.close();
    }

    @Test
    public void testPwdMaxAgeWithGraceAuthNLimit() throws Exception {
        this.policyConfig.setPwdMaxAge(5);
        this.policyConfig.setPwdGraceAuthNLimit(2);
        LdapConnection adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PasswordPolicyIT.getLdapServer());
        Dn userDn = new Dn(new String[]{"cn=userMaxAgeWithGraceAuthNLimit,ou=system"});
        String password = "12345";
        this.addUser(adminConnection, "userMaxAgeWithGraceAuthNLimit", password);
        BindRequestImpl bindReq = new BindRequestImpl();
        bindReq.setDn(userDn);
        bindReq.setCredentials(password.getBytes());
        bindReq.addControl((Control)PP_REQ_CTRL);
        LdapNetworkConnection userCon = new LdapNetworkConnection("localhost", ldapServer.getPort());
        userCon.setTimeOut(0L);
        Thread.sleep(1000L);
        BindResponse bindResp = userCon.bind((BindRequest)bindReq);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)bindResp.getLdapResult().getResultCode());
        PasswordPolicy respCtrl = this.getPwdRespCtrl((Response)bindResp);
        Assert.assertNotNull((Object)respCtrl);
        Assert.assertTrue((respCtrl.getResponse().getTimeBeforeExpiration() > 0 ? 1 : 0) != 0);
        Thread.sleep(4500L);
        bindResp = userCon.bind((BindRequest)bindReq);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)bindResp.getLdapResult().getResultCode());
        respCtrl = this.getPwdRespCtrl((Response)bindResp);
        Assert.assertNotNull((Object)respCtrl);
        Assert.assertEquals((long)1L, (long)respCtrl.getResponse().getGraceAuthNRemaining());
        bindResp = userCon.bind((BindRequest)bindReq);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)bindResp.getLdapResult().getResultCode());
        respCtrl = this.getPwdRespCtrl((Response)bindResp);
        Assert.assertNotNull((Object)respCtrl);
        Assert.assertEquals((long)0L, (long)respCtrl.getResponse().getGraceAuthNRemaining());
        bindResp = userCon.bind((BindRequest)bindReq);
        Assert.assertEquals((Object)ResultCodeEnum.INVALID_CREDENTIALS, (Object)bindResp.getLdapResult().getResultCode());
        respCtrl = this.getPwdRespCtrl((Response)bindResp);
        Assert.assertEquals((Object)PasswordPolicyErrorEnum.PASSWORD_EXPIRED, (Object)respCtrl.getResponse().getPasswordPolicyError());
        adminConnection.close();
    }

    @Test
    public void testPwdMaxAgeWithGraceExpire() throws Exception {
        this.policyConfig.setPwdMaxAge(5);
        this.policyConfig.setPwdGraceExpire(2);
        this.policyConfig.setPwdGraceAuthNLimit(2);
        LdapConnection adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PasswordPolicyIT.getLdapServer());
        Dn userDn = new Dn(new String[]{"cn=userMaxAgeWithGraceExpire,ou=system"});
        String password = "12345";
        this.addUser(adminConnection, "userMaxAgeWithGraceExpire", password);
        BindRequestImpl bindReq = new BindRequestImpl();
        bindReq.setDn(userDn);
        bindReq.setCredentials(password.getBytes());
        bindReq.addControl((Control)PP_REQ_CTRL);
        LdapNetworkConnection userCon = new LdapNetworkConnection("localhost", ldapServer.getPort());
        userCon.setTimeOut(0L);
        Thread.sleep(1000L);
        BindResponse bindResp = userCon.bind((BindRequest)bindReq);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)bindResp.getLdapResult().getResultCode());
        PasswordPolicy respCtrl = this.getPwdRespCtrl((Response)bindResp);
        Assert.assertNotNull((Object)respCtrl);
        Assert.assertTrue((respCtrl.getResponse().getTimeBeforeExpiration() > 0 ? 1 : 0) != 0);
        Thread.sleep(4500L);
        bindResp = userCon.bind((BindRequest)bindReq);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)bindResp.getLdapResult().getResultCode());
        respCtrl = this.getPwdRespCtrl((Response)bindResp);
        Assert.assertNotNull((Object)respCtrl);
        Assert.assertEquals((long)1L, (long)respCtrl.getResponse().getGraceAuthNRemaining());
        bindResp = userCon.bind((BindRequest)bindReq);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)bindResp.getLdapResult().getResultCode());
        respCtrl = this.getPwdRespCtrl((Response)bindResp);
        Assert.assertNotNull((Object)respCtrl);
        Assert.assertEquals((long)0L, (long)respCtrl.getResponse().getGraceAuthNRemaining());
        bindResp = userCon.bind((BindRequest)bindReq);
        Assert.assertEquals((Object)ResultCodeEnum.INVALID_CREDENTIALS, (Object)bindResp.getLdapResult().getResultCode());
        respCtrl = this.getPwdRespCtrl((Response)bindResp);
        Assert.assertEquals((Object)PasswordPolicyErrorEnum.PASSWORD_EXPIRED, (Object)respCtrl.getResponse().getPasswordPolicyError());
        adminConnection.close();
    }

    @Test
    public void testPwdMaxAgeAndGraceAuth() throws Exception {
        this.policyConfig.setPwdMaxAge(5);
        this.policyConfig.setPwdExpireWarning(4);
        this.policyConfig.setPwdGraceAuthNLimit(2);
        LdapConnection adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PasswordPolicyIT.getLdapServer());
        Dn userDn = new Dn(new String[]{"cn=userMaxAgeAndGraceAuth,ou=system"});
        String password = "12345";
        this.addUser(adminConnection, "userMaxAgeAndGraceAuth", password);
        BindRequestImpl bindReq = new BindRequestImpl();
        bindReq.setDn(userDn);
        bindReq.setCredentials(password.getBytes());
        bindReq.addControl((Control)PP_REQ_CTRL);
        LdapNetworkConnection userCon = new LdapNetworkConnection("localhost", ldapServer.getPort());
        userCon.setTimeOut(0L);
        Thread.sleep(1000L);
        BindResponse bindResp = userCon.bind((BindRequest)bindReq);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)bindResp.getLdapResult().getResultCode());
        PasswordPolicy respCtrl = this.getPwdRespCtrl((Response)bindResp);
        Assert.assertNotNull((Object)respCtrl);
        Assert.assertTrue((respCtrl.getResponse().getTimeBeforeExpiration() > 0 ? 1 : 0) != 0);
        Thread.sleep(4000L);
        bindResp = userCon.bind((BindRequest)bindReq);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)bindResp.getLdapResult().getResultCode());
        respCtrl = this.getPwdRespCtrl((Response)bindResp);
        Assert.assertNotNull((Object)respCtrl);
        Assert.assertEquals((long)1L, (long)respCtrl.getResponse().getGraceAuthNRemaining());
        Thread.sleep(1000L);
        bindResp = userCon.bind((BindRequest)bindReq);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)bindResp.getLdapResult().getResultCode());
        respCtrl = this.getPwdRespCtrl((Response)bindResp);
        Assert.assertEquals((long)0L, (long)respCtrl.getResponse().getGraceAuthNRemaining());
        bindResp = userCon.bind((BindRequest)bindReq);
        Assert.assertEquals((Object)ResultCodeEnum.INVALID_CREDENTIALS, (Object)bindResp.getLdapResult().getResultCode());
        respCtrl = this.getPwdRespCtrl((Response)bindResp);
        Assert.assertEquals((Object)PasswordPolicyErrorEnum.PASSWORD_EXPIRED, (Object)respCtrl.getResponse().getPasswordPolicyError());
        adminConnection.close();
    }

    @Test
    public void testModifyPwdSubentry() throws Exception {
        LdapConnection adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PasswordPolicyIT.getLdapServer());
        Dn userDn = new Dn(new String[]{"cn=ppolicySubentry,ou=system"});
        String password = "12345";
        DefaultEntry userEntry = new DefaultEntry(userDn.toString(), new Object[]{"ObjectClass: top", "ObjectClass: person", "cn: ppolicySubentry", "sn: ppolicySubentry_sn", "userPassword: " + password, "pwdPolicySubEntry:" + userDn.getName()});
        AddRequestImpl addRequest = new AddRequestImpl();
        addRequest.setEntry((Entry)userEntry);
        addRequest.addControl((Control)PP_REQ_CTRL);
        AddResponse addResp = adminConnection.add((AddRequest)addRequest);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)addResp.getLdapResult().getResultCode());
        userEntry = adminConnection.lookup(userDn, new String[]{"*", "+"});
        Assert.assertEquals((Object)userDn.getName(), (Object)userEntry.get("pwdPolicySubEntry").getString());
        ModifyRequestImpl modReq = new ModifyRequestImpl();
        modReq.setName(userDn);
        String modSubEntryDn = "cn=policy,ou=system";
        modReq.replace("pwdPolicySubEntry", new String[]{modSubEntryDn});
        ModifyResponse modResp = adminConnection.modify((ModifyRequest)modReq);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)modResp.getLdapResult().getResultCode());
        userEntry = adminConnection.lookup(userDn, new String[]{"*", "+"});
        Assert.assertEquals((Object)modSubEntryDn, (Object)userEntry.get("pwdPolicySubEntry").getString());
        adminConnection = new LdapNetworkConnection("localhost", PasswordPolicyIT.getLdapServer().getPort());
        adminConnection.bind(userDn.getName(), password);
        modResp = adminConnection.modify((ModifyRequest)modReq);
        modReq.replace("pwdPolicySubEntry", new String[]{userDn.getName()});
        Assert.assertEquals((Object)ResultCodeEnum.INSUFFICIENT_ACCESS_RIGHTS, (Object)modResp.getLdapResult().getResultCode());
        adminConnection.close();
    }

    @Test
    public void testGraceAuth() throws Exception {
        this.policyConfig.setPwdMaxFailure(2);
        this.policyConfig.setPwdLockout(true);
        this.policyConfig.setPwdLockoutDuration(0);
        this.policyConfig.setPwdGraceAuthNLimit(2);
        this.policyConfig.setPwdFailureCountInterval(60);
        this.policyConfig.setPwdMaxAge(1);
        LdapConnection adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PasswordPolicyIT.getLdapServer());
        Dn userDn = new Dn(new String[]{"cn=userGrace,ou=system"});
        this.addUser(adminConnection, "userGrace", "12345");
        BindRequestImpl bindReq = new BindRequestImpl();
        bindReq.setDn(userDn);
        bindReq.setCredentials("12345");
        bindReq.addControl((Control)PP_REQ_CTRL);
        LdapNetworkConnection userConnection = new LdapNetworkConnection("localhost", ldapServer.getPort());
        Thread.sleep(2000L);
        BindResponse bindResp = userConnection.bind((BindRequest)bindReq);
        Assert.assertTrue((boolean)userConnection.isAuthenticated());
        PasswordPolicy ppolicy = this.getPwdRespCtrl((Response)bindResp);
        Assert.assertEquals((long)1L, (long)ppolicy.getResponse().getGraceAuthNRemaining());
        Entry userEntry = adminConnection.lookup(userDn, new String[]{"+"});
        Attribute pwdGraceAuthUseTime = userEntry.get("pwdGraceUseTime");
        Assert.assertNotNull((Object)pwdGraceAuthUseTime);
        Attribute pwdChangedTime = userEntry.get("pwdChangedTime");
        ModifyRequestImpl modReq = new ModifyRequestImpl();
        modReq.setName(userDn);
        modReq.replace("userPassword", new String[]{"secret1"});
        ModifyResponse modResp = userConnection.modify((ModifyRequest)modReq);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)modResp.getLdapResult().getResultCode());
        userEntry = adminConnection.lookup(userDn, new String[]{"+"});
        pwdGraceAuthUseTime = userEntry.get("pwdGraceUseTime");
        Assert.assertNull((Object)pwdGraceAuthUseTime);
        Attribute latestPwdChangedTime = userEntry.get("pwdChangedTime");
        Assert.assertNotSame((Object)pwdChangedTime.getString(), (Object)latestPwdChangedTime.getString());
        userConnection.close();
        adminConnection.close();
    }

    @Test
    public void testPwdLockoutWithDuration() throws Exception {
        this.policyConfig.setPwdMaxFailure(2);
        this.policyConfig.setPwdLockout(true);
        this.policyConfig.setPwdLockoutDuration(5);
        this.policyConfig.setPwdGraceAuthNLimit(2);
        this.policyConfig.setPwdFailureCountInterval(0);
        LdapConnection adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PasswordPolicyIT.getLdapServer());
        Dn userDn = new Dn(new String[]{"cn=userLockoutWithDuration,ou=system"});
        this.addUser(adminConnection, "userLockoutWithDuration", "12345");
        BindRequestImpl bindReq = new BindRequestImpl();
        bindReq.setDn(userDn);
        bindReq.setCredentials("1234");
        bindReq.addControl((Control)PP_REQ_CTRL);
        LdapNetworkConnection userConnection = new LdapNetworkConnection("localhost", ldapServer.getPort());
        for (int i = 0; i < 4; ++i) {
            userConnection.bind((BindRequest)bindReq);
            Assert.assertFalse((boolean)userConnection.isAuthenticated());
        }
        Entry userEntry = adminConnection.lookup(userDn, new String[]{"+"});
        Attribute pwdAccountLockedTime = userEntry.get("pwdAccountLockedTime");
        Assert.assertNotNull((Object)pwdAccountLockedTime);
        Thread.sleep(10000L);
        bindReq = new BindRequestImpl();
        bindReq.setDn(userDn);
        bindReq.setCredentials("12345");
        bindReq.addControl((Control)PP_REQ_CTRL);
        userConnection.setTimeOut(Long.MAX_VALUE);
        userConnection.bind((BindRequest)bindReq);
        Assert.assertTrue((boolean)userConnection.isAuthenticated());
        userConnection.close();
        adminConnection.close();
    }

    @Test
    public void testPwdLockoutWithNAttempts() throws Exception {
        this.policyConfig.setPwdMaxFailure(3);
        this.policyConfig.setPwdLockout(true);
        Dn userDn = new Dn(new String[]{"cn=userLockout,ou=system"});
        LdapConnection adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PasswordPolicyIT.getLdapServer());
        this.addUser(adminConnection, "userLockout", "12345");
        LdapNetworkConnection userConnection = new LdapNetworkConnection("localhost", ldapServer.getPort());
        userConnection.setTimeOut(0L);
        this.checkBind((LdapConnection)userConnection, userDn, "badPassword", 3, "INVALID_CREDENTIALS: Bind failed: ERR_229 Cannot authenticate user cn=userLockout,ou=system");
        this.checkBind((LdapConnection)userConnection, userDn, "badPassword", 1, "INVALID_CREDENTIALS: Bind failed: account was permanently locked");
        userConnection.close();
        Entry userEntry = adminConnection.lookup(userDn, new String[]{"+"});
        Attribute pwdAccountLockedTime = userEntry.get("pwdAccountLockedTime");
        Assert.assertNotNull((Object)pwdAccountLockedTime);
        adminConnection.close();
    }

    @Test
    public void testPwdLockoutWithNAttemptsAndLockoutDelay() throws Exception {
        this.policyConfig.setPwdLockout(true);
        this.policyConfig.setPwdMaxFailure(3);
        this.policyConfig.setPwdLockoutDuration(5);
        Dn userDn = new Dn(new String[]{"cn=userLockout2,ou=system"});
        LdapConnection adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PasswordPolicyIT.getLdapServer());
        this.addUser(adminConnection, "userLockout2", "12345");
        LdapNetworkConnection userConnection = new LdapNetworkConnection("localhost", ldapServer.getPort());
        userConnection.setTimeOut(0L);
        this.checkBind((LdapConnection)userConnection, userDn, "badPassword", 3, "INVALID_CREDENTIALS: Bind failed: ERR_229 Cannot authenticate user cn=userLockout2,ou=system");
        boolean success = false;
        int t = 0;
        for (t = 0; t < 10; ++t) {
            try {
                userConnection.bind(userDn, "12345");
                success = true;
                break;
            }
            catch (LdapException le) {
                Entry userEntry = adminConnection.lookup(userDn, new String[]{"+"});
                Attribute pwdAccountLockedTime = userEntry.get("pwdAccountLockedTime");
                Assert.assertNotNull((Object)pwdAccountLockedTime);
                Thread.sleep(1000L);
                continue;
            }
        }
        Assert.assertTrue((boolean)success);
        Assert.assertTrue((t >= 5 ? 1 : 0) != 0);
        userConnection.close();
        Entry userEntry = adminConnection.lookup(userDn, new String[]{"+"});
        Attribute pwdAccountLockedTime = userEntry.get("pwdAccountLockedTime");
        Assert.assertNull((Object)pwdAccountLockedTime);
        adminConnection.close();
    }

    @Test
    public void testPwdLockoutFailureCountInterval() throws Exception {
        this.policyConfig.setPwdLockout(true);
        this.policyConfig.setPwdMaxFailure(5);
        this.policyConfig.setPwdFailureCountInterval(2);
        Dn userDn = new Dn(new String[]{"cn=userLockout3,ou=system"});
        LdapConnection adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PasswordPolicyIT.getLdapServer());
        this.addUser(adminConnection, "userLockout3", "12345");
        LdapNetworkConnection userConnection = new LdapNetworkConnection("localhost", ldapServer.getPort());
        userConnection.setTimeOut(0L);
        this.checkBind((LdapConnection)userConnection, userDn, "badPassword", 1, "INVALID_CREDENTIALS: Bind failed: ERR_229 Cannot authenticate user cn=userLockout3,ou=system");
        Entry userEntry = adminConnection.lookup(userDn, new String[]{"+"});
        Attribute pwdFailureTime = userEntry.get("pwdFailureTime");
        Assert.assertNotNull((Object)pwdFailureTime);
        Assert.assertEquals((long)1L, (long)pwdFailureTime.size());
        Thread.sleep(1000L);
        this.checkBind((LdapConnection)userConnection, userDn, "badPassword", 1, "INVALID_CREDENTIALS: Bind failed: ERR_229 Cannot authenticate user cn=userLockout3,ou=system");
        userEntry = adminConnection.lookup(userDn, new String[]{"+"});
        pwdFailureTime = userEntry.get("pwdFailureTime");
        Assert.assertNotNull((Object)pwdFailureTime);
        Assert.assertEquals((long)2L, (long)pwdFailureTime.size());
        Thread.sleep(1000L);
        this.checkBind((LdapConnection)userConnection, userDn, "badPassword", 1, "INVALID_CREDENTIALS: Bind failed: ERR_229 Cannot authenticate user cn=userLockout3,ou=system");
        userEntry = adminConnection.lookup(userDn, new String[]{"+"});
        pwdFailureTime = userEntry.get("pwdFailureTime");
        Assert.assertNotNull((Object)pwdFailureTime);
        Assert.assertEquals((long)2L, (long)pwdFailureTime.size());
        Thread.sleep(1000L);
        this.checkBind((LdapConnection)userConnection, userDn, "badPassword", 1, "INVALID_CREDENTIALS: Bind failed: ERR_229 Cannot authenticate user cn=userLockout3,ou=system");
        userEntry = adminConnection.lookup(userDn, new String[]{"+"});
        pwdFailureTime = userEntry.get("pwdFailureTime");
        Assert.assertNotNull((Object)pwdFailureTime);
        Assert.assertEquals((long)2L, (long)pwdFailureTime.size());
        userConnection.close();
        adminConnection.close();
    }

    @Test
    @Ignore
    public void testPwdAttempsDelayed() throws Exception {
        this.policyConfig.setPwdMinDelay(200);
        this.policyConfig.setPwdMaxDelay(400);
        this.policyConfig.setPwdLockout(true);
        Dn userDn = new Dn(new String[]{"cn=userLockout,ou=system"});
        LdapConnection adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PasswordPolicyIT.getLdapServer());
        this.addUser(adminConnection, "userLockout", "12345");
        LdapNetworkConnection userConnection = new LdapNetworkConnection("localhost", ldapServer.getPort());
        this.checkBind((LdapConnection)userConnection, userDn, "badPassword", 1, "INVALID_CREDENTIALS: Bind failed: ERR_229 Cannot authenticate user cn=userLockout,ou=system");
        Thread.sleep(1000L);
        this.checkBind((LdapConnection)userConnection, userDn, "12345", 1, "INVALID_CREDENTIALS: Bind failed: ERR_229 Cannot authenticate user cn=userLockout,ou=system");
        Thread.sleep(1200L);
        userConnection.bind(userDn, "12345");
        userConnection.close();
        adminConnection.close();
    }

    @Test
    public void testPwMaxIdle() throws Exception {
        this.policyConfig.setPwdMaxIdle(5);
        Dn userDn = new Dn(new String[]{"cn=userLockout4,ou=system"});
        LdapConnection adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PasswordPolicyIT.getLdapServer());
        this.addUser(adminConnection, "userLockout4", "12345");
        this.checkBindSuccess(userDn, "12345");
        Thread.sleep(5000L);
        this.checkBindFailure(userDn, "12345");
        adminConnection.close();
    }

    @Test
    public void testPwdAllowUserChange() throws Exception {
        this.policyConfig.setPwdAllowUserChange(false);
        Dn userDn = new Dn(new String[]{"cn=userAllowUserChange,ou=system"});
        LdapConnection adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PasswordPolicyIT.getLdapServer());
        this.addUser(adminConnection, "userAllowUserChange", "12345");
        LdapNetworkConnection userConnection = new LdapNetworkConnection("localhost", ldapServer.getPort());
        userConnection.setTimeOut(0L);
        this.checkBindSuccess(userDn, "12345");
        ModifyRequestImpl modReq = new ModifyRequestImpl();
        modReq.setName(userDn);
        modReq.addControl((Control)PP_REQ_CTRL);
        modReq.replace("userPassword", new String[]{"67890"});
        userConnection = IntegrationUtils.getNetworkConnectionAs((LdapServer)PasswordPolicyIT.getLdapServer(), (String)userDn.getName(), (String)"12345");
        userConnection.setTimeOut(0L);
        ModifyResponse modifyResponse = userConnection.modify((ModifyRequest)modReq);
        Assert.assertEquals((Object)ResultCodeEnum.INSUFFICIENT_ACCESS_RIGHTS, (Object)modifyResponse.getLdapResult().getResultCode());
        this.policyConfig.setPwdAllowUserChange(true);
        modifyResponse = userConnection.modify((ModifyRequest)modReq);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)modifyResponse.getLdapResult().getResultCode());
        userConnection.close();
        this.checkBindSuccess(userDn, "67890");
        adminConnection.close();
    }

    @Test
    public void testPwdExpireWarning() throws Exception {
        this.policyConfig.setPwdMaxAge(5);
        this.policyConfig.setPwdGraceAuthNLimit(0);
        this.policyConfig.setPwdExpireWarning(3);
        Dn userDn = new Dn(new String[]{"cn=userExpireWarning,ou=system"});
        LdapConnection adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PasswordPolicyIT.getLdapServer());
        this.addUser(adminConnection, "userExpireWarning", "12345");
        LdapNetworkConnection userConnection = new LdapNetworkConnection("localhost", ldapServer.getPort());
        userConnection.setTimeOut(0L);
        BindRequestImpl bindReq = new BindRequestImpl();
        bindReq.setDn(userDn);
        bindReq.setCredentials("12345");
        bindReq.addControl((Control)PP_REQ_CTRL);
        for (int i = 0; i < 5; ++i) {
            BindResponse bindResponse = userConnection.bind((BindRequest)bindReq);
            Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)bindResponse.getLdapResult().getResultCode());
            PasswordPolicy respCtrl = this.getPwdRespCtrl((Response)bindResponse);
            Assert.assertNotNull((Object)respCtrl);
            if (i < 2) {
                Assert.assertNull((Object)respCtrl.getResponse());
            } else {
                Assert.assertEquals((long)(5 - i), (long)respCtrl.getResponse().getTimeBeforeExpiration());
            }
            Thread.sleep(1000L);
        }
        Thread.sleep(1000L);
        this.checkBindFailure(userDn, "12345");
        userConnection.close();
        adminConnection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPwdExpireWarningToo() throws Exception {
        this.policyConfig.setPwdGraceAuthNLimit(0);
        this.policyConfig.setPwdMaxAge(3600);
        this.policyConfig.setPwdExpireWarning(600);
        LdapConnection adminConnection = null;
        LdapNetworkConnection userConnection = null;
        LdapNetworkConnection userConnection2 = null;
        try {
            String userCn = "userExpireWarningToo";
            Dn userDn = new Dn(new String[]{"cn=" + userCn + ",ou=system"});
            String password = "12345";
            adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PasswordPolicyIT.getLdapServer());
            userConnection = new LdapNetworkConnection("localhost", ldapServer.getPort());
            userConnection.setTimeOut(0L);
            userConnection2 = new LdapNetworkConnection("localhost", ldapServer.getPort());
            userConnection2.setTimeOut(0L);
            this.addUser(adminConnection, userCn, password);
            BindRequestImpl bindReq = new BindRequestImpl();
            bindReq.setDn(userDn);
            bindReq.setCredentials("12345");
            bindReq.addControl((Control)PP_REQ_CTRL);
            BindResponse bindResponse = userConnection2.bind((BindRequest)bindReq);
            PasswordPolicy respCtrl = this.getPwdRespCtrl((Response)bindResponse);
            Assert.assertNotNull((Object)respCtrl);
            Assert.assertNull((Object)respCtrl.getResponse());
            ModifyRequestImpl modifyRequest = new ModifyRequestImpl();
            modifyRequest.setName(userDn);
            modifyRequest.replace("pwdChangedTime", new String[]{DateUtils.getGeneralizedTime((long)(new Date().getTime() - 3100000L))});
            adminConnection.modify((ModifyRequest)modifyRequest);
            BindRequestImpl bindReq2 = new BindRequestImpl();
            bindReq2.setDn(userDn);
            bindReq2.setCredentials("12345");
            bindReq2.addControl((Control)new PasswordPolicyImpl());
            bindResponse = userConnection.bind((BindRequest)bindReq2);
            respCtrl = this.getPwdRespCtrl((Response)bindResponse);
            Assert.assertNotNull((Object)respCtrl);
            Assert.assertNotNull((Object)respCtrl.getResponse());
            Assert.assertTrue((respCtrl.getResponse().getTimeBeforeExpiration() > 0 ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            this.safeCloseConnections(new LdapConnection[]{userConnection, userConnection2, adminConnection});
            throw throwable;
        }
        this.safeCloseConnections(new LdapConnection[]{userConnection, userConnection2, adminConnection});
    }

    private void safeCloseConnections(LdapConnection ... connections) {
        for (LdapConnection connection : connections) {
            try {
                connection.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @Test
    public void testPwdMinAgeWithMustChange() throws Exception {
        this.policyConfig.setPwdMustChange(true);
        this.policyConfig.setPwdMinAge(1);
        LdapConnection adminConnection = IntegrationUtils.getAdminNetworkConnection((LdapServer)PasswordPolicyIT.getLdapServer());
        Dn userDn = new Dn(new String[]{"cn=userMinAgeMustChange,ou=system"});
        DefaultEntry userEntry = new DefaultEntry(userDn.toString(), new Object[]{"ObjectClass: top", "ObjectClass: person", "cn: userMinAgeMustChange", "sn: userMinAgeMustChange_sn", "userPassword: 12345"});
        adminConnection.add((Entry)userEntry);
        LdapNetworkConnection userConnection = new LdapNetworkConnection("localhost", PasswordPolicyIT.getLdapServer().getPort());
        BindRequestImpl bindRequest = new BindRequestImpl();
        bindRequest.setDn(userDn);
        bindRequest.setCredentials("12345");
        bindRequest.addControl((Control)PP_REQ_CTRL);
        BindResponse bindResponse = userConnection.bind((BindRequest)bindRequest);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)bindResponse.getLdapResult().getResultCode());
        Assert.assertEquals((Object)PasswordPolicyErrorEnum.CHANGE_AFTER_RESET, (Object)this.getPwdRespCtrl((Response)bindResponse).getResponse().getPasswordPolicyError());
        ModifyRequestImpl modifyRequest = new ModifyRequestImpl();
        modifyRequest.setName(userDn);
        modifyRequest.replace("userPassword", new String[]{"123456"});
        modifyRequest.addControl((Control)PP_REQ_CTRL);
        ModifyResponse modifyResponse = userConnection.modify((ModifyRequest)modifyRequest);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)modifyResponse.getLdapResult().getResultCode());
        modifyRequest = new ModifyRequestImpl();
        modifyRequest.setName(userDn);
        modifyRequest.replace("userPassword", new String[]{"1234567"});
        modifyRequest.addControl((Control)PP_REQ_CTRL);
        modifyResponse = userConnection.modify((ModifyRequest)modifyRequest);
        Assert.assertEquals((Object)ResultCodeEnum.CONSTRAINT_VIOLATION, (Object)modifyResponse.getLdapResult().getResultCode());
        Assert.assertEquals((Object)PasswordPolicyErrorEnum.PASSWORD_TOO_YOUNG, (Object)this.getPwdRespCtrl((Response)modifyResponse).getResponse().getPasswordPolicyError());
        Thread.sleep(1000L);
        modifyResponse = userConnection.modify((ModifyRequest)modifyRequest);
        Assert.assertEquals((Object)ResultCodeEnum.SUCCESS, (Object)modifyResponse.getLdapResult().getResultCode());
        userConnection.close();
        adminConnection.close();
    }
}

