/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.search;

import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.shared.ldap.model.cursor.EntryCursor;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.message.SearchScope;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
public class SearchPerfIT
extends AbstractLdapTestUnit {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSearchRequestPerf() throws Exception {
        LdapNetworkConnection connection = new LdapNetworkConnection("localhost", SearchPerfIT.getLdapServer().getPort());
        try {
            connection.bind("uid=admin,ou=system", "secret");
            EntryCursor cursor = connection.search("uid=admin,ou=system", "(ObjectClass=*)", SearchScope.OBJECT, new String[]{"*"});
            int i = 0;
            while (cursor.next()) {
                cursor.get();
                ++i;
            }
            cursor.close();
            Assert.assertEquals((long)1L, (long)i);
            for (int j = 0; j < 10000; ++j) {
                cursor = connection.search("uid=admin,ou=system", "(ObjectClass=*)", SearchScope.OBJECT, new String[]{"*"});
                while (cursor.next()) {
                }
                cursor.close();
            }
            long t0 = System.currentTimeMillis();
            int nbIterations = 200000;
            for (int j = 0; j < nbIterations; ++j) {
                if (j % 10000 == 0) {
                    System.out.println(j);
                }
                cursor = connection.search("uid=admin,ou=system", "(ObjectClass=*)", SearchScope.OBJECT, new String[]{"*"});
                while (cursor.next()) {
                }
                cursor.close();
            }
            long t1 = System.currentTimeMillis();
            Long deltaWarmed = t1 - t0;
            System.out.println("Delta : " + deltaWarmed + "( " + (long)(nbIterations * 1000) / deltaWarmed + " per s ) /" + (t1 - t0));
        }
        catch (LdapException e) {
            e.printStackTrace();
            Assert.fail((String)"Should not have caught exception.");
        }
        finally {
            connection.unBind();
            connection.close();
        }
    }
}

