/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ssl;

import java.util.Hashtable;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.apache.directory.junit.tools.MultiThreadedMultiInvoker;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.annotations.SaslMechanism;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.ldap.handlers.bind.cramMD5.CramMd5MechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.digestMD5.DigestMd5MechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.gssapi.GssapiMechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.ntlm.NtlmMechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.plain.PlainMechanismHandler;
import org.apache.directory.server.ldap.handlers.extended.StoredProcedureExtendedOperationHandler;
import org.apache.directory.server.operations.bind.BogusNtlmProvider;
import org.apache.directory.server.ssl.SSLSocketFactory;
import org.apache.directory.shared.ldap.model.ldif.LdifUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateDS(allowAnonAccess=true, name="LdapsIT-class")
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP"), @CreateTransport(protocol="LDAPS")}, saslHost="localhost", saslMechanisms={@SaslMechanism(name="PLAIN", implClass=PlainMechanismHandler.class), @SaslMechanism(name="CRAM-MD5", implClass=CramMd5MechanismHandler.class), @SaslMechanism(name="DIGEST-MD5", implClass=DigestMd5MechanismHandler.class), @SaslMechanism(name="GSSAPI", implClass=GssapiMechanismHandler.class), @SaslMechanism(name="NTLM", implClass=NtlmMechanismHandler.class), @SaslMechanism(name="GSS-SPNEGO", implClass=NtlmMechanismHandler.class)}, extendedOpHandlers={StoredProcedureExtendedOperationHandler.class}, ntlmProvider=BogusNtlmProvider.class)
public class LdapsIT
extends AbstractLdapTestUnit {
    @Rule
    public MultiThreadedMultiInvoker i = new MultiThreadedMultiInvoker(false);
    private static final String RDN = "cn=The Person";

    private DirContext getSecureConnectionSystem() throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://localhost:" + LdapsIT.getLdapServer().getPortSSL() + "/ou=system");
        env.put("java.naming.ldap.factory.socket", SSLSocketFactory.class.getName());
        env.put("java.naming.security.principal", "uid=admin,ou=system");
        env.put("java.naming.security.credentials", "secret");
        env.put("java.naming.security.authentication", "simple");
        return new InitialDirContext(env);
    }

    @Test
    public void testLdaps() throws Exception {
        Attributes attributes = LdifUtils.createJndiAttributes((Object[])new Object[]{"objectClass: top", "objectClass: person", "cn: The Person", "sn: Person", "description: this is a person"});
        DirContext ctx = this.getSecureConnectionSystem();
        DirContext person = ctx.createSubcontext(RDN, attributes);
        Assert.assertNotNull((Object)person);
        person.close();
        ctx.destroySubcontext(RDN);
    }
}

