/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.modify;

import java.util.Arrays;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.directory.Attribute;
import javax.naming.directory.AttributeInUseException;
import javax.naming.directory.AttributeModificationException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.NoSuchAttributeException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.integ.ServerIntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.ldif.LdifUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@ApplyLdifs(value={"dn: cn=Tori Amos,ou=system", "objectClass: inetOrgPerson", "objectClass: organizationalPerson", "objectClass: person", "objectClass: top", "description: an American singer-songwriter", "cn: Tori Amos", "sn: Amos", "dn: cn=Debbie Harry,ou=system", "objectClass: inetOrgPerson", "objectClass: organizationalPerson", "objectClass: person", "objectClass: top", "cn: Debbie Harry", "sn: Harry"})
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
public class ModifyAddIT
extends AbstractLdapTestUnit {
    private static final String BASE = "ou=system";
    private static final String RDN_TORI_AMOS = "cn=Tori Amos";
    private static final String PERSON_DESCRIPTION = "an American singer-songwriter";
    private static final String RDN_DEBBIE_HARRY = "cn=Debbie Harry";

    protected Attributes getPersonAttributes(String sn, String cn) throws LdapException {
        Attributes attributes = LdifUtils.createJndiAttributes((Object[])new Object[]{"objectClass: top", "objectClass: person", "objectClass: organizationalperson", "objectClass: inetorgperson", "cn", cn, "sn", sn});
        return attributes;
    }

    @Test
    public void testAddNewAttributeValue() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyAddIT.getLdapServer()).lookup(BASE);
        String newValue = "1234567890";
        Attributes attrs = new BasicAttributes("telephoneNumber", newValue, true);
        ctx.modifyAttributes(RDN_TORI_AMOS, 1, attrs);
        attrs = ctx.getAttributes(RDN_TORI_AMOS);
        Attribute attr = attrs.get("telephoneNumber");
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((Object)"telephoneNumber", (Object)attr.getID());
        Assert.assertTrue((boolean)attr.contains(newValue));
        Assert.assertEquals((long)1L, (long)attr.size());
    }

    @Test
    public void testAddNewAttributeValues() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyAddIT.getLdapServer()).lookup(BASE);
        String[] newValues = new String[]{"1234567890", "999999999"};
        Attribute attr = new BasicAttribute("telephoneNumber");
        attr.add(newValues[0]);
        attr.add(newValues[1]);
        Attributes attrs = new BasicAttributes(true);
        attrs.put(attr);
        ctx.modifyAttributes(RDN_TORI_AMOS, 1, attrs);
        attrs = ctx.getAttributes(RDN_TORI_AMOS);
        attr = attrs.get("telephoneNumber");
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((Object)"telephoneNumber", (Object)attr.getID());
        Assert.assertTrue((boolean)attr.contains(newValues[0]));
        Assert.assertTrue((boolean)attr.contains(newValues[1]));
        Assert.assertEquals((long)newValues.length, (long)attr.size());
    }

    @Test
    public void testAddAdditionalAttributeValue() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyAddIT.getLdapServer()).lookup(BASE);
        String newValue = "A new description for this person";
        Assert.assertFalse((boolean)newValue.equals(PERSON_DESCRIPTION));
        Attributes attrs = new BasicAttributes("description", newValue, true);
        ctx.modifyAttributes(RDN_TORI_AMOS, 1, attrs);
        attrs = ctx.getAttributes(RDN_TORI_AMOS);
        Attribute attr = attrs.get("description");
        Assert.assertNotNull((Object)attr);
        Assert.assertTrue((boolean)attr.contains(newValue));
        Assert.assertTrue((boolean)attr.contains(PERSON_DESCRIPTION));
        Assert.assertEquals((long)2L, (long)attr.size());
    }

    @Test
    public void testAddExistingAttributeValue() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyAddIT.getLdapServer()).lookup(BASE);
        Attributes attrs = new BasicAttributes("description", PERSON_DESCRIPTION, true);
        try {
            ctx.modifyAttributes(RDN_TORI_AMOS, 1, attrs);
            Assert.fail((String)"Adding an already existing atribute value should fail.");
        }
        catch (AttributeInUseException e) {
            // empty catch block
        }
        attrs = ctx.getAttributes(RDN_TORI_AMOS);
        Attribute attr = attrs.get("description");
        Assert.assertNotNull((Object)attr);
        Assert.assertTrue((boolean)attr.contains(PERSON_DESCRIPTION));
        Assert.assertEquals((long)1L, (long)attr.size());
    }

    @Test
    public void testAddExistingNthAttributesDirServer664() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyAddIT.getLdapServer()).lookup(BASE);
        Attributes attrs = new BasicAttributes(true);
        attrs.put(new BasicAttribute("telephoneNumber", "1"));
        attrs.put(new BasicAttribute("telephoneNumber", "2"));
        attrs.put(new BasicAttribute("telephoneNumber", "3"));
        attrs.put(new BasicAttribute("telephoneNumber", "4"));
        attrs.put(new BasicAttribute("telephoneNumber", "5"));
        attrs.put(new BasicAttribute("telephoneNumber", "6"));
        attrs.put(new BasicAttribute("telephoneNumber", "7"));
        attrs.put(new BasicAttribute("telephoneNumber", "8"));
        attrs.put(new BasicAttribute("telephoneNumber", "9"));
        attrs.put(new BasicAttribute("telephoneNumber", "10"));
        attrs.put(new BasicAttribute("telephoneNumber", "11"));
        attrs.put(new BasicAttribute("telephoneNumber", "12"));
        attrs.put(new BasicAttribute("telephoneNumber", "13"));
        attrs.put(new BasicAttribute("telephoneNumber", "14"));
        Attribute attr = new BasicAttribute("description", PERSON_DESCRIPTION);
        attrs.put(attr);
        try {
            ctx.modifyAttributes(RDN_TORI_AMOS, 1, attrs);
            Assert.fail((String)"Adding an already existing atribute value should fail.");
        }
        catch (AttributeInUseException e) {
            // empty catch block
        }
        attrs = ctx.getAttributes(RDN_TORI_AMOS);
        attr = attrs.get("description");
        Assert.assertNotNull((Object)attr);
        Assert.assertTrue((boolean)attr.contains(PERSON_DESCRIPTION));
        Assert.assertEquals((long)1L, (long)attr.size());
    }

    @Test
    public void testTwoDescriptionDirServer643() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyAddIT.getLdapServer()).lookup(BASE);
        Attributes attrs = new BasicAttributes(true);
        Attribute attr = new BasicAttribute("description", "a British singer-songwriter with an expressive four-octave voice");
        attr.add("one of the most influential female artists of the twentieth century");
        attrs.put(attr);
        ctx.modifyAttributes(RDN_TORI_AMOS, 1, attrs);
        attrs = ctx.getAttributes(RDN_TORI_AMOS);
        attr = attrs.get("description");
        Assert.assertNotNull((Object)attr);
        Assert.assertEquals((long)3L, (long)attr.size());
        Assert.assertTrue((boolean)attr.contains("a British singer-songwriter with an expressive four-octave voice"));
        Assert.assertTrue((boolean)attr.contains("one of the most influential female artists of the twentieth century"));
        Assert.assertTrue((boolean)attr.contains(PERSON_DESCRIPTION));
    }

    @Test
    public void testAddDuplicateValueToExistingAttribute() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyAddIT.getLdapServer()).lookup(BASE);
        Attribute ocls = new BasicAttribute("objectClass", "organizationalPerson");
        ModificationItem[] modItems = new ModificationItem[]{new ModificationItem(1, ocls), new ModificationItem(1, ocls)};
        try {
            ctx.modifyAttributes(RDN_TORI_AMOS, modItems);
            Assert.fail((String)"Adding a duplicate attribute value should cause an error.");
        }
        catch (AttributeInUseException ex) {
            // empty catch block
        }
        Attributes attrs = ctx.getAttributes(RDN_TORI_AMOS);
        ocls = attrs.get("objectClass");
        Assert.assertEquals((long)ocls.size(), (long)4L);
        Assert.assertTrue((boolean)ocls.contains("top"));
        Assert.assertTrue((boolean)ocls.contains("person"));
    }

    @Test
    public void testAddDuplicateValueToNewAttribute() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyAddIT.getLdapServer()).lookup(BASE);
        BasicAttribute desc = new BasicAttribute("description", "another description value besides songwriter");
        ModificationItem[] modItems = new ModificationItem[]{new ModificationItem(1, desc), new ModificationItem(1, desc)};
        try {
            ctx.modifyAttributes(RDN_TORI_AMOS, modItems);
            Assert.fail((String)"Adding a duplicate attribute value should cause an error.");
        }
        catch (AttributeInUseException ex) {
            // empty catch block
        }
        Attributes attrs = ctx.getAttributes(RDN_TORI_AMOS);
        Assert.assertEquals((long)1L, (long)attrs.get("description").size());
    }

    @Test
    public void testSearchBadAttribute() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyAddIT.getLdapServer()).lookup(BASE);
        String newValue = "unbelievable";
        BasicAttributes attrs = new BasicAttributes("voice", newValue, true);
        try {
            ctx.modifyAttributes(RDN_TORI_AMOS, 1, (Attributes)attrs);
        }
        catch (NoSuchAttributeException nsae) {
            Assert.assertTrue((boolean)true);
            return;
        }
        Assert.fail((String)"Cannot reach this point");
    }

    @Test
    public void testAttributeValueMultiMofificationDIRSERVER_636() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyAddIT.getLdapServer()).lookup(BASE);
        Attributes attrs = this.getPersonAttributes("Bush", "Kate Bush");
        String rdn = "cn=Kate Bush";
        ctx.createSubcontext(rdn, attrs);
        String[] descriptions = new String[]{"Kate Bush is a British singer-songwriter.", "She has become one of the most influential female artists of the twentieth century."};
        BasicAttribute desc1 = new BasicAttribute("description");
        desc1.add(descriptions[0]);
        desc1.add(descriptions[1]);
        ModificationItem addModOp = new ModificationItem(1, desc1);
        BasicAttribute desc2 = new BasicAttribute("description");
        desc2.add(descriptions[1]);
        ModificationItem delModOp = new ModificationItem(3, desc2);
        ctx.modifyAttributes(rdn, new ModificationItem[]{addModOp, delModOp});
        SearchControls sctls = new SearchControls();
        sctls.setSearchScope(2);
        String filter = "(cn=*Bush)";
        String base = "";
        NamingEnumeration<SearchResult> enm = ctx.search(base, filter, sctls);
        Assert.assertTrue((boolean)enm.hasMore());
        while (enm.hasMore()) {
            SearchResult sr = enm.next();
            attrs = sr.getAttributes();
            Attribute desc = sr.getAttributes().get("description");
            Assert.assertEquals((long)1L, (long)desc.size());
            Assert.assertTrue((boolean)desc.contains(descriptions[0]));
        }
        ctx.destroySubcontext(rdn);
    }

    @Test
    public void testModifyOperationalAttributeAdd() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyAddIT.getLdapServer()).lookup(BASE);
        ModificationItem modifyOp = new ModificationItem(1, new BasicAttribute("subschemaSubentry", "cn=anotherSchema"));
        try {
            ctx.modifyAttributes(RDN_DEBBIE_HARRY, new ModificationItem[]{modifyOp});
            Assert.fail((String)"modification of entry should fail");
        }
        catch (InvalidAttributeValueException e) {
        }
        catch (NoPermissionException noPermissionException) {
            // empty catch block
        }
    }

    @Test
    public void testDNAttributeMemberModificationDIRSERVER_687() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyAddIT.getLdapServer()).lookup(BASE);
        Attributes attrs = this.getPersonAttributes("Bush", "Kate Bush");
        String rdn = "cn=Kate Bush";
        ctx.createSubcontext(rdn, attrs);
        BasicAttribute desc1 = new BasicAttribute("cn", "Georges Bush");
        ModificationItem addModOp = new ModificationItem(2, desc1);
        try {
            ctx.modifyAttributes(rdn, new ModificationItem[]{addModOp});
            Assert.fail();
        }
        catch (AttributeModificationException ame) {
            Assert.assertTrue((boolean)true);
            ctx.destroySubcontext(rdn);
        }
        catch (NamingException ne) {
            Assert.assertTrue((boolean)true);
            ctx.destroySubcontext(rdn);
        }
    }

    @Test
    public void testModifyAddWithInvalidNumberOfAttributeValues() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyAddIT.getLdapServer()).lookup(BASE);
        BasicAttributes attrs = new BasicAttributes(true);
        BasicAttribute ocls = new BasicAttribute("objectClass");
        ocls.add("top");
        ocls.add("inetOrgPerson");
        attrs.put(ocls);
        attrs.put("cn", "Fiona Apple");
        attrs.put("sn", "Apple");
        ctx.createSubcontext("cn=Fiona Apple", (Attributes)attrs);
        attrs = new BasicAttributes(true);
        BasicAttribute displayName = new BasicAttribute("displayName");
        displayName.add("Fiona");
        displayName.add("Fiona A.");
        attrs.put(displayName);
        try {
            ctx.modifyAttributes("cn=Fiona Apple", 1, (Attributes)attrs);
            Assert.fail((String)"modification of entry should fail");
        }
        catch (InvalidAttributeValueException e) {
            // empty catch block
        }
    }

    @Test
    public void testAddNewBinaryAttributeValue() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyAddIT.getLdapServer()).lookup(BASE);
        byte[] newValue = new byte[]{0, 1, 2, 3};
        Attributes attrs = new BasicAttributes("userCertificate;binary", newValue, true);
        ctx.modifyAttributes(RDN_TORI_AMOS, 1, attrs);
        attrs = ctx.getAttributes(RDN_TORI_AMOS);
        Attribute attr = attrs.get("userCertificate");
        Assert.assertNotNull((Object)attr);
        Assert.assertTrue((boolean)attr.contains(newValue));
        byte[] certificate = (byte[])attr.get();
        Assert.assertTrue((boolean)Arrays.equals(newValue, certificate));
        Assert.assertEquals((long)1L, (long)attr.size());
    }

    @Test
    public void testAddNewBinaryAttributeValueAbove0x80() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyAddIT.getLdapServer()).lookup(BASE);
        byte[] newValue = new byte[]{-128, -127, -126, -125};
        Attributes attrs = new BasicAttributes("userCertificate;binary", newValue, true);
        ctx.modifyAttributes(RDN_TORI_AMOS, 1, attrs);
        attrs = ctx.getAttributes(RDN_TORI_AMOS);
        Attribute attr = attrs.get("userCertificate");
        Assert.assertNotNull((Object)attr);
        Assert.assertTrue((boolean)attr.contains(newValue));
        byte[] certificate = (byte[])attr.get();
        Assert.assertTrue((boolean)Arrays.equals(newValue, certificate));
        Assert.assertEquals((long)1L, (long)attr.size());
    }

    @Test
    public void testRetrieveEntryWithBinaryAttributeValue() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyAddIT.getLdapServer()).lookup(BASE);
        byte[] newValue = new byte[]{0, 1, 2, 3};
        Attributes attrs = new BasicAttributes("userCertificate;binary", newValue);
        ctx.modifyAttributes(RDN_TORI_AMOS, 1, attrs);
        SearchControls sctls = new SearchControls();
        sctls.setSearchScope(0);
        sctls.setReturningAttributes(new String[]{"userCertificate;binary"});
        String filter = "(objectClass=*)";
        String base = RDN_TORI_AMOS;
        NamingEnumeration<SearchResult> enm = ctx.search(base, filter, sctls);
        Assert.assertTrue((boolean)enm.hasMore());
        while (enm.hasMore()) {
            SearchResult sr = enm.next();
            attrs = sr.getAttributes();
            Attribute attr = attrs.get("userCertificate");
            Assert.assertNotNull((Object)attr);
            Assert.assertTrue((boolean)attr.contains(newValue));
            byte[] certificate = (byte[])attr.get();
            Assert.assertTrue((boolean)Arrays.equals(newValue, certificate));
            Assert.assertEquals((long)1L, (long)attr.size());
        }
    }

    public void testAddNewBinaryAttributeValue0x80() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)ModifyAddIT.getLdapServer()).lookup(BASE);
        byte[] newValue = new byte[]{-128, -127, -126, -125};
        Attributes attrs = new BasicAttributes("userCertificate;binary", newValue);
        ctx.modifyAttributes(RDN_TORI_AMOS, 1, attrs);
        attrs = ctx.getAttributes(RDN_TORI_AMOS);
        Attribute attr = attrs.get("userCertificate");
        Assert.assertNotNull((Object)attr);
        Assert.assertTrue((boolean)attr.contains(newValue));
        byte[] certificate = (byte[])attr.get();
        Assert.assertTrue((boolean)Arrays.equals(newValue, certificate));
        Assert.assertEquals((long)1L, (long)attr.size());
    }
}

