/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.ldapsdk;

import javax.naming.NameNotFoundException;
import javax.naming.ReferralException;
import javax.naming.ldap.LdapContext;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPResponse;
import netscape.ldap.LDAPResponseListener;
import netscape.ldap.LDAPSearchConstraints;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.integ.ServerIntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.shared.ldap.model.exception.LdapContextNotEmptyException;
import org.apache.directory.shared.ldap.model.exception.LdapNoSuchObjectException;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
@ApplyLdifs(value={"dn: uid=akarasulu,ou=users,ou=system", "objectClass: uidObject", "objectClass: person", "objectClass: top", "uid: akarasulu", "cn: Alex Karasulu", "sn: karasulu", "dn: ou=Computers,uid=akarasulu,ou=users,ou=system", "objectClass: organizationalUnit", "objectClass: top", "ou: computers", "description: Computers for Alex", "seeAlso: ou=Machines,uid=akarasulu,ou=users,ou=system", "dn: uid=akarasuluref,ou=users,ou=system", "objectClass: uidObject", "objectClass: referral", "objectClass: top", "uid: akarasuluref", "ref: ldap://localhost:10389/uid=akarasulu,ou=users,ou=system", "ref: ldap://foo:10389/uid=akarasulu,ou=users,ou=system", "ref: ldap://bar:10389/uid=akarasulu,ou=users,ou=system"})
public class DeleteIT
extends AbstractLdapTestUnit {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteIT.class);

    @Test
    public void testNormalDeleteFailContextNotEmpty() throws Exception {
        LdapConnection conn = ServerIntegrationUtils.getAdminConnection((LdapServer)DeleteIT.getLdapServer());
        try {
            conn.delete("uid=akarasulu,ou=users,ou=system");
            Assert.fail();
        }
        catch (LdapContextNotEmptyException lcnee) {
            Assert.assertTrue((boolean)true);
        }
        conn.unBind();
        conn.close();
    }

    @Test
    public void testNormalDelete() throws Exception {
        LdapConnection conn = ServerIntegrationUtils.getAdminConnection((LdapServer)DeleteIT.getLdapServer());
        conn.delete("ou=computers,uid=akarasulu,ou=users,ou=system");
        try {
            conn.delete("uid=elecharny,ou=users,ou=system");
            Assert.fail();
        }
        catch (LdapNoSuchObjectException lnsoe) {
            Assert.assertTrue((boolean)true);
        }
        conn.unBind();
        conn.close();
    }

    @Test
    public void testDeleteNonExistent() throws Exception {
        LdapConnection conn = ServerIntegrationUtils.getAdminConnection((LdapServer)DeleteIT.getLdapServer());
        try {
            conn.delete("uid=elecharny,ou=users,ou=system");
            Assert.fail();
        }
        catch (LdapNoSuchObjectException lnsoe) {
            Assert.assertTrue((boolean)true);
        }
        conn.unBind();
        conn.close();
    }

    @Test
    public void testOnReferralWithManageDsaITControl() throws Exception {
        LDAPConnection conn = ServerIntegrationUtils.getNsdkWiredConnection((LdapServer)DeleteIT.getLdapServer());
        LDAPSearchConstraints constraints = new LDAPSearchConstraints();
        constraints.setClientControls(new LDAPControl("2.16.840.1.113730.3.4.2", true, new byte[0]));
        constraints.setServerControls(new LDAPControl("2.16.840.1.113730.3.4.2", true, new byte[0]));
        conn.setConstraints((LDAPConstraints)constraints);
        conn.delete("uid=akarasuluref,ou=users,ou=system", (LDAPConstraints)constraints);
        try {
            conn.read("uid=akarasuluref,ou=users,ou=system", constraints);
            Assert.fail((String)"Should never get here.");
        }
        catch (LDAPException e) {
            Assert.assertEquals((long)ResultCodeEnum.NO_SUCH_OBJECT.getValue(), (long)e.getLDAPResultCode());
        }
        conn.disconnect();
    }

    @Test
    public void testOnReferral() throws Exception {
        LDAPConnection conn = ServerIntegrationUtils.getNsdkWiredConnection((LdapServer)DeleteIT.getLdapServer());
        LDAPConstraints constraints = new LDAPConstraints();
        constraints.setReferrals(false);
        conn.setConstraints(constraints);
        LDAPResponseListener listener = null;
        LDAPResponse response = null;
        listener = conn.delete("uid=akarasuluref,ou=users,ou=system", null, constraints);
        response = listener.getResponse();
        Assert.assertEquals((long)ResultCodeEnum.REFERRAL.getValue(), (long)response.getResultCode());
        Assert.assertEquals((Object)"ldap://localhost:10389/uid=akarasulu,ou=users,ou=system", (Object)response.getReferrals()[0]);
        Assert.assertEquals((Object)"ldap://foo:10389/uid=akarasulu,ou=users,ou=system", (Object)response.getReferrals()[1]);
        Assert.assertEquals((Object)"ldap://bar:10389/uid=akarasulu,ou=users,ou=system", (Object)response.getReferrals()[2]);
        conn.disconnect();
    }

    @Test
    public void testThrowOnReferralWithJndi() throws Exception {
        LdapContext ctx = ServerIntegrationUtils.getWiredContextThrowOnRefferal((LdapServer)DeleteIT.getLdapServer());
        ctx.destroySubcontext("ou=computers,uid=akarasulu,ou=users,ou=system");
        try {
            ctx.lookup("ou=computers,uid=akarasulu,ou=users,ou=system");
            Assert.fail((String)"Should never get here.");
        }
        catch (NameNotFoundException e) {
            // empty catch block
        }
        try {
            ctx.destroySubcontext("uid=akarasuluref,ou=users,ou=system");
            Assert.fail((String)"Should never get here");
        }
        catch (ReferralException e) {
            Assert.assertEquals((Object)"ldap://localhost:10389/uid=akarasulu,ou=users,ou=system", (Object)e.getReferralInfo());
        }
        ctx.close();
    }

    @Test
    public void testAncestorReferral() throws Exception {
        LOG.debug("");
        LDAPConnection conn = ServerIntegrationUtils.getNsdkWiredConnection((LdapServer)DeleteIT.getLdapServer());
        LDAPConstraints constraints = new LDAPConstraints();
        conn.setConstraints(constraints);
        LDAPResponseListener listener = null;
        LDAPResponse response = null;
        listener = conn.delete("ou=Computers,uid=akarasuluref,ou=users,ou=system", null, constraints);
        response = listener.getResponse();
        Assert.assertEquals((long)ResultCodeEnum.REFERRAL.getValue(), (long)response.getResultCode());
        Assert.assertEquals((Object)"ldap://localhost:10389/ou=Computers,uid=akarasulu,ou=users,ou=system", (Object)response.getReferrals()[0]);
        Assert.assertEquals((Object)"ldap://foo:10389/ou=Computers,uid=akarasulu,ou=users,ou=system", (Object)response.getReferrals()[1]);
        Assert.assertEquals((Object)"ldap://bar:10389/ou=Computers,uid=akarasulu,ou=users,ou=system", (Object)response.getReferrals()[2]);
        conn.disconnect();
    }

    @Test
    public void testDeleteWithIllegalName() throws Exception {
        LdapConnection conn = ServerIntegrationUtils.getAdminConnection((LdapServer)DeleteIT.getLdapServer());
        try {
            conn.delete("This is an illegal name,dc=example,dc=com");
            Assert.fail((String)"deletion should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
        conn.close();
    }
}

