/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.lookup;

import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.integ.ServerIntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
public class LookupIT
extends AbstractLdapTestUnit {
    @Test
    public void testLookupPerfAPI() throws Exception {
        LdapConnection connection = ServerIntegrationUtils.getAdminConnection((LdapServer)LookupIT.getLdapServer());
        Entry entry = connection.lookup("uid=admin,ou=system", new String[]{"name"});
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((long)2L, (long)entry.size());
        Assert.assertTrue((boolean)entry.containsAttribute(new String[]{"cn", "sn"}));
        Assert.assertTrue((boolean)entry.contains("cn", new String[]{"system administrator"}));
        Assert.assertTrue((boolean)entry.contains("sn", new String[]{"administrator"}));
        connection.close();
    }
}

