/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ssl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.HashSet;
import java.util.Hashtable;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import org.apache.directory.junit.tools.MultiThreadedMultiInvoker;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.integ.ServerIntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.handlers.extended.StartTlsHandler;
import org.apache.directory.server.ssl.ReloadableSSLSocketFactory;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=FrameworkRunner.class)
@CreateDS(allowAnonAccess=true, name="StartTlsConfidentialityIT-class")
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP"), @CreateTransport(protocol="LDAPS")}, extendedOpHandlers={StartTlsHandler.class})
public class StartTlsConfidentialityIT
extends AbstractLdapTestUnit {
    @Rule
    public MultiThreadedMultiInvoker i = new MultiThreadedMultiInvoker(false);
    private static final Logger LOG = LoggerFactory.getLogger(StartTlsConfidentialityIT.class);
    private static final String[] CERT_IDS = new String[]{"userCertificate"};
    private File ksFile;
    boolean oldConfidentialityRequiredValue;

    @Before
    public void installKeyStoreWithCertificate() throws Exception {
        if (this.ksFile != null && this.ksFile.exists()) {
            this.ksFile.delete();
        }
        this.ksFile = File.createTempFile("testStore", "ks");
        CoreSession session = StartTlsConfidentialityIT.getLdapServer().getDirectoryService().getAdminSession();
        Entry entry = session.lookup(new Dn(new String[]{"uid=admin,ou=system"}), CERT_IDS);
        byte[] userCertificate = entry.get(CERT_IDS[0]).getBytes();
        Assert.assertNotNull((Object)userCertificate);
        ByteArrayInputStream in = new ByteArrayInputStream(userCertificate);
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        Certificate cert = factory.generateCertificate(in);
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(null, null);
        ks.setCertificateEntry("apacheds", cert);
        ks.store(new FileOutputStream(this.ksFile), "changeit".toCharArray());
        LOG.debug("Keystore file installed: {}", (Object)this.ksFile.getAbsolutePath());
        this.oldConfidentialityRequiredValue = StartTlsConfidentialityIT.getLdapServer().isConfidentialityRequired();
    }

    @After
    public void deleteKeyStore() throws Exception {
        if (this.ksFile != null && this.ksFile.exists()) {
            this.ksFile.delete();
        }
        LOG.debug("Keystore file deleted: {}", (Object)this.ksFile.getAbsolutePath());
        StartTlsConfidentialityIT.getLdapServer().setConfidentialityRequired(this.oldConfidentialityRequiredValue);
    }

    private LdapContext getSecuredContext() throws Exception {
        System.setProperty("javax.net.ssl.trustStore", this.ksFile.getAbsolutePath());
        System.setProperty("javax.net.ssl.keyStore", this.ksFile.getAbsolutePath());
        System.setProperty("javax.net.ssl.keyStorePassword", "changeit");
        LOG.debug("testStartTls() test starting ... ");
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://localhost:" + StartTlsConfidentialityIT.getLdapServer().getPort());
        LOG.debug("About to get initial context");
        InitialLdapContext ctx = new InitialLdapContext(env, null);
        LOG.debug("About send startTls extended operation");
        StartTlsResponse tls = (StartTlsResponse)ctx.extendedOperation(new StartTlsRequest());
        LOG.debug("Extended operation issued");
        tls.setHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
        LOG.debug("TLS negotion about to begin");
        tls.negotiate(ReloadableSSLSocketFactory.getDefault());
        return ctx;
    }

    @Test
    public void testConfidentiality() throws Exception {
        StartTlsConfidentialityIT.getLdapServer().setConfidentialityRequired(true);
        try {
            ServerIntegrationUtils.getWiredContext((LdapServer)StartTlsConfidentialityIT.getLdapServer());
            Assert.fail((String)"Should not get here due to violation of confidentiality requirements");
        }
        catch (AuthenticationNotSupportedException e) {
            // empty catch block
        }
        LdapContext ctx = this.getSecuredContext();
        Assert.assertNotNull((Object)ctx);
        ctx.addToEnvironment("java.naming.security.principal", "uid=admin,ou=system");
        ctx.addToEnvironment("java.naming.security.credentials", "secret");
        ctx.addToEnvironment("java.naming.security.authentication", "simple");
        ctx.reconnect(null);
        NamingEnumeration<SearchResult> results = ctx.search("ou=system", "(objectClass=*)", new SearchControls());
        HashSet<String> names = new HashSet<String>();
        while (results.hasMore()) {
            names.add(results.next().getName());
        }
        results.close();
        Assert.assertTrue((boolean)names.contains("prefNodeName=sysPrefRoot"));
        Assert.assertTrue((boolean)names.contains("ou=users"));
        Assert.assertTrue((boolean)names.contains("ou=configuration"));
        Assert.assertTrue((boolean)names.contains("uid=admin"));
        Assert.assertTrue((boolean)names.contains("ou=groups"));
        BasicAttributes attrs = new BasicAttributes("objectClass", "person", true);
        attrs.put("sn", "foo");
        attrs.put("cn", "foo bar");
        ctx.createSubcontext("cn=foo bar,ou=system", (Attributes)attrs);
        Assert.assertNotNull((Object)ctx.lookup("cn=foo bar,ou=system"));
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(1, new BasicAttribute("cn", "fbar"))};
        ctx.modifyAttributes("cn=foo bar,ou=system", mods);
        Attributes reread = ctx.getAttributes("cn=foo bar,ou=system");
        Assert.assertTrue((boolean)reread.get("cn").contains("fbar"));
        ctx.rename("cn=foo bar,ou=system", "cn=fbar,ou=system");
        try {
            ctx.getAttributes("cn=foo bar,ou=system");
            Assert.fail((String)"old name of renamed entry should not be found");
        }
        catch (NameNotFoundException e) {
            // empty catch block
        }
        reread = ctx.getAttributes("cn=fbar,ou=system");
        Assert.assertTrue((boolean)reread.get("cn").contains("fbar"));
        ctx.destroySubcontext("cn=fbar,ou=system");
        try {
            ctx.getAttributes("cn=fbar,ou=system");
            Assert.fail((String)"deleted entry should not be found");
        }
        catch (NameNotFoundException e) {
            // empty catch block
        }
        ctx.close();
    }
}

