/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.core.integ.IntegrationUtils;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.ObjectClass;
import org.apache.directory.shared.ldap.model.schema.parsers.AttributeTypeDescriptionSchemaParser;
import org.apache.directory.shared.ldap.model.schema.parsers.ObjectClassDescriptionSchemaParser;
import org.apache.directory.shared.ldap.util.JndiUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateDS(name="SchemaIT-class")
public class SchemaIT
extends AbstractLdapTestUnit {
    private static final String SUBSCHEMA_SUBENTRY = "subschemaSubentry";
    private static final AttributeTypeDescriptionSchemaParser ATTRIBUTE_TYPE_DESCRIPTION_SCHEMA_PARSER = new AttributeTypeDescriptionSchemaParser();
    private static final ObjectClassDescriptionSchemaParser OBJECT_CLASS_DESCRIPTION_SCHEMA_PARSER = new ObjectClassDescriptionSchemaParser();

    @Test
    @CreateDS(name="SchemaAddAT-test")
    @ApplyLdifs(value={"dn: m-oid=1.3.6.1.4.1.18060.0.4.1.2.999,ou=attributeTypes,cn=other,ou=schema", "m-usage: USER_APPLICATIONS", "m-equality: integerOrderingMatch", "objectClass: metaAttributeType", "objectClass: metaTop", "objectClass: top", "m-name: numberOfGuns", "m-oid: 1.3.6.1.4.1.18060.0.4.1.2.999", "m-singleValue: TRUE", "m-description: Number of guns of a ship", "m-collective: FALSE", "m-obsolete: FALSE", "m-noUserModification: FALSE", "m-syntax: 1.3.6.1.4.1.1466.115.121.1.27", "dn: m-oid=1.3.6.1.4.1.18060.0.4.1.1.999,ou=objectClasses,cn=other,ou=schema", "objectClass: top", "objectClass: metaTop", "objectClass: metaObjectclass", "m-supObjectClass: top", "m-oid: 1.3.6.1.4.1.18060.0.4.1.2.999", "m-name: ship", "m-must: cn", "m-may: numberOfGuns", "m-may: description", "m-typeObjectClass: STRUCTURAL", "m-obsolete: FALSE", "m-description: A ship"})
    public void testAddAttributeTypeObjectClass() throws Exception {
        this.checkAttributeTypePresent("1.3.6.1.4.1.18060.0.4.1.2.999", "other", true);
        this.checkObjectClassPresent("1.3.6.1.4.1.18060.0.4.1.1.999", "other", true);
        SchemaIT.getService().sync();
        SchemaIT.getService().shutdown();
        SchemaIT.getService().startup();
        this.checkAttributeTypePresent("1.3.6.1.4.1.18060.0.4.1.2.999", "other", true);
        this.checkObjectClassPresent("1.3.6.1.4.1.18060.0.4.1.1.999", "other", true);
    }

    @Test
    @CreateDS(name="SchemaAddAT-test")
    @ApplyLdifs(value={"dn: cn=schema", "changetype: modify", "add: attributeTypes", "attributeTypes: ( 1.3.6.1.4.1.65536.0.4.3.2.1 NAME 'templateData' DESC 'template data' SYNTAX 1.3.6.1.4.1.1466.115.121.1.5 SINGLE-VALUE X-SCHEMA 'other' )", "-", "dn: cn=schema", "changetype: modify", "add: objectClasses", "objectClasses: ( 1.3.6.1.4.1.65536.0.4.3.2.2 NAME 'templateObject' DESC 'test OC' SUP top STRUCTURAL MUST ( templateData $ cn ) X-SCHEMA 'other' )", "-"})
    public void testAddAttributeTypeObjectClassSubSchemaSubEntry() throws Exception {
        this.checkAttributeTypePresent("1.3.6.1.4.1.65536.0.4.3.2.1", "other", true);
        this.checkObjectClassPresent("1.3.6.1.4.1.65536.0.4.3.2.2", "other", true);
        SchemaIT.getService().sync();
        SchemaIT.getService().shutdown();
        SchemaIT.getService().startup();
        this.checkAttributeTypePresent("1.3.6.1.4.1.65536.0.4.3.2.1", "other", true);
        this.checkObjectClassPresent("1.3.6.1.4.1.65536.0.4.3.2.2", "other", true);
    }

    @Test
    public void testAddBinaryAttributeType() throws Exception {
        ArrayList<String> descriptions = new ArrayList<String>();
        descriptions.add("( 1.3.6.1.4.1.65536.0.4.3.2.1 NAME 'templateData' DESC 'template data' SYNTAX 1.3.6.1.4.1.1466.115.121.1.5 SINGLE-VALUE X-SCHEMA 'other' )");
        this.modify(1, descriptions, "attributeTypes");
        descriptions.clear();
        descriptions.add("( 1.3.6.1.4.1.65536.0.4.3.2.2  NAME 'templateObject'  DESC 'test OC'  SUP top  STRUCTURAL  MUST ( templateData $ cn )  X-SCHEMA 'other' )");
        this.modify(1, descriptions, "objectClasses");
        this.checkAttributeTypePresent("1.3.6.1.4.1.65536.0.4.3.2.1", "other", true);
        this.checkObjectClassPresent("1.3.6.1.4.1.65536.0.4.3.2.2", "other", true);
        SchemaIT.getService().sync();
        SchemaIT.getService().shutdown();
        SchemaIT.getService().startup();
        this.checkAttributeTypePresent("1.3.6.1.4.1.65536.0.4.3.2.1", "other", true);
        this.checkObjectClassPresent("1.3.6.1.4.1.65536.0.4.3.2.2", "other", true);
        BasicAttributes attrs = new BasicAttributes();
        BasicAttribute ocattr = new BasicAttribute("objectclass");
        ocattr.add("top");
        ocattr.add("templateObject");
        attrs.put(ocattr);
        byte[] templateData = new byte[4096];
        attrs.put("templateData", templateData);
        attrs.put("cn", "atemplate");
        IntegrationUtils.getRootContext((DirectoryService)SchemaIT.getService()).bind("cn=atemplate,ou=system", null, (Attributes)attrs);
        Attributes data = IntegrationUtils.getRootContext((DirectoryService)SchemaIT.getService()).getAttributes("cn=atemplate,ou=system", new String[]{"templateData", "cn"});
        Assert.assertTrue((boolean)Arrays.equals(templateData, (byte[])data.get("templateData").get()));
    }

    private void modify(int op, List<String> descriptions, String opAttr) throws Exception {
        Dn dn = new Dn(new String[]{this.getSubschemaSubentryDN()});
        BasicAttribute attr = new BasicAttribute(opAttr);
        for (String description : descriptions) {
            attr.add(description);
        }
        BasicAttributes mods = new BasicAttributes(true);
        mods.put(attr);
        IntegrationUtils.getRootContext((DirectoryService)SchemaIT.getService()).modifyAttributes(JndiUtils.toName((Dn)dn), op, (Attributes)mods);
    }

    private String getSubschemaSubentryDN() throws Exception {
        SearchControls controls = new SearchControls();
        controls.setSearchScope(0);
        controls.setReturningAttributes(new String[]{SUBSCHEMA_SUBENTRY});
        NamingEnumeration<SearchResult> results = IntegrationUtils.getRootContext((DirectoryService)SchemaIT.getService()).search("", "(objectClass=*)", controls);
        SearchResult result = results.next();
        results.close();
        Attribute subschemaSubentry = result.getAttributes().get(SUBSCHEMA_SUBENTRY);
        return (String)subschemaSubentry.get();
    }

    private Attributes getSubschemaSubentryAttributes() throws Exception {
        SearchControls controls = new SearchControls();
        controls.setSearchScope(0);
        controls.setReturningAttributes(new String[]{"+", "*"});
        NamingEnumeration<SearchResult> results = IntegrationUtils.getRootContext((DirectoryService)SchemaIT.getService()).search(this.getSubschemaSubentryDN(), "(objectClass=*)", controls);
        SearchResult result = results.next();
        results.close();
        return result.getAttributes();
    }

    private void checkAttributeTypePresent(String oid, String schemaName, boolean isPresent) throws Exception {
        Attributes attrs = this.getSubschemaSubentryAttributes();
        Attribute attrTypes = attrs.get("attributeTypes");
        AttributeType attributeType = null;
        for (int i = 0; i < attrTypes.size(); ++i) {
            String desc = (String)attrTypes.get(i);
            if (desc.indexOf(oid) == -1) continue;
            attributeType = ATTRIBUTE_TYPE_DESCRIPTION_SCHEMA_PARSER.parseAttributeTypeDescription(desc);
            break;
        }
        if (isPresent) {
            Assert.assertNotNull(attributeType);
            Assert.assertEquals((Object)oid, (Object)attributeType.getOid());
        } else {
            Assert.assertNull(attributeType);
        }
        attrs = null;
        if (isPresent) {
            attrs = IntegrationUtils.getSchemaContext((DirectoryService)SchemaIT.getService()).getAttributes("m-oid=" + oid + ",ou=attributeTypes,cn=" + schemaName);
            Assert.assertNotNull((Object)attrs);
        } else {
            try {
                attrs = IntegrationUtils.getSchemaContext((DirectoryService)SchemaIT.getService()).getAttributes("m-oid=" + oid + ",ou=attributeTypes,cn=" + schemaName);
                Assert.fail((String)"should never get here");
            }
            catch (NamingException e) {
                // empty catch block
            }
            Assert.assertNull((Object)attrs);
        }
        if (isPresent) {
            Assert.assertTrue((boolean)SchemaIT.getService().getSchemaManager().getAttributeTypeRegistry().contains(oid));
        } else {
            Assert.assertFalse((boolean)SchemaIT.getService().getSchemaManager().getAttributeTypeRegistry().contains(oid));
        }
    }

    private void checkObjectClassPresent(String oid, String schemaName, boolean isPresent) throws Exception {
        Attributes attrs = this.getSubschemaSubentryAttributes();
        Attribute attrTypes = attrs.get("objectClasses");
        ObjectClass objectClass = null;
        for (int i = 0; i < attrTypes.size(); ++i) {
            String desc = (String)attrTypes.get(i);
            if (desc.indexOf(oid) == -1) continue;
            objectClass = OBJECT_CLASS_DESCRIPTION_SCHEMA_PARSER.parseObjectClassDescription(desc);
            break;
        }
        if (isPresent) {
            Assert.assertNotNull(objectClass);
            Assert.assertEquals((Object)oid, (Object)objectClass.getOid());
        } else {
            Assert.assertNull(objectClass);
        }
        attrs = null;
        if (isPresent) {
            attrs = IntegrationUtils.getSchemaContext((DirectoryService)SchemaIT.getService()).getAttributes("m-oid=" + oid + ",ou=objectClasses,cn=" + schemaName);
            Assert.assertNotNull((Object)attrs);
        } else {
            try {
                attrs = IntegrationUtils.getSchemaContext((DirectoryService)SchemaIT.getService()).getAttributes("m-oid=" + oid + ",ou=objectClasses,cn=" + schemaName);
                Assert.fail((String)"should never get here");
            }
            catch (NamingException e) {
                // empty catch block
            }
            Assert.assertNull((Object)attrs);
        }
        if (isPresent) {
            Assert.assertTrue((boolean)SchemaIT.getService().getSchemaManager().getObjectClassRegistry().contains(oid));
        } else {
            Assert.assertFalse((boolean)SchemaIT.getService().getSchemaManager().getObjectClassRegistry().contains(oid));
        }
    }
}

