/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.compare;

import javax.naming.NamingEnumeration;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.directory.junit.tools.MultiThreadedMultiInvoker;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.integ.ServerIntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.shared.util.Strings;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
@ApplyLdifs(value={"dn: cn=Tori Amos,ou=system", "objectClass: person", "objectClass: top", "telephoneNumber: 1234567890", "userPassword: Secret1!", "cn: Tori Amos", "sn: Amos", "dn: cn=Artists,ou=system", "objectClass: groupOfNames", "objectClass: top", "cn: Artists", "member: cn=Tori Amos,ou=system"})
public class MatchingRuleCompareIT
extends AbstractLdapTestUnit {
    @Rule
    public MultiThreadedMultiInvoker i = new MultiThreadedMultiInvoker(false);
    public static final String PERSON_CN = "Tori Amos";
    public static final String PERSON_SN = "Amos";
    public static final String PERSON_RDN = "cn=Tori Amos";
    public static final String PERSON_TELEPHONE = "1234567890";
    public static final String PERSON_PWD = "Secret1!";
    public static final String GROUP_CN = "Artists";
    public static final String GROUP_RDN = "cn=Artists";

    @Test
    public void testCaseIgnoreMatch() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)MatchingRuleCompareIT.getLdapServer()).lookup("ou=system");
        SearchControls ctls = new SearchControls();
        ctls.setReturningAttributes(new String[0]);
        ctls.setSearchScope(0);
        String[] values = new String[]{PERSON_SN, PERSON_SN.toUpperCase(), Strings.toLowerCase((String)PERSON_SN), "AmosX"};
        boolean[] expected = new boolean[]{true, true, true, false};
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            NamingEnumeration<SearchResult> enumeration = ctx.search(PERSON_RDN, "sn={0}", (Object[])new String[]{value}, ctls);
            boolean result = enumeration.hasMore();
            Assert.assertEquals((String)("compare sn value 'Amos' with '" + value + "'"), (Object)expected[i], (Object)result);
            enumeration.close();
        }
    }

    @Test
    public void testDistinguishedNameMatch() throws Exception {
        DirContext ctx = (DirContext)ServerIntegrationUtils.getWiredContext((LdapServer)MatchingRuleCompareIT.getLdapServer()).lookup("ou=system");
        DirContext member = (DirContext)ctx.lookup(PERSON_RDN);
        String memberDN = member.getNameInNamespace();
        SearchControls ctls = new SearchControls();
        ctls.setReturningAttributes(new String[0]);
        ctls.setSearchScope(0);
        String[] values = new String[]{"", memberDN, "cn=nobody", memberDN, "cn=Tori Amos , " + ctx.getNameInNamespace()};
        boolean[] expected = new boolean[]{false, true, false, true, true};
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            NamingEnumeration<SearchResult> enumeration = ctx.search(GROUP_RDN, "member={0}", new Object[]{value}, ctls);
            boolean result = enumeration.hasMore();
            Assert.assertEquals((String)("compare '" + memberDN + "' with '" + value + "'"), (Object)expected[i], (Object)result);
            enumeration.close();
        }
    }
}

