/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.ldapsdk;

import javax.naming.NamingEnumeration;
import javax.naming.ReferralException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPResponse;
import netscape.ldap.LDAPResponseListener;
import org.apache.directory.junit.tools.MultiThreadedMultiInvoker;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.integ.ServerIntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
@ApplyLdifs(value={"dn: uid=akarasulu,ou=users,ou=system", "objectClass: uidObject", "objectClass: person", "objectClass: top", "uid: akarasulu", "cn: Alex Karasulu", "sn: karasulu", "dn: ou=Computers,uid=akarasulu,ou=users,ou=system", "objectClass: organizationalUnit", "objectClass: top", "ou: computers", "description: Computers for Alex", "seeAlso: ou=Machines,uid=akarasulu,ou=users,ou=system", "dn: uid=akarasuluref,ou=users,ou=system", "objectClass: uidObject", "objectClass: referral", "objectClass: top", "uid: akarasuluref", "ref: ldap://localhost:10389/uid=akarasulu,ou=users,ou=system", "ref: ldap://foo:10389/uid=akarasulu,ou=users,ou=system", "ref: ldap://bar:10389/uid=akarasulu,ou=users,ou=system"})
public class CompareIT
extends AbstractLdapTestUnit {
    @Rule
    public MultiThreadedMultiInvoker i = new MultiThreadedMultiInvoker(false);
    private static final Logger LOG = LoggerFactory.getLogger(CompareIT.class);

    @Test
    public void testNormalCompare() throws Exception {
        LdapConnection conn = ServerIntegrationUtils.getAdminConnection((LdapServer)CompareIT.getLdapServer());
        boolean response = conn.compare("uid=akarasulu,ou=users,ou=system", "sn", "karasulu");
        Assert.assertTrue((boolean)response);
        response = conn.compare("uid=akarasulu,ou=users,ou=system", "sn", "lecharny");
        Assert.assertFalse((boolean)response);
        conn.unBind();
        conn.close();
    }

    @Test
    public void testNormalCompareMissingAttribute() throws Exception {
        LDAPConnection conn = ServerIntegrationUtils.getNsdkWiredConnection((LdapServer)CompareIT.getLdapServer());
        LDAPAttribute attribute = new LDAPAttribute("sn", "karasulu");
        Assert.assertTrue((boolean)conn.compare("uid=akarasulu,ou=users,ou=system", attribute));
        attribute = new LDAPAttribute("mail", "akarasulu@apache.org");
        try {
            conn.compare("uid=akarasulu,ou=users,ou=system", attribute);
            Assert.fail((String)"Should never get here");
        }
        catch (LDAPException e) {
            Assert.assertEquals((long)ResultCodeEnum.NO_SUCH_ATTRIBUTE.getValue(), (long)e.getLDAPResultCode());
        }
        conn.disconnect();
    }

    @Test
    public void testOnReferralWithManageDsaITControl() throws Exception {
        LDAPConnection conn = ServerIntegrationUtils.getNsdkWiredConnection((LdapServer)CompareIT.getLdapServer());
        LDAPConstraints constraints = new LDAPConstraints();
        constraints.setClientControls(new LDAPControl("2.16.840.1.113730.3.4.2", true, new byte[0]));
        constraints.setServerControls(new LDAPControl("2.16.840.1.113730.3.4.2", true, new byte[0]));
        conn.setConstraints(constraints);
        LDAPAttribute attribute = new LDAPAttribute("uid", "akarasuluref");
        Assert.assertTrue((boolean)conn.compare("uid=akarasuluref,ou=users,ou=system", attribute, constraints));
        attribute = new LDAPAttribute("uid", "elecharny");
        Assert.assertFalse((boolean)conn.compare("uid=akarasuluref,ou=users,ou=system", attribute, constraints));
        conn.disconnect();
    }

    @Test
    public void testOnReferral() throws Exception {
        LDAPConnection conn = ServerIntegrationUtils.getNsdkWiredConnection((LdapServer)CompareIT.getLdapServer());
        LDAPConstraints constraints = new LDAPConstraints();
        constraints.setReferrals(false);
        conn.setConstraints(constraints);
        LDAPAttribute attribute = new LDAPAttribute("uid", "akarasulu");
        Assert.assertTrue((boolean)conn.compare("uid=akarasulu,ou=users,ou=system", attribute, constraints));
        attribute = new LDAPAttribute("uid", "akarasulu");
        LDAPResponseListener listener = null;
        LDAPResponse response = null;
        listener = conn.compare("uid=akarasuluref,ou=users,ou=system", attribute, null, constraints);
        response = listener.getResponse();
        Assert.assertEquals((long)ResultCodeEnum.REFERRAL.getValue(), (long)response.getResultCode());
        Assert.assertEquals((Object)"ldap://localhost:10389/uid=akarasulu,ou=users,ou=system", (Object)response.getReferrals()[0]);
        Assert.assertEquals((Object)"ldap://foo:10389/uid=akarasulu,ou=users,ou=system", (Object)response.getReferrals()[1]);
        Assert.assertEquals((Object)"ldap://bar:10389/uid=akarasulu,ou=users,ou=system", (Object)response.getReferrals()[2]);
        conn.disconnect();
    }

    @Test
    public void testThrowOnReferralWithJndi() throws Exception {
        LdapContext ctx = ServerIntegrationUtils.getWiredContextThrowOnRefferal((LdapServer)CompareIT.getLdapServer());
        SearchControls controls = new SearchControls();
        controls.setReturningAttributes(new String[0]);
        controls.setSearchScope(0);
        NamingEnumeration<SearchResult> answer = ctx.search("uid=akarasulu,ou=users,ou=system", "(uid=akarasulu)", controls);
        Assert.assertTrue((boolean)answer.hasMore());
        SearchResult result = answer.next();
        Assert.assertEquals((Object)"", (Object)result.getName());
        Assert.assertEquals((long)0L, (long)result.getAttributes().size());
        Assert.assertFalse((boolean)answer.hasMore());
        answer.close();
        try {
            answer = ctx.search("uid=akarasuluref,ou=users,ou=system", "(uid=akarasuluref)", controls);
            Assert.fail((String)"Should never get here");
        }
        catch (ReferralException e) {
            Assert.assertEquals((Object)"ldap://localhost:10389/uid=akarasulu,ou=users,ou=system", (Object)e.getReferralInfo());
        }
        ctx.close();
    }

    @Test
    public void testCompareWithoutAuthentication() throws LDAPException {
        CompareIT.getLdapServer().getDirectoryService().setAllowAnonymousAccess(false);
        LDAPConnection conn = new LDAPConnection();
        conn.connect("localhost", CompareIT.getLdapServer().getPort());
        LDAPAttribute attr = new LDAPAttribute("uid", "admin");
        try {
            conn.compare("uid=admin,ou=system", attr);
            Assert.fail((String)"Compare success without authentication");
        }
        catch (LDAPException e) {
            Assert.assertEquals((String)"no permission exception", (long)50L, (long)e.getLDAPResultCode());
        }
    }

    @Test
    public void testAncestorReferral() throws Exception {
        LOG.debug("");
        LDAPConnection conn = ServerIntegrationUtils.getNsdkWiredConnection((LdapServer)CompareIT.getLdapServer());
        LDAPConstraints constraints = new LDAPConstraints();
        conn.setConstraints(constraints);
        LDAPAttribute attribute = new LDAPAttribute("ou", "Computers");
        LDAPResponseListener listener = null;
        LDAPResponse response = null;
        listener = conn.compare("ou=Computers,uid=akarasuluref,ou=users,ou=system", attribute, null, constraints);
        response = listener.getResponse();
        Assert.assertEquals((long)ResultCodeEnum.REFERRAL.getValue(), (long)response.getResultCode());
        Assert.assertEquals((Object)"ldap://localhost:10389/ou=Computers,uid=akarasulu,ou=users,ou=system", (Object)response.getReferrals()[0]);
        Assert.assertEquals((Object)"ldap://foo:10389/ou=Computers,uid=akarasulu,ou=users,ou=system", (Object)response.getReferrals()[1]);
        Assert.assertEquals((Object)"ldap://bar:10389/ou=Computers,uid=akarasulu,ou=users,ou=system", (Object)response.getReferrals()[2]);
        conn.disconnect();
    }
}

