/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.search;

import java.io.Reader;
import java.io.StringReader;
import javax.naming.NamingEnumeration;
import javax.naming.ReferralException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.ManageReferralControl;
import org.apache.directory.junit.tools.MultiThreadedMultiInvoker;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.integ.ServerIntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.shared.ldap.model.entry.DefaultEntry;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.ldif.LdifEntry;
import org.apache.directory.shared.ldap.model.ldif.LdifReader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
@ApplyLdifs(value={"dn: ou=RemoteUsers,ou=system", "objectClass: top", "objectClass: referral", "objectClass: extensibleObject", "ou: RemoteUsers", "ref: ldap://fermi:10389/ou=users,ou=system", "ref: ldap://hertz:10389/ou=users,dc=example,dc=com", "ref: ldap://maxwell:10389/ou=users,ou=system", "dn: c=France,ou=system", "objectClass: top", "objectClass: country", "c: France", "dn: c=USA,ou=system", "objectClass: top", "objectClass: country", "c: USA", "dn: l=Paris,c=france,ou=system", "objectClass: top", "objectClass: locality", "l: Paris", "dn: l=Jacksonville,c=usa,ou=system", "objectClass: top", "objectClass: locality", "l: Jacksonville", "dn: cn=emmanuel lecharny,l=paris,c=france,ou=system", "objectClass: top", "objectClass: person", "objectClass: residentialPerson", "cn: emmanuel lecharny", "sn: elecharny", "l: Paris", "dn: cn=alex karasulu,l=jacksonville,c=usa,ou=system", "objectClass: top", "objectClass: person", "objectClass: residentialPerson", "cn: alex karasulu", "sn: karasulu", "l: Jacksonville", "dn: ou=Countries,ou=system", "objectClass: top", "objectClass: organizationalUnit", "ou: Countries"})
public class ReferralSearchMoveAndRenameIT
extends AbstractLdapTestUnit {
    @Rule
    public MultiThreadedMultiInvoker i = new MultiThreadedMultiInvoker(false);

    @Before
    public void setupReferrals() throws Exception {
        ReferralSearchMoveAndRenameIT.getLdapServer().getDirectoryService().getChangeLog().setEnabled(false);
        String ldif = "dn: c=europ,ou=Countries,ou=system\nobjectClass: top\nobjectClass: referral\nobjectClass: extensibleObject\nc: europ\nref: ldap://localhost:" + ReferralSearchMoveAndRenameIT.getLdapServer().getPort() + "/c=france,ou=system\n\n" + "dn: c=america,ou=Countries,ou=system\n" + "objectClass: top\n" + "objectClass: referral\n" + "objectClass: extensibleObject\n" + "c: america\n" + "ref: ldap://localhost:" + ReferralSearchMoveAndRenameIT.getLdapServer().getPort() + "/c=usa,ou=system\n\n";
        LdifReader reader = new LdifReader((Reader)new StringReader(ldif));
        while (reader.hasNext()) {
            LdifEntry entry = reader.next();
            ReferralSearchMoveAndRenameIT.getLdapServer().getDirectoryService().getAdminSession().add((Entry)new DefaultEntry(ReferralSearchMoveAndRenameIT.getLdapServer().getDirectoryService().getSchemaManager(), entry.getEntry()));
        }
    }

    @Test
    public void testSearchBaseWithReferralThrowAfterMoveAndRename() throws Exception {
        String referral;
        LdapContext ctx = ServerIntegrationUtils.getWiredContextThrowOnRefferal((LdapServer)ReferralSearchMoveAndRenameIT.getLdapServer());
        SearchControls controls = new SearchControls();
        controls.setSearchScope(0);
        try {
            ctx.search("c=america,ou=Countries,ou=system", "(cn=alex karasulu)", controls);
            Assert.fail((String)"Should fail here throwing a ReferralException");
        }
        catch (ReferralException re) {
            referral = (String)re.getReferralInfo();
            Assert.assertEquals((Object)("ldap://localhost:" + ReferralSearchMoveAndRenameIT.getLdapServer().getPort() + "/c=usa,ou=system??base"), (Object)referral);
        }
        ctx.setRequestControls(new Control[]{new ManageReferralControl()});
        ctx.rename("c=america,ou=Countries,ou=system", "c=us,ou=system");
        controls.setSearchScope(0);
        ctx.setRequestControls(new Control[0]);
        try {
            NamingEnumeration<SearchResult> results = ctx.search("c=us,ou=system", "(cn=alex karasulu)", controls);
            results.next();
            Assert.fail((String)"Should fail here throwing a ReferralException");
        }
        catch (ReferralException re) {
            referral = (String)re.getReferralInfo();
            Assert.assertEquals((Object)("ldap://localhost:" + ReferralSearchMoveAndRenameIT.getLdapServer().getPort() + "/c=usa,ou=system??base"), (Object)referral);
        }
    }
}

