/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.replication;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.directory.junit.tools.MultiThreadedMultiInvoker;
import org.apache.directory.server.annotations.CreateConsumer;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ContextEntry;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreateIndex;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.factory.DSAnnotationProcessor;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.factory.ServerAnnotationProcessor;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.replication.consumer.ReplicationConsumerImpl;
import org.apache.directory.server.ldap.replication.provider.ReplicationRequestHandler;
import org.apache.directory.server.ldap.replication.provider.SyncReplRequestHandler;
import org.apache.directory.shared.ldap.model.entry.DefaultEntry;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.message.ModifyRequest;
import org.apache.directory.shared.ldap.model.message.ModifyRequestImpl;
import org.apache.directory.shared.ldap.model.message.SearchRequest;
import org.apache.directory.shared.ldap.model.message.SearchRequestImpl;
import org.apache.directory.shared.ldap.model.message.SearchScope;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

public class ClientServerReplicationIT {
    @Rule
    public MultiThreadedMultiInvoker i = new MultiThreadedMultiInvoker(false);
    private static LdapServer providerServer;
    private static LdapServer consumerServer;
    private static SchemaManager schemaManager;
    private static CoreSession providerSession;
    private static CoreSession consumerSession;
    private static AtomicInteger entryCount;

    @BeforeClass
    public static void setUp() throws Exception {
        Class.forName(FrameworkRunner.class.getName());
        ClientServerReplicationIT.startProvider();
        ClientServerReplicationIT.startConsumer();
    }

    @AfterClass
    public static void tearDown() {
        consumerServer.stop();
        providerServer.stop();
    }

    private void dump(CoreSession session, Dn entryDn) {
        try {
            SearchRequestImpl searchRequest = new SearchRequestImpl();
            searchRequest.setBase(new Dn(schemaManager, new String[]{"dc=example,dc=com"}));
            searchRequest.setFilter("(objectClass=*)");
            searchRequest.setScope(SearchScope.SUBTREE);
            searchRequest.addAttributes(new String[]{"entryUuid"});
            System.out.println("-----------> Dumping the server <-----------");
            System.out.println("-----------> Looking for " + entryDn.getNormName() + " <-----------");
            EntryFilteringCursor cursor = session.search((SearchRequest)searchRequest);
            while (cursor.next()) {
                Entry entry = (Entry)cursor.get();
                if (entry.getDn().equals((Object)entryDn)) {
                    System.out.println("The searched entry exists !!!");
                    System.out.println("found Entry " + entry.getDn().getNormName() + " exists, entrtyUuid = " + entry.get("entryUuid"));
                    continue;
                }
                System.out.println("Entry " + entry.getDn().getNormName() + " exists, entrtyUuid = " + entry.get("entryUuid"));
            }
            cursor.close();
            System.out.println("-----------> Dump done <-----------");
        }
        catch (Exception le) {
            le.printStackTrace();
        }
    }

    private boolean checkEntryExistence(CoreSession session, Dn entryDn) throws Exception {
        return this.checkEntryExistence(session, entryDn, false);
    }

    private boolean checkEntryExistence(CoreSession session, Dn entryDn, boolean print) throws Exception {
        boolean replicated = false;
        for (int i = 0; i < 100; ++i) {
            Thread.sleep(50L);
            if (session.exists(entryDn)) {
                if (print) {
                    System.out.println(entryDn.getName() + " exists ");
                }
                replicated = true;
                break;
            }
            Thread.sleep(50L);
        }
        if (!replicated) {
            this.dump(session, entryDn);
        }
        return replicated;
    }

    private boolean checkEntryDeletion(CoreSession session, Dn entryDn) throws Exception {
        boolean exists = session.exists(entryDn);
        if (!exists) {
            return true;
        }
        for (int i = 0; i < 100; ++i) {
            Thread.sleep(50L);
            exists = session.exists(entryDn);
            if (!exists) {
                return true;
            }
            Thread.sleep(50L);
        }
        this.dump(session, entryDn);
        return false;
    }

    @Test
    public void testModify() throws Exception {
        Entry provUser = this.createEntry();
        Assert.assertFalse((boolean)consumerSession.exists(provUser.getDn()));
        providerSession.add(provUser);
        Assert.assertTrue((boolean)providerSession.exists(provUser.getDn()));
        ModifyRequestImpl modReq = new ModifyRequestImpl();
        modReq.setName(provUser.getDn());
        modReq.add("userPassword", new String[]{"secret"});
        providerSession.modify((ModifyRequest)modReq);
        Assert.assertTrue((boolean)this.checkEntryExistence(consumerSession, provUser.getDn()));
        this.waitAndCompareEntries(provUser.getDn());
    }

    @Test
    public void testModDn() throws Exception {
        Entry provUser = this.createEntry();
        Assert.assertFalse((boolean)consumerSession.exists(provUser.getDn()));
        providerSession.add(provUser);
        Dn usersContainer = new Dn(schemaManager, new String[]{"ou=users,dc=example,dc=com"});
        DefaultEntry entry = new DefaultEntry(schemaManager, usersContainer, new Object[]{"objectClass: organizationalUnit", "ou: users"});
        providerSession.add((Entry)entry);
        Assert.assertTrue((boolean)this.checkEntryExistence(consumerSession, usersContainer));
        this.waitAndCompareEntries(entry.getDn());
        Dn userDn = provUser.getDn();
        providerSession.move(userDn, usersContainer);
        Dn movedEntryDn = usersContainer.add(userDn.getRdn());
        Assert.assertTrue((boolean)this.checkEntryExistence(consumerSession, movedEntryDn));
        this.waitAndCompareEntries(movedEntryDn);
        Rdn newName = new Rdn(schemaManager, movedEntryDn.getRdn().getName() + "renamed");
        providerSession.rename(movedEntryDn, newName, true);
        Dn renamedEntryDn = usersContainer.add(newName);
        Assert.assertTrue((boolean)this.checkEntryExistence(consumerSession, renamedEntryDn));
        this.waitAndCompareEntries(renamedEntryDn);
        Dn newParent = usersContainer.getParent();
        newName = new Rdn(schemaManager, renamedEntryDn.getRdn().getName() + "MovedAndRenamed");
        providerSession.moveAndRename(renamedEntryDn, newParent, newName, false);
        Dn movedAndRenamedEntry = newParent.add(newName);
        Assert.assertTrue((boolean)this.checkEntryExistence(consumerSession, movedAndRenamedEntry));
        this.waitAndCompareEntries(movedAndRenamedEntry);
    }

    @Test
    @Ignore(value="Run this test alone, otherwise it conflicts with moddn")
    public void testModDnLoop() throws Exception {
        for (int i = 0; i < 10; ++i) {
            System.out.println(">>>>>> loop " + (i + 1) + " <<<<<<");
            Entry newuser = this.createEntry();
            Assert.assertFalse((boolean)consumerSession.exists(newuser.getDn()));
            providerSession.add(newuser);
            Dn usersContainer = new Dn(schemaManager, new String[]{"ou=users,dc=example,dc=com"});
            DefaultEntry usersEntry = new DefaultEntry(schemaManager, usersContainer, new Object[]{"objectClass: organizationalUnit", "ou: users"});
            providerSession.add((Entry)usersEntry);
            Assert.assertTrue((boolean)this.checkEntryExistence(consumerSession, usersContainer));
            this.waitAndCompareEntries(usersEntry.getDn());
            Dn userDn = newuser.getDn();
            providerSession.move(userDn, usersContainer);
            Dn movedEntryDn = usersContainer.add(userDn.getRdn());
            Assert.assertTrue((boolean)this.checkEntryExistence(consumerSession, movedEntryDn));
            this.waitAndCompareEntries(movedEntryDn);
            Rdn newName = new Rdn(schemaManager, movedEntryDn.getRdn().getName() + "renamed");
            providerSession.rename(movedEntryDn, newName, true);
            Dn renamedEntryDn = usersContainer.add(newName);
            Assert.assertTrue((boolean)this.checkEntryExistence(consumerSession, renamedEntryDn));
            this.waitAndCompareEntries(renamedEntryDn);
            Dn newParent = usersContainer.getParent();
            newName = new Rdn(schemaManager, renamedEntryDn.getRdn().getName() + "MovedAndRenamed");
            providerSession.moveAndRename(renamedEntryDn, newParent, newName, false);
            Dn movedAndRenamedEntry = newParent.add(newName);
            Assert.assertTrue((boolean)this.checkEntryExistence(consumerSession, movedAndRenamedEntry));
            this.waitAndCompareEntries(movedAndRenamedEntry);
            providerSession.delete(movedAndRenamedEntry);
            providerSession.delete(usersContainer);
        }
    }

    @Test
    public void testDelete() throws Exception {
        Entry provUser = this.createEntry();
        providerSession.add(provUser);
        Assert.assertTrue((boolean)this.checkEntryExistence(consumerSession, provUser.getDn()));
        this.waitAndCompareEntries(provUser.getDn());
        Assert.assertTrue((boolean)providerSession.exists(provUser.getDn()));
        Assert.assertTrue((boolean)consumerSession.exists(provUser.getDn()));
        providerSession.delete(provUser.getDn());
        Assert.assertTrue((boolean)this.checkEntryDeletion(consumerSession, provUser.getDn()));
        Assert.assertFalse((boolean)providerSession.exists(provUser.getDn()));
    }

    private Entry restartConsumer(Entry provUser) throws Exception {
        consumerServer.stop();
        Dn deletedUserDn = provUser.getDn();
        providerSession.delete(deletedUserDn);
        provUser = this.createEntry();
        Dn addedUserDn = provUser.getDn();
        providerSession.add(provUser);
        Thread.sleep(1000L);
        consumerServer.start();
        Assert.assertTrue((boolean)this.checkEntryDeletion(consumerSession, deletedUserDn));
        Assert.assertTrue((boolean)this.checkEntryExistence(consumerSession, addedUserDn));
        this.waitAndCompareEntries(addedUserDn);
        return provUser;
    }

    @Test
    public void testRebootConsumer() throws Exception {
        Entry provUser = this.createEntry();
        Assert.assertFalse((boolean)providerSession.exists(provUser.getDn()));
        Assert.assertFalse((boolean)consumerSession.exists(provUser.getDn()));
        providerSession.add(provUser);
        Assert.assertTrue((boolean)this.checkEntryExistence(consumerSession, provUser.getDn()));
        this.waitAndCompareEntries(provUser.getDn());
        Assert.assertTrue((boolean)providerSession.exists(provUser.getDn()));
        Assert.assertTrue((boolean)consumerSession.exists(provUser.getDn()));
        for (int i = 0; i < 10; ++i) {
            provUser = this.restartConsumer(provUser);
        }
    }

    private void waitAndCompareEntries(Dn dn) throws Exception {
        String[] searchAttributes = new String[]{"*", "entryUUID"};
        Entry providerEntry = providerSession.lookup(dn, searchAttributes);
        Entry consumerEntry = consumerSession.lookup(dn, searchAttributes);
        Assert.assertEquals((Object)providerEntry, (Object)consumerEntry);
    }

    private Entry createEntry() throws Exception {
        String user = "user" + entryCount.incrementAndGet();
        String dn = "cn=" + user + ",dc=example,dc=com";
        DefaultEntry entry = new DefaultEntry(schemaManager, dn, new Object[]{"objectClass", "person", "cn", user, "sn", user});
        return entry;
    }

    @CreateDS(allowAnonAccess=true, name="provider-replication", enableChangeLog=false, partitions={@CreatePartition(name="example", suffix="dc=example,dc=com", indexes={@CreateIndex(attribute="objectClass"), @CreateIndex(attribute="dc"), @CreateIndex(attribute="ou")}, contextEntry=@ContextEntry(entryLdif="dn: dc=example,dc=com\nobjectClass: domain\ndc: example"))})
    @CreateLdapServer(transports={@CreateTransport(port=16000, protocol="LDAP")})
    public static void startProvider() throws Exception {
        DirectoryService provDirService = DSAnnotationProcessor.getDirectoryService();
        providerServer = ServerAnnotationProcessor.getLdapServer((DirectoryService)provDirService);
        providerServer.setReplicationReqHandler((ReplicationRequestHandler)new SyncReplRequestHandler());
        providerServer.startReplicationProducer();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    schemaManager = providerServer.getDirectoryService().getSchemaManager();
                    providerSession = providerServer.getDirectoryService().getAdminSession();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.start();
        t.join();
    }

    @CreateDS(allowAnonAccess=true, enableChangeLog=false, name="consumer-replication", partitions={@CreatePartition(name="example", suffix="dc=example,dc=com", indexes={@CreateIndex(attribute="objectClass"), @CreateIndex(attribute="dc"), @CreateIndex(attribute="ou")}, contextEntry=@ContextEntry(entryLdif="dn: dc=example,dc=com\nobjectClass: domain\ndc: example"))})
    @CreateLdapServer(transports={@CreateTransport(port=17000, protocol="LDAP")})
    @CreateConsumer(remoteHost="localhost", remotePort=16000, replUserDn="uid=admin,ou=system", replUserPassword="secret", useTls=false, baseDn="dc=example,dc=com", refreshInterval=1000L, replicaId=1)
    public static void startConsumer() throws Exception {
        DirectoryService provDirService = DSAnnotationProcessor.getDirectoryService();
        consumerServer = ServerAnnotationProcessor.getLdapServer((DirectoryService)provDirService);
        final ReplicationConsumerImpl consumer = (ReplicationConsumerImpl)ServerAnnotationProcessor.createConsumer();
        ArrayList<ReplicationConsumerImpl> replConsumers = new ArrayList<ReplicationConsumerImpl>();
        replConsumers.add(consumer);
        consumerServer.setReplConsumers(replConsumers);
        consumerServer.startReplicationConsumers();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    DirectoryService ds = consumerServer.getDirectoryService();
                    Dn configDn = new Dn(ds.getSchemaManager(), new String[]{"ads-replConsumerId=localhost,ou=system"});
                    consumer.getConfig().setConfigEntryDn(configDn);
                    DefaultEntry provConfigEntry = new DefaultEntry(ds.getSchemaManager(), configDn, new Object[]{"objectClass: ads-replConsumer", "ads-replConsumerId: localhost", "ads-searchBaseDN", consumer.getConfig().getBaseDn(), "ads-replProvHostName", consumer.getConfig().getRemoteHost(), "ads-replProvPort", String.valueOf(consumer.getConfig().getRemotePort()), "ads-replRefreshInterval", String.valueOf(consumer.getConfig().getRefreshInterval()), "ads-replRefreshNPersist", String.valueOf(consumer.getConfig().isRefreshNPersist()), "ads-replSearchScope", consumer.getConfig().getSearchScope().getLdapUrlValue(), "ads-replSearchFilter", consumer.getConfig().getFilter(), "ads-replSearchSizeLimit", String.valueOf(consumer.getConfig().getSearchSizeLimit()), "ads-replSearchTimeOut", String.valueOf(consumer.getConfig().getSearchTimeout()), "ads-replUserDn", consumer.getConfig().getReplUserDn(), "ads-replUserPassword", consumer.getConfig().getReplUserPassword()});
                    provConfigEntry.put("ads-replAliasDerefMode", new String[]{consumer.getConfig().getAliasDerefMode().getJndiValue()});
                    provConfigEntry.put("ads-replAttributes", consumer.getConfig().getAttributes());
                    consumerSession = consumerServer.getDirectoryService().getAdminSession();
                    consumerSession.add((Entry)provConfigEntry);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.start();
        t.join();
    }

    static {
        entryCount = new AtomicInteger();
    }
}

