/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.admin;

import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.core.integ.IntegrationUtils;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.DefaultAttribute;
import org.apache.directory.shared.ldap.model.entry.DefaultModification;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.entry.ModificationOperation;
import org.apache.directory.shared.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
@ApplyLdifs(value={"dn: ou=SAP-AC,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: SAP-AC", "administrativeRole: accessControlSpecificArea", "", "dn: ou=SAP-CA,ou=SAP-AC,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: SAP-CA", "administrativeRole: collectiveAttributeSpecificArea", "", "dn: ou=AAP,ou=SAP-CA,ou=SAP-AC,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: AAP", "administrativeRole: autonomousArea", "", "dn: ou=IAP-CA,ou=AAP,ou=SAP-CA,ou=SAP-AC,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: IAP-CA", "administrativeRole: collectiveAttributeInnerArea", "", "dn: ou=IAP-AC,ou=AAP,ou=SAP-CA,ou=SAP-AC,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: IAP-AC", "administrativeRole: accessControlInnerArea", "", "dn: ou=IAP-TE,ou=AAP,ou=SAP-CA,ou=SAP-AC,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: IAP-TE", "administrativeRole: triggerExecutionInnerArea", "", "dn: ou=AAP,ou=SAP-AC,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: AAP", "administrativeRole: autonomousArea", "", "dn: ou=AAP,ou=AAP,ou=SAP-AC,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: AAP", "administrativeRole: autonomousArea", "", "dn: ou=SAP-AC,ou=AAP,ou=SAP-AC,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: SAP-AC", "administrativeRole: accessControlSpecificArea", "", "dn: ou=SAP-CA,ou=AAP,ou=SAP-AC,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: SAP-CA", "administrativeRole: collectiveAttributeSpecificArea", "", "dn: ou=IAP-AC,ou=AAP,ou=SAP-AC,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: IAP-AC", "administrativeRole: accessControlInnerArea", "", "dn: ou=IAP-CA,ou=AAP,ou=SAP-AC,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: IAP-CA", "administrativeRole: collectiveAttributeInnerArea", "", "dn: ou=AAP,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: AAP", "administrativeRole: autonomousArea", "", "dn: ou=AAP,ou=AAP,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: AAP", "administrativeRole: autonomousArea", "", "dn: ou=AAP,ou=AAP,ou=AAP,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: AAP", "administrativeRole: autonomousArea", "", "dn: ou=SAP-CA,ou=AAP,ou=AAP,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: SAP-CA", "administrativeRole: collectiveAttributeSpecificArea", "", "dn: ou=IAP-CA,ou=AAP,ou=AAP,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: IAP-CA", "administrativeRole: collectiveAttributeInnerArea", "", "dn: ou=AAP1,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: AAP1", "administrativeRole: autonomousArea", "", "dn: ou=AAP,ou=AAP1,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: AAP", "administrativeRole: autonomousArea", "", "dn: ou=SAP-CA,ou=AAP1,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: SAP-CA", "administrativeRole: collectiveAttributeSpecificArea", "", "", "dn: ou=IAP-CA,ou=AAP1,ou=system", "ObjectClass: top", "ObjectClass: organizationalUnit", "ou: IAP-CA", "administrativeRole: collectiveAttributeInnerArea", ""})
public class AdministrativePointModifyIT
extends AbstractLdapTestUnit {
    private static LdapConnection connection;
    private static SchemaManager schemaManager;

    @Before
    public void init() throws Exception {
        connection = IntegrationUtils.getAdminConnection((DirectoryService)AdministrativePointModifyIT.getService());
        schemaManager = AdministrativePointModifyIT.getLdapServer().getDirectoryService().getSchemaManager();
    }

    @After
    public void shutdown() throws Exception {
        connection.close();
    }

    private Attribute getAdminRole(String dn) throws Exception {
        Entry lookup = connection.lookup(dn, new String[]{"administrativeRole"});
        Assert.assertNotNull((Object)lookup);
        return lookup.get("administrativeRole");
    }

    @Test
    public void testModifyAAPToSAPWithIAPBelow() throws Exception {
        Assert.assertTrue((boolean)AdministrativePointModifyIT.getLdapServer().isStarted());
        DefaultModification modificationDelAap = new DefaultModification(ModificationOperation.REMOVE_ATTRIBUTE, (Attribute)new DefaultAttribute("administrativeRole"));
        DefaultModification modificationAddSap = new DefaultModification(ModificationOperation.ADD_ATTRIBUTE, (Attribute)new DefaultAttribute("administrativeRole", new String[]{"triggerExecutionSpecificArea"}));
        try {
            connection.modify("ou=AAP,ou=SAP-CA,ou=SAP-AC,ou=system", new Modification[]{modificationDelAap, modificationAddSap});
            Assert.fail();
        }
        catch (LdapUnwillingToPerformException lutpe) {
            Assert.assertTrue((boolean)true);
        }
    }
}

