/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.ldapsdk;

import javax.naming.AuthenticationException;
import javax.naming.InvalidNameException;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPException;
import org.apache.directory.junit.tools.MultiThreadedMultiInvoker;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.integ.ServerIntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.shared.util.Strings;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FrameworkRunner.class)
@ApplyLdifs(value={"dn: uid=akarasulu,ou=users,ou=system", "objectClass: uidObject", "objectClass: person", "objectClass: top", "uid: akarasulu", "cn: Alex Karasulu", "sn: karasulu", "dn: ou=Computers,uid=akarasulu,ou=users,ou=system", "objectClass: organizationalUnit", "objectClass: top", "ou: computers", "description: Computers for Alex", "seeAlso: ou=Machines,uid=akarasulu,ou=users,ou=system", "dn: uid=akarasuluref,ou=users,ou=system", "objectClass: extensibleObject", "objectClass: uidObject", "objectClass: referral", "objectClass: top", "uid: akarasuluref", "userPassword: secret", "ref: ldap://localhost:10389/uid=akarasulu,ou=users,ou=system", "ref: ldap://foo:10389/uid=akarasulu,ou=users,ou=system", "ref: ldap://bar:10389/uid=akarasulu,ou=users,ou=system"})
@CreateDS(allowAnonAccess=true, name="BindIT-class")
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
public class BindIT
extends AbstractLdapTestUnit {
    @Rule
    public MultiThreadedMultiInvoker i = new MultiThreadedMultiInvoker(false);

    @Test
    public void testBadBindDnNotInContext() throws Exception {
        try {
            ServerIntegrationUtils.getWiredContext((LdapServer)BindIT.getLdapServer(), (String)"cn=bogus", (String)"blah");
            Assert.fail((String)"should never get here due to a ");
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
    }

    @Test
    public void testBadBindDnMalformed() throws Exception {
        try {
            ServerIntegrationUtils.getWiredContext((LdapServer)BindIT.getLdapServer(), (String)"system", (String)"blah");
            Assert.fail((String)"should never get here due to a ");
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
    }

    @Test
    public void testBadBindDnInContext() throws Exception {
        try {
            ServerIntegrationUtils.getWiredContext((LdapServer)BindIT.getLdapServer(), (String)"cn=bogus,ou=system", (String)"blah");
            Assert.fail((String)"should never get here due to a ");
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectWithIllegalLDAPVersion() throws Exception {
        LDAPConnection conn = null;
        try {
            conn = new LDAPConnection();
            conn.connect(100, "localhost", BindIT.getLdapServer().getPort(), "uid=admin,ou=system", "secret");
            Assert.fail((String)"try to connect with illegal version number should fail");
        }
        catch (LDAPException e) {
            Assert.assertEquals((String)"statuscode", (long)2L, (long)e.getLDAPResultCode());
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    @Test
    public void testOnReferralWithOrWithoutManageDsaItControl() throws Exception {
        LDAPConnection conn = new LDAPConnection();
        LDAPConstraints constraints = new LDAPConstraints();
        constraints.setClientControls(new LDAPControl("2.16.840.1.113730.3.4.2", true, Strings.EMPTY_BYTES));
        constraints.setServerControls(new LDAPControl("2.16.840.1.113730.3.4.2", true, Strings.EMPTY_BYTES));
        conn.setConstraints(constraints);
        try {
            conn.connect(3, "localhost", BindIT.getLdapServer().getPort(), "uid=akarasuluref,ou=users,ou=system", "secret", constraints);
            Assert.fail((String)"try to connect with illegal version number should fail");
        }
        catch (LDAPException e) {
            Assert.assertEquals((String)"statuscode", (long)49L, (long)e.getLDAPResultCode());
        }
        try {
            conn.connect(3, "localhost", BindIT.getLdapServer().getPort(), "uid=akarasuluref,ou=users,ou=system", "secret");
            Assert.fail((String)"try to connect with illegal version number should fail");
        }
        catch (LDAPException e) {
            Assert.assertEquals((String)"statuscode", (long)49L, (long)e.getLDAPResultCode());
        }
    }
}

