/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.operations.ldapsdk;

import javax.naming.ReferralException;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.LdapContext;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPResponse;
import netscape.ldap.LDAPResponseListener;
import org.apache.directory.junit.tools.MultiThreadedMultiInvoker;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.integ.ServerIntegrationUtils;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.operations.compare.CompareIT;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.util.Strings;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=FrameworkRunner.class)
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP")})
@ApplyLdifs(value={"dn: uid=akarasulu,ou=users,ou=system", "objectClass: uidObject", "objectClass: person", "objectClass: top", "uid: akarasulu", "cn: Alex Karasulu", "sn: karasulu", "dn: ou=Computers,uid=akarasulu,ou=users,ou=system", "objectClass: organizationalUnit", "objectClass: top", "ou: computers", "description: Computers for Alex", "seeAlso: ou=Machines,uid=akarasulu,ou=users,ou=system", "dn: uid=akarasuluref,ou=users,ou=system", "objectClass: extensibleObject", "objectClass: referral", "objectClass: top", "uid: akarasuluref", "ref: ldap://localhost:10389/uid=akarasulu,ou=users,ou=system", "ref: ldap://foo:10389/uid=akarasulu,ou=users,ou=system", "ref: ldap://bar:10389/uid=akarasulu,ou=users,ou=system"})
public class ModifyReferralIT
extends AbstractLdapTestUnit {
    @Rule
    public MultiThreadedMultiInvoker i = new MultiThreadedMultiInvoker(false);
    private static final Logger LOG = LoggerFactory.getLogger(CompareIT.class);

    @Test
    public void testOnReferralWithManageDsaITControl() throws Exception {
        LDAPConnection conn = ServerIntegrationUtils.getNsdkWiredConnection((LdapServer)ModifyReferralIT.getLdapServer());
        LDAPConstraints constraints = new LDAPConstraints();
        constraints.setClientControls(new LDAPControl("2.16.840.1.113730.3.4.2", true, Strings.EMPTY_BYTES));
        constraints.setServerControls(new LDAPControl("2.16.840.1.113730.3.4.2", true, Strings.EMPTY_BYTES));
        conn.setConstraints(constraints);
        LDAPAttribute attribute = new LDAPAttribute("description", "referral to akarasulu");
        LDAPModification mod = new LDAPModification(0, attribute);
        conn.modify("uid=akarasuluref,ou=users,ou=system", mod, constraints);
        Assert.assertTrue((boolean)conn.compare("uid=akarasuluref,ou=users,ou=system", attribute, constraints));
        conn.disconnect();
    }

    @Test
    public void testOnReferral() throws Exception {
        LDAPConnection conn = ServerIntegrationUtils.getNsdkWiredConnection((LdapServer)ModifyReferralIT.getLdapServer());
        LDAPConstraints constraints = new LDAPConstraints();
        constraints.setReferrals(false);
        conn.setConstraints(constraints);
        LDAPAttribute attribute = new LDAPAttribute("description", "referral to akarasulu");
        LDAPModification mod = new LDAPModification(0, attribute);
        LDAPResponseListener listener = conn.modify("uid=akarasuluref,ou=users,ou=system", mod, null, constraints);
        LDAPResponse response = listener.getResponse();
        Assert.assertEquals((long)ResultCodeEnum.REFERRAL.getValue(), (long)response.getResultCode());
        Assert.assertEquals((Object)"ldap://localhost:10389/uid=akarasulu,ou=users,ou=system", (Object)response.getReferrals()[0]);
        Assert.assertEquals((Object)"ldap://foo:10389/uid=akarasulu,ou=users,ou=system", (Object)response.getReferrals()[1]);
        Assert.assertEquals((Object)"ldap://bar:10389/uid=akarasulu,ou=users,ou=system", (Object)response.getReferrals()[2]);
        conn.disconnect();
    }

    @Test
    public void testThrowOnReferralWithJndi() throws Exception {
        LdapContext ctx = ServerIntegrationUtils.getWiredContextThrowOnRefferal((LdapServer)ModifyReferralIT.getLdapServer());
        BasicAttribute attr = new BasicAttribute("description", "referral to akarasulu");
        ModificationItem mod = new ModificationItem(1, attr);
        try {
            ctx.modifyAttributes("uid=akarasuluref,ou=users,ou=system", new ModificationItem[]{mod});
        }
        catch (ReferralException e) {
            Assert.assertEquals((Object)"ldap://localhost:10389/uid=akarasulu,ou=users,ou=system", (Object)e.getReferralInfo());
        }
        ctx.close();
    }

    @Test
    public void testAncestorReferral() throws Exception {
        LOG.debug("");
        LDAPConnection conn = ServerIntegrationUtils.getNsdkWiredConnection((LdapServer)ModifyReferralIT.getLdapServer());
        LDAPConstraints constraints = new LDAPConstraints();
        conn.setConstraints(constraints);
        LDAPAttribute attribute = new LDAPAttribute("ou", "Machines");
        LDAPModification mod = new LDAPModification(0, attribute);
        LDAPResponseListener listener = null;
        LDAPResponse response = null;
        listener = conn.modify("ou=Computers,uid=akarasuluref,ou=users,ou=system", mod, null, constraints);
        response = listener.getResponse();
        Assert.assertEquals((long)ResultCodeEnum.REFERRAL.getValue(), (long)response.getResultCode());
        Assert.assertEquals((Object)"ldap://localhost:10389/ou=Computers,uid=akarasulu,ou=users,ou=system", (Object)response.getReferrals()[0]);
        Assert.assertEquals((Object)"ldap://foo:10389/ou=Computers,uid=akarasulu,ou=users,ou=system", (Object)response.getReferrals()[1]);
        Assert.assertEquals((Object)"ldap://bar:10389/ou=Computers,uid=akarasulu,ou=users,ou=system", (Object)response.getReferrals()[2]);
        conn.disconnect();
    }
}

