/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ssl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import org.apache.directory.junit.tools.MultiThreadedMultiInvoker;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.core.security.TlsKeyGenerator;
import org.apache.directory.server.ldap.handlers.extended.StartTlsHandler;
import org.apache.directory.server.ssl.BogusSSLContextFactory;
import org.apache.directory.server.ssl.BogusTrustManagerFactory;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.util.Strings;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=FrameworkRunner.class)
@CreateDS(allowAnonAccess=true, name="StartTlsUpdateCertificateIT-class")
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP"), @CreateTransport(protocol="LDAPS")}, extendedOpHandlers={StartTlsHandler.class})
public class StartTlsUpdateCertificateIT
extends AbstractLdapTestUnit {
    @Rule
    public MultiThreadedMultiInvoker i = new MultiThreadedMultiInvoker(false);
    private static final Logger LOG = LoggerFactory.getLogger(StartTlsUpdateCertificateIT.class);
    private static final String[] CERT_IDS = new String[]{"userCertificate"};
    private File ksFile;
    boolean oldConfidentialityRequiredValue;

    @Before
    public void installKeyStoreWithCertificate() throws Exception {
        if (this.ksFile != null && this.ksFile.exists()) {
            this.ksFile.delete();
        }
        this.ksFile = File.createTempFile("testStore", "ks");
        CoreSession session = StartTlsUpdateCertificateIT.getLdapServer().getDirectoryService().getAdminSession();
        Entry entry = session.lookup(new Dn(new String[]{"uid=admin,ou=system"}), CERT_IDS);
        byte[] userCertificate = entry.get(CERT_IDS[0]).getBytes();
        Assert.assertNotNull((Object)userCertificate);
        ByteArrayInputStream in = new ByteArrayInputStream(userCertificate);
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        Certificate cert = factory.generateCertificate(in);
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(null, null);
        ks.setCertificateEntry("apacheds", cert);
        ks.store(new FileOutputStream(this.ksFile), "changeit".toCharArray());
        LOG.debug("Keystore file installed: {}", (Object)this.ksFile.getAbsolutePath());
        this.oldConfidentialityRequiredValue = StartTlsUpdateCertificateIT.getLdapServer().isConfidentialityRequired();
    }

    @After
    public void deleteKeyStore() throws Exception {
        if (this.ksFile != null && this.ksFile.exists()) {
            this.ksFile.delete();
        }
        LOG.debug("Keystore file deleted: {}", (Object)this.ksFile.getAbsolutePath());
        StartTlsUpdateCertificateIT.getLdapServer().setConfidentialityRequired(this.oldConfidentialityRequiredValue);
    }

    @Test
    public void testUpdateCertificate() throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://localhost:" + StartTlsUpdateCertificateIT.getLdapServer().getPort());
        env.put("java.naming.security.principal", "uid=admin,ou=system");
        env.put("java.naming.security.credentials", "secret");
        env.put("java.naming.security.authentication", "simple");
        InitialLdapContext ctx = new InitialLdapContext(env, null);
        StartTlsResponse tls = (StartTlsResponse)ctx.extendedOperation(new StartTlsRequest());
        tls.setHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
        tls.negotiate(BogusSSLContextFactory.getInstance(false).getSocketFactory());
        String newIssuerDN = "cn=new_issuer_dn";
        String newSubjectDN = "cn=new_subject_dn";
        Entry entry = StartTlsUpdateCertificateIT.getLdapServer().getDirectoryService().getAdminSession().lookup(new Dn(new String[]{"uid=admin,ou=system"}));
        TlsKeyGenerator.addKeyPair((Entry)entry, (String)newIssuerDN, (String)newSubjectDN, (String)"RSA");
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, new BasicAttribute("privateKey", entry.get("privateKey").getBytes())), new ModificationItem(2, new BasicAttribute("publicKey", entry.get("publicKey").getBytes())), new ModificationItem(2, new BasicAttribute("userCertificate", entry.get("userCertificate").getBytes()))};
        ctx.modifyAttributes("uid=admin,ou=system", mods);
        ctx.close();
        StartTlsUpdateCertificateIT.getLdapServer().reloadSslContext();
        ctx = new InitialLdapContext(env, null);
        tls = (StartTlsResponse)ctx.extendedOperation(new StartTlsRequest());
        tls.setHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
        tls.negotiate(BogusSSLContextFactory.getInstance(false).getSocketFactory());
        X509Certificate[] lastReceivedServerCertificates = BogusTrustManagerFactory.lastReceivedServerCertificates;
        Assert.assertNotNull((Object)lastReceivedServerCertificates);
        Assert.assertEquals((long)1L, (long)lastReceivedServerCertificates.length);
        String issuerDN = lastReceivedServerCertificates[0].getIssuerDN().getName();
        String subjectDN = lastReceivedServerCertificates[0].getSubjectDN().getName();
        Assert.assertEquals((String)"Expected the new certificate with the new issuer", (Object)Strings.toLowerCase((String)newIssuerDN), (Object)Strings.toLowerCase((String)issuerDN));
        Assert.assertEquals((String)"Expected the new certificate with the new subject", (Object)Strings.toLowerCase((String)newSubjectDN), (Object)Strings.toLowerCase((String)subjectDN));
    }
}

