/*
 * Decompiled with CFR 0.152.
 */
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.CommunicationException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.SimpleLayout;

public class MultiThreadedTest
extends Thread {
    private Logger _logger;
    private FileAppender _appender;

    public MultiThreadedTest(int i) {
        this.setName("Worker-Thread" + i);
    }

    @Override
    public void run() {
        try {
            this._logger = Logger.getLogger((String)this.getName());
            this._appender = new FileAppender((Layout)new SimpleLayout(), "C:\\threadlog\\" + this.getName() + ".txt", false);
            this._logger.addAppender((Appender)this._appender);
            this._logger.setLevel(Level.ERROR);
            LdapContext tdsContext = MultiThreadedTest.getContext();
            HashMap<String, Object> hMap = new HashMap<String, Object>();
            hMap.put("data", "dsfdfd");
            for (int i = 0; i < 100000; ++i) {
                if (i % 100 == 0) {
                    System.out.println("Thread[" + this.getName() + "]:" + i);
                }
                try {
                    LdapContext cntx = tdsContext.newInstance(null);
                    this.setUserPreferences(cntx, "adsadminPref_" + this.getName(), hMap, i);
                    cntx.close();
                    continue;
                }
                catch (NamingException e) {
                    this._logger.log((Priority)Level.ERROR, (Object)(this.getName() + " : loop " + i));
                    break;
                }
                catch (Exception ex) {
                    this._logger.log((Priority)Level.ERROR, (Object)(this.getName() + " : loop " + i));
                    break;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        System.out.println("Thread[" + this.getName() + "] ended at " + System.currentTimeMillis() % 1000L);
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        t.printStackTrace(pw);
        pw.flush();
        sw.flush();
        return sw.toString();
    }

    private static LdapContext getContext() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        InitialLdapContext context = null;
        String adminName = "uid=admin,ou=system";
        String adminPassword = "secret";
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", adminName);
        env.put("java.naming.security.credentials", adminPassword);
        env.put("java.naming.provider.url", "ldap://localhost:10389");
        env.put("com.sun.jndi.ldap.connect.pool", "true");
        try {
            context = new InitialLdapContext(env, null);
        }
        catch (NamingException ne) {
            System.exit(1);
        }
        return context;
    }

    public void setUserPreferences(LdapContext context, String userName, Map<String, Object> attributes, int count) throws NamingException {
        LdapContext derivedContext = context;
        String bindOp = "cn=" + userName + "," + "ou=system";
        try {
            try {
                this._logger.info((Object)("Unbind[" + count + "]" + bindOp));
                derivedContext.unbind(bindOp);
            }
            catch (CommunicationException ce) {
                System.out.println("Trying to re-connect to RDS");
                this._logger.info((Object)"Trying to re-connect to RDS");
            }
            catch (NameNotFoundException nnf) {
                System.out.println("User: " + userName + " cannot be found in the Ldap server");
                this._logger.info((Object)("User: " + userName + " cannot be found in the Ldap server"));
            }
            try {
                derivedContext.bind(bindOp, attributes);
            }
            catch (CommunicationException ce) {
                System.out.println("Trying to re-connect to RDS");
            }
            catch (NameAlreadyBoundException nab) {
                System.out.println("User: " + userName + " already exists in the Ldap server");
            }
        }
        catch (NamingException ne) {
            this._logger.log((Priority)Level.ERROR, (Object)count);
            throw ne;
        }
    }

    public static void main(String[] args) {
        MultiThreadedTest t1 = null;
        System.out.println(System.currentTimeMillis() % 1000L);
        for (int i = 0; i < 20; ++i) {
            t1 = new MultiThreadedTest(i);
            t1.start();
        }
    }
}

