/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.unit;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.directory.server.configuration.MutableServerStartupConfiguration;
import org.apache.directory.server.core.configuration.ShutdownConfiguration;
import org.apache.directory.server.jndi.ServerContextFactory;
import org.apache.directory.shared.ldap.exception.LdapConfigurationException;
import org.apache.directory.shared.ldap.ldif.LdifIterator;
import org.apache.directory.shared.ldap.ldif.LdifParserImpl;
import org.apache.directory.shared.ldap.message.LockableAttributesImpl;
import org.apache.directory.shared.ldap.name.LdapName;
import org.apache.mina.util.AvailablePortFinder;

public abstract class AbstractServerTest
extends TestCase {
    protected LdapContext sysRoot;
    protected boolean doDelete = true;
    protected MutableServerStartupConfiguration configuration = new MutableServerStartupConfiguration();
    protected int port = -1;

    protected void setUp() throws Exception {
        super.setUp();
        this.doDelete(this.configuration.getWorkingDirectory());
        this.port = AvailablePortFinder.getNextAvailable((int)1024);
        this.configuration.setLdapPort(this.port);
        this.configuration.setShutdownHookEnabled(false);
        this.setSysRoot("uid=admin,ou=system", "secret");
    }

    protected void doDelete(File wkdir) throws IOException {
        if (this.doDelete) {
            if (wkdir.exists()) {
                FileUtils.deleteDirectory((File)wkdir);
            }
            if (wkdir.exists()) {
                throw new IOException("Failed to delete: " + wkdir);
            }
        }
    }

    protected LdapContext setSysRoot(String user, String passwd) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>(this.configuration.toJndiEnvironment());
        env.put("java.naming.security.principal", user);
        env.put("java.naming.security.credentials", passwd);
        env.put("java.naming.security.authentication", "simple");
        return this.setSysRoot(env);
    }

    protected LdapContext setSysRoot(Hashtable env) throws NamingException {
        Hashtable<String, String> envFinal = new Hashtable<String, String>(env);
        envFinal.put("java.naming.provider.url", "ou=system");
        envFinal.put("java.naming.factory.initial", ServerContextFactory.class.getName());
        this.sysRoot = new InitialLdapContext(envFinal, null);
        return this.sysRoot;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.provider.url", "ou=system");
        env.put("java.naming.factory.initial", "org.apache.directory.server.jndi.ServerContextFactory");
        env.putAll(new ShutdownConfiguration().toJndiEnvironment());
        env.put("java.naming.security.principal", "uid=admin,ou=system");
        env.put("java.naming.security.credentials", "secret");
        try {
            new InitialContext(env);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sysRoot = null;
        this.doDelete(this.configuration.getWorkingDirectory());
        this.configuration = new MutableServerStartupConfiguration();
    }

    protected void importLdif(InputStream in) throws NamingException {
        Hashtable env = new Hashtable();
        env.putAll(this.sysRoot.getEnvironment());
        InitialLdapContext ctx = new InitialLdapContext(env, null);
        LdifParserImpl parser = new LdifParserImpl();
        try {
            LdifIterator iterator = new LdifIterator(in);
            while (iterator.hasNext()) {
                LockableAttributesImpl attributes = new LockableAttributesImpl();
                String ldif = (String)iterator.next();
                parser.parse((Attributes)attributes, ldif);
                LdapName dn = new LdapName((String)attributes.remove("dn").get());
                dn.remove(0);
                ctx.createSubcontext((Name)dn, (Attributes)attributes);
            }
        }
        catch (Exception e) {
            String msg = "failed while trying to parse system ldif file";
            LdapConfigurationException ne = new LdapConfigurationException(msg);
            ne.setRootCause(e);
            throw ne;
        }
    }
}

