/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.unit;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import javax.naming.ConfigurationException;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.directory.server.configuration.MutableServerStartupConfiguration;
import org.apache.directory.server.core.configuration.ShutdownConfiguration;
import org.apache.directory.server.jndi.ServerContextFactory;
import org.apache.directory.shared.ldap.exception.LdapConfigurationException;
import org.apache.directory.shared.ldap.ldif.Entry;
import org.apache.directory.shared.ldap.ldif.LdifReader;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.mina.util.AvailablePortFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServerTest
extends TestCase {
    private static final Logger log = LoggerFactory.getLogger(AbstractServerTest.class);
    private static final List<Entry> EMPTY_LIST = Collections.unmodifiableList(new ArrayList(0));
    private static final String CTX_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    protected LdapContext sysRoot;
    protected LdapContext rootDSE;
    protected LdapContext schemaRoot;
    private boolean serverOnline = false;
    protected boolean doDelete = true;
    protected MutableServerStartupConfiguration configuration = new MutableServerStartupConfiguration();
    protected int port = -1;

    public boolean isServerOnline() {
        return this.serverOnline;
    }

    protected List<Entry> loadTestLdif(boolean verifyEntries) throws NamingException {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(((Object)((Object)this)).getClass().getSimpleName() + ".ldif");
        if (in == null) {
            return EMPTY_LIST;
        }
        if (!this.serverOnline) {
            throw new ConfigurationException("The server has not been started - cannot add entries.");
        }
        LdifReader ldifReader = new LdifReader(in);
        ArrayList<Entry> entries = new ArrayList<Entry>();
        while (ldifReader.hasNext()) {
            Entry entry = ldifReader.next();
            this.rootDSE.createSubcontext(entry.getDn(), entry.getAttributes());
            if (verifyEntries) {
                this.verify(entry);
                log.info("Successfully verified addition of entry {}", (Object)entry.getDn());
            } else {
                log.info("Added entry {} without verification", (Object)entry.getDn());
            }
            entries.add(entry);
        }
        return entries;
    }

    protected void verify(Entry entry) throws NamingException {
        Attributes readAttributes = this.rootDSE.getAttributes(entry.getDn());
        NamingEnumeration<String> readIds = entry.getAttributes().getIDs();
        while (readIds.hasMore()) {
            String id = readIds.next();
            Attribute readAttribute = readAttributes.get(id);
            Attribute origAttribute = entry.getAttributes().get(id);
            for (int ii = 0; ii < origAttribute.size(); ++ii) {
                if (readAttribute.contains(origAttribute.get(ii))) continue;
                log.error("Failed to verify entry addition of {}. {} attribute in original entry missing from read entry.", (Object)entry.getDn(), (Object)id);
                throw new AssertionFailedError("Failed to verify entry addition of " + entry.getDn());
            }
        }
    }

    protected LdapContext getWiredContext() throws NamingException {
        return this.getWiredContext("uid=admin,ou=system", "secret");
    }

    protected LdapContext getWiredContext(String bindPrincipalDn, String password) throws NamingException {
        if (!this.serverOnline) {
            throw new ConfigurationException("The server is not online! Cannot connect to it.");
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", CTX_FACTORY);
        env.put("java.naming.provider.url", "ldap://localhost:" + this.port);
        env.put("java.naming.security.principal", bindPrincipalDn);
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.security.authentication", "simple");
        return new InitialLdapContext(env, null);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.doDelete(this.configuration.getWorkingDirectory());
        this.port = AvailablePortFinder.getNextAvailable((int)1024);
        this.configuration.getLdapConfiguration().setIpPort(this.port);
        this.configuration.setShutdownHookEnabled(false);
        try {
            this.setContexts("uid=admin,ou=system", "secret");
            this.serverOnline = true;
        }
        catch (Exception e) {
            this.serverOnline = false;
            throw e;
        }
    }

    protected void doDelete(File wkdir) throws IOException {
        if (this.doDelete) {
            if (wkdir.exists()) {
                FileUtils.deleteDirectory((File)wkdir);
            }
            if (wkdir.exists()) {
                throw new IOException("Failed to delete: " + wkdir);
            }
        }
    }

    protected void setContexts(String user, String passwd) throws NamingException {
        Hashtable<String, Object> env = new Hashtable<String, Object>(this.configuration.toJndiEnvironment());
        env.put("java.naming.security.principal", user);
        env.put("java.naming.security.credentials", passwd);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.factory.initial", ServerContextFactory.class.getName());
        this.setContexts(env);
    }

    protected void setContexts(Hashtable<String, Object> env) throws NamingException {
        Hashtable<String, Object> envFinal = new Hashtable<String, Object>(env);
        envFinal.put("java.naming.provider.url", "ou=system");
        this.sysRoot = new InitialLdapContext(envFinal, null);
        envFinal.put("java.naming.provider.url", "");
        this.rootDSE = new InitialLdapContext(envFinal, null);
        envFinal.put("java.naming.provider.url", "ou=schema");
        this.schemaRoot = new InitialLdapContext(envFinal, null);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.provider.url", "ou=system");
        env.put("java.naming.factory.initial", "org.apache.directory.server.jndi.ServerContextFactory");
        env.putAll(new ShutdownConfiguration().toJndiEnvironment());
        env.put("java.naming.security.principal", "uid=admin,ou=system");
        env.put("java.naming.security.credentials", "secret");
        try {
            new InitialContext(env);
            this.serverOnline = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sysRoot = null;
        this.doDelete(this.configuration.getWorkingDirectory());
        this.configuration = new MutableServerStartupConfiguration();
    }

    protected void importLdif(InputStream in) throws NamingException {
        try {
            LdifReader iterator = new LdifReader(in);
            while (iterator.hasNext()) {
                Entry entry = (Entry)iterator.next();
                LdapDN dn = new LdapDN(entry.getDn());
                this.rootDSE.createSubcontext((Name)dn, entry.getAttributes());
            }
        }
        catch (Exception e) {
            String msg = "failed while trying to parse system ldif file";
            LdapConfigurationException ne = new LdapConfigurationException(msg);
            ne.setRootCause(e);
            throw ne;
        }
    }

    protected void injectEntries(String ldif) throws NamingException {
        LdifReader reader = new LdifReader();
        List entries = reader.parseLdif(ldif);
        for (Entry entry : entries) {
            this.rootDSE.createSubcontext((Name)new LdapDN(entry.getDn()), entry.getAttributes());
        }
    }
}

