/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.unit;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.jndi.CoreContextFactory;
import org.apache.directory.server.ldap.ExtendedOperationHandler;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.ldap.support.extended.StartTlsHandler;
import org.apache.directory.server.ldap.support.extended.StoredProcedureExtendedOperationHandler;
import org.apache.directory.server.protocol.shared.SocketAcceptor;
import org.apache.directory.shared.ldap.exception.LdapConfigurationException;
import org.apache.directory.shared.ldap.ldif.LdifEntry;
import org.apache.directory.shared.ldap.ldif.LdifReader;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.mina.util.AvailablePortFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServerTest
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractServerTest.class);
    private static final List<LdifEntry> EMPTY_LIST = Collections.unmodifiableList(new ArrayList(0));
    private static final String CTX_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    protected LdapContext sysRoot;
    protected LdapContext rootDSE;
    protected LdapContext schemaRoot;
    protected boolean doDelete = true;
    protected int port = -1;
    private static int start;
    private static long t0;
    protected static int nbTests;
    protected DirectoryService directoryService;
    protected SocketAcceptor socketAcceptor;
    protected LdapServer ldapServer;

    protected List<LdifEntry> loadTestLdif(boolean verifyEntries) throws NamingException {
        return this.loadLdif(((Object)((Object)this)).getClass().getResourceAsStream(((Object)((Object)this)).getClass().getSimpleName() + ".ldif"), verifyEntries);
    }

    protected List<LdifEntry> loadLdif(InputStream in, boolean verifyEntries) throws NamingException {
        if (in == null) {
            return EMPTY_LIST;
        }
        LdifReader ldifReader = new LdifReader(in);
        ArrayList<LdifEntry> entries = new ArrayList<LdifEntry>();
        while (ldifReader.hasNext()) {
            LdifEntry entry = ldifReader.next();
            this.rootDSE.createSubcontext(entry.getDn(), entry.getAttributes());
            if (verifyEntries) {
                this.verify(entry);
                LOG.info("Successfully verified addition of entry {}", (Object)entry.getDn());
            } else {
                LOG.info("Added entry {} without verification", (Object)entry.getDn());
            }
            entries.add(entry);
        }
        return entries;
    }

    protected void verify(LdifEntry entry) throws NamingException {
        Attributes readAttributes = this.rootDSE.getAttributes(entry.getDn());
        NamingEnumeration<String> readIds = entry.getAttributes().getIDs();
        while (readIds.hasMore()) {
            String id = readIds.next();
            Attribute readAttribute = readAttributes.get(id);
            Attribute origAttribute = entry.getAttributes().get(id);
            for (int ii = 0; ii < origAttribute.size(); ++ii) {
                if (readAttribute.contains(origAttribute.get(ii))) continue;
                LOG.error("Failed to verify entry addition of {}. {} attribute in original entry missing from read entry.", (Object)entry.getDn(), (Object)id);
                throw new AssertionFailedError("Failed to verify entry addition of " + entry.getDn());
            }
        }
    }

    protected LdapContext getWiredContext() throws NamingException {
        return this.getWiredContext("uid=admin,ou=system", "secret");
    }

    protected LdapContext getWiredContext(String bindPrincipalDn, String password) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", CTX_FACTORY);
        env.put("java.naming.provider.url", "ldap://localhost:" + this.port);
        env.put("java.naming.security.principal", bindPrincipalDn);
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.security.authentication", "simple");
        return new InitialLdapContext(env, null);
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (start == 0) {
            t0 = System.currentTimeMillis();
        }
        ++start;
        this.directoryService = new DefaultDirectoryService();
        this.directoryService.setShutdownHookEnabled(false);
        this.socketAcceptor = new SocketAcceptor(null);
        this.ldapServer = new LdapServer();
        this.ldapServer.setSocketAcceptor(this.socketAcceptor);
        this.ldapServer.setDirectoryService(this.directoryService);
        this.port = AvailablePortFinder.getNextAvailable((int)1024);
        this.ldapServer.setIpPort(this.port);
        this.doDelete(this.directoryService.getWorkingDirectory());
        this.configureDirectoryService();
        this.directoryService.startup();
        this.configureLdapServer();
        this.ldapServer.addExtendedOperationHandler((ExtendedOperationHandler)new StartTlsHandler());
        this.ldapServer.addExtendedOperationHandler((ExtendedOperationHandler)new StoredProcedureExtendedOperationHandler());
        this.ldapServer.start();
        this.setContexts("uid=admin,ou=system", "secret");
    }

    protected void configureDirectoryService() throws NamingException {
    }

    protected void configureLdapServer() {
    }

    protected void setAllowAnonymousAccess(boolean anonymousAccess) {
        this.directoryService.setAllowAnonymousAccess(anonymousAccess);
        this.ldapServer.setAllowAnonymousAccess(anonymousAccess);
    }

    protected void doDelete(File wkdir) throws IOException {
        if (this.doDelete) {
            if (wkdir.exists()) {
                FileUtils.deleteDirectory((File)wkdir);
            }
            if (wkdir.exists()) {
                throw new IOException("Failed to delete: " + wkdir);
            }
        }
    }

    protected void setContexts(String user, String passwd) throws NamingException {
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        env.put(DirectoryService.JNDI_KEY, this.directoryService);
        env.put("java.naming.security.principal", user);
        env.put("java.naming.security.credentials", passwd);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.factory.initial", CoreContextFactory.class.getName());
        this.setContexts(env);
    }

    protected void setContexts(Hashtable<String, Object> env) throws NamingException {
        Hashtable<String, Object> envFinal = new Hashtable<String, Object>(env);
        envFinal.put("java.naming.provider.url", "ou=system");
        this.sysRoot = new InitialLdapContext(envFinal, null);
        envFinal.put("java.naming.provider.url", "");
        this.rootDSE = new InitialLdapContext(envFinal, null);
        envFinal.put("java.naming.provider.url", "ou=schema");
        this.schemaRoot = new InitialLdapContext(envFinal, null);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.ldapServer.stop();
        try {
            this.directoryService.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.sysRoot = null;
        if (start >= nbTests) {
            System.out.println("Delta = " + (System.currentTimeMillis() - t0));
        }
    }

    protected void importLdif(InputStream in) throws NamingException {
        try {
            LdifReader iterator = new LdifReader(in);
            while (iterator.hasNext()) {
                LdifEntry entry = (LdifEntry)iterator.next();
                LdapDN dn = new LdapDN(entry.getDn());
                this.rootDSE.createSubcontext((Name)dn, entry.getAttributes());
            }
        }
        catch (Exception e) {
            String msg = "failed while trying to parse system ldif file";
            LdapConfigurationException ne = new LdapConfigurationException(msg);
            ne.setRootCause(e);
            throw ne;
        }
    }

    protected void injectEntries(String ldif) throws NamingException {
        LdifReader reader = new LdifReader();
        List entries = reader.parseLdif(ldif);
        for (LdifEntry entry : entries) {
            this.rootDSE.createSubcontext((Name)new LdapDN(entry.getDn()), entry.getAttributes());
        }
    }

    static {
        nbTests = 10000;
    }
}

