/*
 * Decompiled with CFR 0.152.
 */
package jdbm.btree;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import jdbm.RecordManager;
import jdbm.btree.BPage;
import jdbm.helper.Serializer;
import jdbm.helper.Tuple;
import jdbm.helper.TupleBrowser;
import org.apache.directory.server.i18n.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTree<K, V>
implements Externalizable {
    private static final boolean DEBUG = false;
    static final long serialVersionUID = 1L;
    public static final int DEFAULT_SIZE = 16;
    protected transient RecordManager recordManager;
    private transient long recordId;
    private Comparator<K> comparator;
    protected Serializer keySerializer;
    protected Serializer valueSerializer;
    private int bTreeHeight;
    private transient long rootId;
    protected int pageSize;
    protected AtomicInteger nbEntries;
    private transient BPage<K, V> bpageSerializer;

    public BTree() {
    }

    public BTree(RecordManager recman, Comparator<K> comparator) throws IOException {
        this.createInstance(recman, comparator, null, null, 16);
    }

    public BTree(RecordManager recman, Comparator<K> comparator, Serializer keySerializer, Serializer valueSerializer) throws IOException {
        this.createInstance(recman, comparator, keySerializer, valueSerializer, 16);
    }

    public BTree(RecordManager recman, Comparator<K> comparator, Serializer keySerializer, Serializer valueSerializer, int pageSize) throws IOException {
        this.createInstance(recman, comparator, keySerializer, valueSerializer, pageSize);
    }

    private void createInstance(RecordManager recordManager, Comparator<K> comparator, Serializer keySerializer, Serializer valueSerializer, int pageSize) throws IOException {
        if (recordManager == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_517, new Object[0]));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_518, new Object[0]));
        }
        if (!(comparator instanceof Serializable)) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_519, new Object[0]));
        }
        if ((pageSize & 1) != 0) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_522, new Object[0]));
        }
        this.recordManager = recordManager;
        this.comparator = comparator;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.pageSize = pageSize;
        this.bpageSerializer = new BPage();
        this.bpageSerializer.btree = this;
        this.nbEntries = new AtomicInteger(0);
        this.recordId = recordManager.insert(this);
    }

    public void setPageSize(int pageSize) {
        this.pageSize = (pageSize & 1) != 0 ? 16 : pageSize;
    }

    public BTree<K, V> load(RecordManager recman, long recid) throws IOException {
        BTree btree = (BTree)recman.fetch(recid);
        btree.recordId = recid;
        btree.recordManager = recman;
        btree.bpageSerializer = new BPage();
        btree.bpageSerializer.btree = btree;
        return btree;
    }

    public synchronized Object insert(K key, V value, boolean replace) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_523, new Object[0]));
        }
        if (value == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_524, new Object[0]));
        }
        BPage<Object, Object> rootPage = this.getRoot();
        if (rootPage == null) {
            rootPage = new BPage<K, V>(this, key, value);
            this.rootId = rootPage.getRecordId();
            this.bTreeHeight = 1;
            this.nbEntries.set(1);
            this.recordManager.update(this.recordId, this);
            return null;
        }
        BPage.InsertResult<K, V> insert = rootPage.insert(this.bTreeHeight, key, value, replace);
        boolean dirty = false;
        if (insert.overflow != null) {
            rootPage = new BPage(this, rootPage, insert.overflow);
            this.rootId = rootPage.getRecordId();
            ++this.bTreeHeight;
            dirty = true;
        }
        if (insert.existing == null) {
            this.nbEntries.getAndIncrement();
            dirty = true;
        }
        if (dirty) {
            this.recordManager.update(this.recordId, this);
        }
        return insert.existing;
    }

    public synchronized V remove(K key) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_523, new Object[0]));
        }
        BPage<K, V> rootPage = this.getRoot();
        if (rootPage == null) {
            return null;
        }
        boolean dirty = false;
        BPage.RemoveResult<V> remove = rootPage.remove(this.bTreeHeight, key);
        if (remove.underflow && rootPage.isEmpty()) {
            --this.bTreeHeight;
            dirty = true;
            this.recordManager.delete(this.rootId);
            this.rootId = this.bTreeHeight == 0 ? 0L : rootPage.childBPage(this.pageSize - 1).getRecordId();
        }
        if (remove.value != null) {
            this.nbEntries.getAndDecrement();
            dirty = true;
        }
        if (dirty) {
            this.recordManager.update(this.recordId, this);
        }
        return remove.value;
    }

    public synchronized V find(K key) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_523, new Object[0]));
        }
        BPage<K, V> rootPage = this.getRoot();
        if (rootPage == null) {
            return null;
        }
        Tuple<Object, Object> tuple = new Tuple<Object, Object>(null, null);
        TupleBrowser<Object, Object> browser = rootPage.find(this.bTreeHeight, key);
        if (browser.getNext(tuple)) {
            if (this.comparator.compare(key, tuple.getKey()) != 0) {
                return null;
            }
            return tuple.getValue();
        }
        return null;
    }

    public synchronized Tuple<K, V> findGreaterOrEqual(K key) throws IOException {
        if (key == null) {
            return null;
        }
        Tuple<Object, Object> tuple = new Tuple<Object, Object>(null, null);
        TupleBrowser<Object, Object> browser = this.browse(key);
        if (browser.getNext(tuple)) {
            return tuple;
        }
        return null;
    }

    public synchronized TupleBrowser<K, V> browse() throws IOException {
        BPage<K, V> rootPage = this.getRoot();
        if (rootPage == null) {
            return new EmptyBrowser(){};
        }
        TupleBrowser<K, V> browser = rootPage.findFirst();
        return browser;
    }

    public synchronized TupleBrowser<K, V> browse(K key) throws IOException {
        BPage<K, V> rootPage = this.getRoot();
        if (rootPage == null) {
            return new EmptyBrowser(){};
        }
        TupleBrowser<K, V> browser = rootPage.find(this.bTreeHeight, key);
        return browser;
    }

    public int size() {
        return this.nbEntries.get();
    }

    public long getRecordId() {
        return this.recordId;
    }

    private BPage<K, V> getRoot() throws IOException {
        if (this.rootId == 0L) {
            return null;
        }
        BPage root = (BPage)this.recordManager.fetch(this.rootId, this.bpageSerializer);
        root.setRecordId(this.rootId);
        root.btree = this;
        return root;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.comparator = (Comparator)in.readObject();
        this.keySerializer = (Serializer)in.readObject();
        this.valueSerializer = (Serializer)in.readObject();
        this.bTreeHeight = in.readInt();
        this.rootId = in.readLong();
        this.pageSize = in.readInt();
        this.nbEntries = new AtomicInteger(in.readInt());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.comparator);
        out.writeObject(this.keySerializer);
        out.writeObject(this.valueSerializer);
        out.writeInt(this.bTreeHeight);
        out.writeLong(this.rootId);
        out.writeInt(this.pageSize);
        out.writeInt(this.nbEntries.get());
    }

    public void setValueSerializer(Serializer valueSerializer) {
        this.valueSerializer = valueSerializer;
    }

    public Comparator<K> getComparator() {
        return this.comparator;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BTree");
        sb.append("(height:").append(this.bTreeHeight);
        sb.append(", pageSize:").append(this.pageSize);
        sb.append(", nbEntries:").append(this.nbEntries);
        sb.append(", rootId:").append(this.rootId);
        sb.append(", comparator:");
        if (this.comparator == null) {
            sb.append("null");
        } else {
            sb.append(this.comparator.getClass().getSimpleName());
        }
        sb.append(", keySerializer:");
        if (this.keySerializer == null) {
            sb.append("null");
        } else {
            sb.append(this.keySerializer.getClass().getSimpleName());
        }
        sb.append(", valueSerializer:");
        if (this.valueSerializer == null) {
            sb.append("null");
        } else {
            sb.append(this.valueSerializer.getClass().getSimpleName());
        }
        sb.append(")\n");
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EmptyBrowser
    extends TupleBrowser<K, V> {
        EmptyBrowser() {
        }

        @Override
        public boolean getNext(Tuple<K, V> tuple) {
            return false;
        }

        @Override
        public boolean getPrevious(Tuple<K, V> tuple) {
            return false;
        }
    }
}

