/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.activemq.filter.DestinationNode;

public class AnyChildDestinationNode
implements DestinationNode {
    private DestinationNode node;

    public AnyChildDestinationNode(DestinationNode node) {
        this.node = node;
    }

    @Override
    public void appendMatchingValues(Set answer, String[] paths, int startIndex) {
        for (DestinationNode child : this.getChildNodes()) {
            child.appendMatchingValues(answer, paths, startIndex);
        }
    }

    @Override
    public void appendMatchingWildcards(Set answer, String[] paths, int startIndex) {
        for (DestinationNode child : this.getChildNodes()) {
            child.appendMatchingWildcards(answer, paths, startIndex);
        }
    }

    @Override
    public void appendDescendantValues(Set answer) {
        for (DestinationNode child : this.getChildNodes()) {
            child.appendDescendantValues(answer);
        }
    }

    @Override
    public DestinationNode getChild(String path) {
        final ArrayList<DestinationNode> list = new ArrayList<DestinationNode>();
        for (DestinationNode child : this.getChildNodes()) {
            DestinationNode answer = child.getChild(path);
            if (answer == null) continue;
            list.add(answer);
        }
        if (!list.isEmpty()) {
            return new AnyChildDestinationNode(this){

                @Override
                protected Collection getChildNodes() {
                    return list;
                }
            };
        }
        return null;
    }

    @Override
    public Collection getDesendentValues() {
        ArrayList answer = new ArrayList();
        for (DestinationNode child : this.getChildNodes()) {
            answer.addAll(child.getDesendentValues());
        }
        return answer;
    }

    @Override
    public Collection getValues() {
        ArrayList answer = new ArrayList();
        for (DestinationNode child : this.getChildNodes()) {
            answer.addAll(child.getValues());
        }
        return answer;
    }

    @Override
    public Collection getChildren() {
        ArrayList answer = new ArrayList();
        for (DestinationNode child : this.getChildNodes()) {
            answer.addAll(child.getChildren());
        }
        return answer;
    }

    @Override
    public Collection removeDesendentValues() {
        ArrayList answer = new ArrayList();
        for (DestinationNode child : this.getChildNodes()) {
            answer.addAll(child.removeDesendentValues());
        }
        return answer;
    }

    @Override
    public Collection removeValues() {
        ArrayList answer = new ArrayList();
        for (DestinationNode child : this.getChildNodes()) {
            answer.addAll(child.removeValues());
        }
        return answer;
    }

    protected Collection getChildNodes() {
        return this.node.getChildren();
    }
}

