/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import org.apache.activemq.transport.stomp.StompFrame;
import org.apache.activemq.transport.stomp.StompWireFormat;

public class StompConnection {
    public static final long RECEIVE_TIMEOUT = 10000L;
    private Socket stompSocket;
    private ByteArrayOutputStream inputBuffer = new ByteArrayOutputStream();

    public void open(String host, int port) throws IOException, UnknownHostException {
        this.open(new Socket(host, port));
    }

    public void open(Socket socket) {
        this.stompSocket = socket;
    }

    public void close() throws IOException {
        if (this.stompSocket != null) {
            this.stompSocket.close();
            this.stompSocket = null;
        }
    }

    public void sendFrame(String data) throws Exception {
        byte[] bytes = data.getBytes("UTF-8");
        OutputStream outputStream = this.stompSocket.getOutputStream();
        outputStream.write(bytes);
        outputStream.write(0);
        outputStream.flush();
    }

    public void sendFrame(String frame, byte[] data) throws Exception {
        byte[] bytes = frame.getBytes("UTF-8");
        OutputStream outputStream = this.stompSocket.getOutputStream();
        outputStream.write(bytes);
        outputStream.write(data);
        outputStream.write(0);
        outputStream.flush();
    }

    public StompFrame receive() throws Exception {
        return this.receive(10000L);
    }

    public StompFrame receive(long timeOut) throws Exception {
        this.stompSocket.setSoTimeout((int)timeOut);
        InputStream is = this.stompSocket.getInputStream();
        StompWireFormat wf = new StompWireFormat();
        DataInputStream dis = new DataInputStream(is);
        return (StompFrame)wf.unmarshal(dis);
    }

    public String receiveFrame() throws Exception {
        return this.receiveFrame(10000L);
    }

    public String receiveFrame(long timeOut) throws Exception {
        this.stompSocket.setSoTimeout((int)timeOut);
        InputStream is = this.stompSocket.getInputStream();
        int c = 0;
        while (true) {
            if ((c = is.read()) < 0) {
                throw new IOException("socket closed.");
            }
            if (c == 0) {
                c = is.read();
                if (c == 10) {
                    return this.stringFromBuffer(this.inputBuffer);
                }
                this.inputBuffer.write(0);
                this.inputBuffer.write(c);
                continue;
            }
            this.inputBuffer.write(c);
        }
    }

    private String stringFromBuffer(ByteArrayOutputStream inputBuffer) throws Exception {
        byte[] ba = inputBuffer.toByteArray();
        inputBuffer.reset();
        return new String(ba, "UTF-8");
    }

    public Socket getStompSocket() {
        return this.stompSocket;
    }

    public void setStompSocket(Socket stompSocket) {
        this.stompSocket = stompSocket;
    }

    public void connect(String username, String password) throws Exception {
        this.connect(username, password, null);
    }

    public void connect(String username, String password, String client) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("login", username);
        headers.put("passcode", password);
        if (client != null) {
            headers.put("client-id", client);
        }
        StompFrame frame = new StompFrame("CONNECT", headers);
        this.sendFrame(frame.format());
        StompFrame connect = this.receive();
        if (!connect.getAction().equals("CONNECTED")) {
            throw new Exception("Not connected: " + connect.getBody());
        }
    }

    public void disconnect() throws Exception {
        StompFrame frame = new StompFrame("DISCONNECT");
        this.sendFrame(frame.format());
    }

    public void send(String destination, String message) throws Exception {
        this.send(destination, message, null, null);
    }

    public void send(String destination, String message, String transaction, HashMap<String, String> headers) throws Exception {
        if (headers == null) {
            headers = new HashMap();
        }
        headers.put("destination", destination);
        if (transaction != null) {
            headers.put("transaction", transaction);
        }
        StompFrame frame = new StompFrame("SEND", headers, message.getBytes());
        this.sendFrame(frame.format());
    }

    public void subscribe(String destination) throws Exception {
        this.subscribe(destination, null, null);
    }

    public void subscribe(String destination, String ack) throws Exception {
        this.subscribe(destination, ack, new HashMap<String, String>());
    }

    public void subscribe(String destination, String ack, HashMap<String, String> headers) throws Exception {
        if (headers == null) {
            headers = new HashMap();
        }
        headers.put("destination", destination);
        if (ack != null) {
            headers.put("ack", ack);
        }
        StompFrame frame = new StompFrame("SUBSCRIBE", headers);
        this.sendFrame(frame.format());
    }

    public void unsubscribe(String destination) throws Exception {
        this.unsubscribe(destination, null);
    }

    public void unsubscribe(String destination, HashMap<String, String> headers) throws Exception {
        if (headers == null) {
            headers = new HashMap();
        }
        headers.put("destination", destination);
        StompFrame frame = new StompFrame("UNSUBSCRIBE", headers);
        this.sendFrame(frame.format());
    }

    public void begin(String transaction) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("transaction", transaction);
        StompFrame frame = new StompFrame("BEGIN", headers);
        this.sendFrame(frame.format());
    }

    public void abort(String transaction) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("transaction", transaction);
        StompFrame frame = new StompFrame("ABORT", headers);
        this.sendFrame(frame.format());
    }

    public void commit(String transaction) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("transaction", transaction);
        StompFrame frame = new StompFrame("COMMIT", headers);
        this.sendFrame(frame.format());
    }

    public void ack(StompFrame frame) throws Exception {
        this.ack(frame.getHeaders().get("message-id"), null);
    }

    public void ack(StompFrame frame, String transaction) throws Exception {
        this.ack(frame.getHeaders().get("message-id"), transaction);
    }

    public void ack(String messageId) throws Exception {
        this.ack(messageId, null);
    }

    public void ack(String messageId, String transaction) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("message-id", messageId);
        if (transaction != null) {
            headers.put("transaction", transaction);
        }
        StompFrame frame = new StompFrame("ACK", headers);
        this.sendFrame(frame.format());
    }

    protected String appendHeaders(HashMap<String, Object> headers) {
        StringBuffer result = new StringBuffer();
        for (String key : headers.keySet()) {
            result.append(key + ":" + headers.get(key) + "\n");
        }
        result.append("\n");
        return result.toString();
    }
}

