/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz.support;

import java.util.Collection;
import java.util.Iterator;
import org.apache.directory.server.core.authz.support.ACITupleFilter;
import org.apache.directory.server.core.authz.support.AciContext;
import org.apache.directory.server.core.authz.support.OperationScope;
import org.apache.directory.shared.ldap.aci.ACITuple;
import org.apache.directory.shared.ldap.aci.MicroOperation;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MicroOperationFilter
implements ACITupleFilter {
    @Override
    public Collection<ACITuple> filter(AciContext aciContext, OperationScope scope, Entry userEntry) throws LdapException {
        if (aciContext.getAciTuples().size() == 0) {
            return aciContext.getAciTuples();
        }
        Iterator<ACITuple> i = aciContext.getAciTuples().iterator();
        while (i.hasNext()) {
            ACITuple tuple = i.next();
            boolean retain = true;
            for (MicroOperation microOp : aciContext.getMicroOperations()) {
                if (tuple.getMicroOperations().contains((Object)microOp)) continue;
                retain = false;
                break;
            }
            if (retain) continue;
            i.remove();
        }
        return aciContext.getAciTuples();
    }
}

