/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz.support;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.directory.server.core.authz.support.ACITupleFilter;
import org.apache.directory.server.core.authz.support.AciContext;
import org.apache.directory.server.core.authz.support.OperationScope;
import org.apache.directory.shared.ldap.aci.ACITuple;
import org.apache.directory.shared.ldap.aci.UserClass;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MostSpecificUserClassFilter
implements ACITupleFilter {
    @Override
    public Collection<ACITuple> filter(AciContext aciContext, OperationScope scope, Entry userEntry) throws LdapException {
        if (aciContext.getAciTuples().size() <= 1) {
            return aciContext.getAciTuples();
        }
        ArrayList<ACITuple> filteredTuples = new ArrayList<ACITuple>();
        block0: for (ACITuple tuple : aciContext.getAciTuples()) {
            for (UserClass userClass : tuple.getUserClasses()) {
                if (!(userClass instanceof UserClass.Name) && !(userClass instanceof UserClass.ThisEntry)) continue;
                filteredTuples.add(tuple);
                continue block0;
            }
        }
        if (filteredTuples.size() > 0) {
            return filteredTuples;
        }
        block2: for (ACITuple tuple : aciContext.getAciTuples()) {
            for (UserClass userClass : tuple.getUserClasses()) {
                if (!(userClass instanceof UserClass.UserGroup)) continue;
                filteredTuples.add(tuple);
                continue block2;
            }
        }
        if (filteredTuples.size() > 0) {
            return filteredTuples;
        }
        block4: for (ACITuple tuple : aciContext.getAciTuples()) {
            for (UserClass userClass : tuple.getUserClasses()) {
                if (!(userClass instanceof UserClass.Subtree)) continue;
                filteredTuples.add(tuple);
                continue block4;
            }
        }
        if (filteredTuples.size() > 0) {
            return filteredTuples;
        }
        return aciContext.getAciTuples();
    }
}

