/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz.support;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.directory.server.core.authz.support.ACITupleFilter;
import org.apache.directory.server.core.authz.support.AciContext;
import org.apache.directory.server.core.authz.support.OperationScope;
import org.apache.directory.server.core.subtree.SubtreeEvaluator;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.aci.ACITuple;
import org.apache.directory.shared.ldap.aci.UserClass;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.subtree.SubtreeSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelatedUserClassFilter
implements ACITupleFilter {
    private final SubtreeEvaluator subtreeEvaluator;

    public RelatedUserClassFilter(SubtreeEvaluator subtreeEvaluator) {
        this.subtreeEvaluator = subtreeEvaluator;
    }

    @Override
    public Collection<ACITuple> filter(AciContext aciContext, OperationScope scope, Entry userEntry) throws LdapException {
        if (aciContext.getAciTuples().size() == 0) {
            return aciContext.getAciTuples();
        }
        Iterator<ACITuple> ii = aciContext.getAciTuples().iterator();
        while (ii.hasNext()) {
            ACITuple tuple = ii.next();
            if (tuple.isGrant()) {
                if (this.isRelated(aciContext.getUserGroupNames(), aciContext.getUserDn(), userEntry, aciContext.getEntryDn(), tuple.getUserClasses()) && aciContext.getAuthenticationLevel().compareTo(tuple.getAuthenticationLevel()) >= 0) continue;
                ii.remove();
                continue;
            }
            if (this.isRelated(aciContext.getUserGroupNames(), aciContext.getUserDn(), userEntry, aciContext.getEntryDn(), tuple.getUserClasses()) || aciContext.getAuthenticationLevel().compareTo(tuple.getAuthenticationLevel()) < 0) continue;
            ii.remove();
        }
        return aciContext.getAciTuples();
    }

    private boolean isRelated(Collection<Dn> userGroupNames, Dn userName, Entry userEntry, Dn entryName, Collection<UserClass> userClasses) throws LdapException {
        for (UserClass userClass : userClasses) {
            if (userClass == UserClass.ALL_USERS) {
                return true;
            }
            if (userClass == UserClass.THIS_ENTRY) {
                if (!userName.equals(entryName)) continue;
                return true;
            }
            if (userClass == UserClass.PARENT_OF_ENTRY) {
                if (!entryName.isDescendantOf(userName)) continue;
                return true;
            }
            if (userClass instanceof UserClass.Name) {
                UserClass.Name nameUserClass = (UserClass.Name)userClass;
                if (!nameUserClass.getNames().contains(userName)) continue;
                return true;
            }
            if (userClass instanceof UserClass.UserGroup) {
                UserClass.UserGroup userGroupUserClass = (UserClass.UserGroup)userClass;
                for (Dn userGroupName : userGroupNames) {
                    Set dns = userGroupUserClass.getNames();
                    if (userGroupName == null) continue;
                    for (Dn dn : dns) {
                        if (!userGroupName.getNormName().equals(dn.getNormName())) continue;
                        return true;
                    }
                }
                continue;
            }
            if (userClass instanceof UserClass.Subtree) {
                UserClass.Subtree subtree = (UserClass.Subtree)userClass;
                if (!this.matchUserClassSubtree(userName, userEntry, subtree)) continue;
                return true;
            }
            throw new InternalError(I18n.err(I18n.ERR_233, userClass.getClass().getName()));
        }
        return false;
    }

    private boolean matchUserClassSubtree(Dn userName, Entry userEntry, UserClass.Subtree subtree) throws LdapException {
        for (SubtreeSpecification subtreeSpec : subtree.getSubtreeSpecifications()) {
            if (!this.subtreeEvaluator.evaluate(subtreeSpec, Dn.ROOT_DSE, userName, userEntry)) continue;
            return true;
        }
        return false;
    }
}

