/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz.support;

import java.util.Collection;
import java.util.Iterator;
import org.apache.directory.server.core.authz.support.ACITupleFilter;
import org.apache.directory.server.core.authz.support.AciContext;
import org.apache.directory.server.core.authz.support.OperationScope;
import org.apache.directory.shared.ldap.aci.ACITuple;
import org.apache.directory.shared.ldap.aci.ProtectedItem;
import org.apache.directory.shared.ldap.aci.protectedItem.RestrictedByElem;
import org.apache.directory.shared.ldap.aci.protectedItem.RestrictedByItem;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.schema.AttributeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestrictedByFilter
implements ACITupleFilter {
    @Override
    public Collection<ACITuple> filter(AciContext aciContext, OperationScope scope, Entry userEntry) throws LdapException {
        if (scope != OperationScope.ATTRIBUTE_TYPE_AND_VALUE) {
            return aciContext.getAciTuples();
        }
        if (aciContext.getAciTuples().size() == 0) {
            return aciContext.getAciTuples();
        }
        Iterator<ACITuple> ii = aciContext.getAciTuples().iterator();
        while (ii.hasNext()) {
            ACITuple tuple = ii.next();
            if (!tuple.isGrant() || !this.isRemovable(tuple, aciContext.getAttributeType(), aciContext.getAttrValue(), aciContext.getEntry())) continue;
            ii.remove();
        }
        return aciContext.getAciTuples();
    }

    public boolean isRemovable(ACITuple tuple, AttributeType attributeType, Value<?> attrValue, Entry entry) throws LdapException {
        for (ProtectedItem item : tuple.getProtectedItems()) {
            if (!(item instanceof RestrictedByItem)) continue;
            RestrictedByItem rb = (RestrictedByItem)item;
            Iterator<RestrictedByElem> k = rb.iterator();
            while (k.hasNext()) {
                Attribute attr;
                RestrictedByElem rbItem = k.next();
                if (!attributeType.equals(rbItem.getAttributeType()) || (attr = entry.get(rbItem.getValuesIn())) != null && attr.contains(attrValue)) continue;
                return true;
            }
        }
        return false;
    }
}

